/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import org.eclipse.jpt.core.context.orm.OrmXml;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.OrmResource;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;

public class OrmXmlTests
extends ContextModelTestCase {
    public OrmXmlTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.xmlPersistenceUnit().setName("foo");
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.persistenceResource().save(null);
    }

    protected PersistenceXml persistenceXml() {
        return this.rootContext().getPersistenceXml();
    }

    protected OrmXml ormXml() {
        return ((MappingFileRef)this.persistenceUnit().mappingFileRefs().next()).getOrmXml();
    }

    public void testUpdateAddEntityMappings() throws Exception {
        OrmResource ormResource = this.ormResource();
        ormResource.getContents().clear();
        ormResource.save(null);
        OrmXmlTests.assertNull((Object)this.ormXml().getEntityMappings());
        ormResource.getContents().add((Object)OrmFactory.eINSTANCE.createXmlEntityMappings());
        OrmXmlTests.assertNotNull((Object)this.ormXml().getEntityMappings());
    }

    public void testModifyAddEntityMappings() {
        OrmResource ormResource = this.ormResource();
        ormResource.getContents().remove((Object)ormResource.getEntityMappings());
        OrmXmlTests.assertNull((Object)ormResource.getEntityMappings());
        OrmXml ormXml = this.ormXml();
        OrmXmlTests.assertNull((Object)ormXml.getEntityMappings());
        ormXml.addEntityMappings();
        OrmXmlTests.assertNotNull((Object)ormXml.getEntityMappings());
        boolean exceptionThrown = false;
        try {
            ormXml.addEntityMappings();
        }
        catch (IllegalStateException illegalStateException) {
            exceptionThrown = true;
        }
        OrmXmlTests.assertTrue((String)"IllegalStateException was not thrown", (boolean)exceptionThrown);
    }

    public void testUpdateRemoveEntityMappings() throws Exception {
        OrmResource ormResource = this.ormResource();
        OrmXmlTests.assertNotNull((Object)this.ormXml().getEntityMappings());
        ormResource.getContents().clear();
        OrmXmlTests.assertNull((Object)this.ormXml().getEntityMappings());
    }

    public void testModifyRemoveEntityMappings() {
        OrmXml ormXml = this.ormXml();
        OrmXmlTests.assertNotNull((Object)ormXml.getEntityMappings());
        ormXml.removeEntityMappings();
        OrmXmlTests.assertNull((Object)ormXml.getEntityMappings());
        boolean exceptionThrown = false;
        try {
            ormXml.removeEntityMappings();
        }
        catch (IllegalStateException illegalStateException) {
            exceptionThrown = true;
        }
        OrmXmlTests.assertTrue((String)"IllegalStateException was not thrown", (boolean)exceptionThrown);
    }
}

