/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.model;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.GenericJpaModel;
import org.eclipse.jpt.core.internal.JpaModelManager;
import org.eclipse.jpt.core.tests.internal.ProjectUtility;
import org.eclipse.jpt.core.tests.internal.projects.TestFacetedProject;
import org.eclipse.jpt.core.tests.internal.projects.TestPlatformProject;
import org.eclipse.jpt.utility.internal.ClassTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaModelTests
extends TestCase {
    public static final String CR = System.getProperty("line.separator");

    public JpaModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.debug()) {
            this.printName();
        }
        ProjectUtility.deleteAllProjects();
    }

    private boolean debug() {
        Boolean debug = (Boolean)ClassTools.staticFieldValue(JpaModelManager.class, (String)"DEBUG");
        return debug;
    }

    private void printName() {
        String name = this.getName();
        System.out.println();
        System.out.println();
        this.printNameBorder(name);
        System.out.println(name);
        this.printNameBorder(name);
    }

    private void printNameBorder(String name) {
        int i = name.length();
        while (i-- > 0) {
            System.out.print('=');
        }
        System.out.println();
    }

    protected void tearDown() throws Exception {
        ProjectUtility.deleteAllProjects();
        super.tearDown();
    }

    private TestFacetedProject buildTestProject() throws Exception {
        TestFacetedProject testProject = TestFacetedProject.buildFacetedProject(ClassTools.shortClassNameForObject((Object)((Object)this)), true);
        testProject.installFacet("jst.java", "5.0");
        testProject.installFacet("jst.utility", "1.0");
        testProject.createFile((IPath)new Path("src/test.pkg/TestEntity.java"), "package test.pkg; @Entity public class TestEntity {}");
        testProject.createFile((IPath)new Path("src/test.pkg/TestEntity2.java"), "package test.pkg; @Entity public class TestEntity2 {}");
        return testProject;
    }

    private IFile file(TestPlatformProject p, String path) {
        return p.getProject().getFile((IPath)new Path(path));
    }

    public void testJpaModel() {
        JpaModelTests.assertNotNull((Object)JptCorePlugin.getJpaModel());
    }

    public void testFacetInstallUninstall() throws Exception {
        TestFacetedProject testProject = this.buildTestProject();
        JpaModelTests.assertNull((Object)JptCorePlugin.getJpaProject((IProject)testProject.getProject()));
        testProject.installFacet("jpt.jpa", "1.0");
        JpaModelTests.assertEquals((int)1, (int)JptCorePlugin.getJpaModel().jpaProjectsSize());
        JpaProject jpaProject = JptCorePlugin.getJpaProject((IProject)testProject.getProject());
        JpaModelTests.assertNotNull((Object)jpaProject);
        JpaModelTests.assertNotNull((Object)jpaProject.getJpaFile(this.file(testProject, "src/test.pkg/TestEntity.java")));
        JpaModelTests.assertNotNull((Object)jpaProject.getJpaFile(this.file(testProject, "src/test.pkg/TestEntity2.java")));
        testProject.uninstallFacet("jpt.jpa", "1.0");
        JpaModelTests.assertEquals((int)0, (int)JptCorePlugin.getJpaModel().jpaProjectsSize());
        jpaProject = JptCorePlugin.getJpaProject((IProject)testProject.getProject());
        JpaModelTests.assertNull((Object)jpaProject);
    }

    public void testProjectCloseReopen() throws Exception {
        TestFacetedProject testProject = this.buildTestProject();
        testProject.installFacet("jpt.jpa", "1.0");
        testProject.getProject().close(null);
        JpaModelTests.assertFalse((boolean)testProject.getProject().isOpen());
        JpaProject jpaProject = JptCorePlugin.getJpaProject((IProject)testProject.getProject());
        JpaModelTests.assertNull((Object)jpaProject);
        testProject.getProject().open(null);
        jpaProject = JptCorePlugin.getJpaProject((IProject)testProject.getProject());
        JpaModelTests.assertNotNull((Object)jpaProject);
        JpaModelTests.assertNotNull((Object)jpaProject.getJpaFile(this.file(testProject, "src/test.pkg/TestEntity.java")));
        JpaModelTests.assertNotNull((Object)jpaProject.getJpaFile(this.file(testProject, "src/test.pkg/TestEntity2.java")));
    }

    public void testProjectDeleteReimport() throws Exception {
        TestFacetedProject testProject = this.buildTestProject();
        testProject.installFacet("jpt.jpa", "1.0");
        JpaProject jpaProject = JptCorePlugin.getJpaProject((IProject)testProject.getProject());
        JpaModelTests.assertNotNull((Object)jpaProject);
        JpaModelTests.assertEquals((int)1, (int)JptCorePlugin.getJpaModel().jpaProjectsSize());
        testProject.getProject().delete(false, true, null);
        jpaProject = JptCorePlugin.getJpaProject((IProject)testProject.getProject());
        JpaModelTests.assertNull((Object)jpaProject);
        JpaModelTests.assertEquals((int)0, (int)JptCorePlugin.getJpaModel().jpaProjectsSize());
        JpaModelTests.assertEquals((int)0, (int)ResourcesPlugin.getWorkspace().getRoot().getProjects().length);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(testProject.getProject().getName());
        project.create(null);
        JpaModelTests.assertEquals((int)1, (int)ResourcesPlugin.getWorkspace().getRoot().getProjects().length);
        project.open(null);
        JpaModelTests.assertTrue((boolean)project.isOpen());
        JpaModelTests.assertTrue((boolean)JptCorePlugin.projectHasJpaFacet((IProject)project));
        jpaProject = JptCorePlugin.getJpaProject((IProject)project);
        JpaModelTests.assertNotNull((Object)jpaProject);
        JpaModelTests.assertNotNull((Object)jpaProject.getJpaFile(this.file(testProject, "src/test.pkg/TestEntity.java")));
        JpaModelTests.assertNotNull((Object)jpaProject.getJpaFile(this.file(testProject, "src/test.pkg/TestEntity2.java")));
    }

    public void testDEBUG() {
        this.verifyDEBUG(JpaModelManager.class);
        this.verifyDEBUG(GenericJpaModel.class);
    }

    private void verifyDEBUG(Class<?> clazz) {
        JpaModelTests.assertFalse((String)("Recompile with \"DEBUG = false\": " + clazz.getName()), (boolean)((Boolean)ClassTools.staticFieldValue(clazz, (String)"DEBUG")));
    }
}

