/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.GeneratedValueAnnotation;
import org.eclipse.jpt.core.resource.java.GenerationType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class GeneratedValueTests
extends JavaResourceModelTestCase {
    private static final String GENERATOR = "MY_GENERATOR";

    public GeneratedValueTests(String name) {
        super(name);
    }

    private void createGenerationTypeEnum() throws Exception {
        this.createEnumAndMembers("GenerationType", "TABLE, SEQUENCE, IDENTITY, AUTO;");
    }

    private void createGeneratedValueAnnotation() throws Exception {
        this.createAnnotationAndMembers("GeneratedValue", "GenerationType strategy() default AUTO; String generator() default \"\"");
        this.createGenerationTypeEnum();
    }

    private ICompilationUnit createTestGeneratedValue() throws Exception {
        this.createGeneratedValueAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.GeneratedValue", "javax.persistence.GenerationType"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@GeneratedValue");
            }
        });
    }

    private ICompilationUnit createTestGeneratedValueWithGenerator() throws Exception {
        this.createGeneratedValueAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.GeneratedValue", "javax.persistence.GenerationType"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@GeneratedValue(generator=\"MY_GENERATOR\")");
            }
        });
    }

    private ICompilationUnit createTestGeneratedValueWithStrategy() throws Exception {
        this.createGeneratedValueAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.GeneratedValue", "javax.persistence.GenerationType"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@GeneratedValue(strategy=GenerationType.SEQUENCE)");
            }
        });
    }

    public void testGeneratedValue() throws Exception {
        ICompilationUnit cu = this.createTestGeneratedValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        GeneratedValueAnnotation generatedValue = (GeneratedValueAnnotation)attributeResource.getAnnotation("javax.persistence.GeneratedValue");
        GeneratedValueTests.assertNotNull((Object)generatedValue);
    }

    public void testGetGenerator() throws Exception {
        ICompilationUnit cu = this.createTestGeneratedValueWithGenerator();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        GeneratedValueAnnotation generatedValue = (GeneratedValueAnnotation)attributeResource.getAnnotation("javax.persistence.GeneratedValue");
        GeneratedValueTests.assertEquals((String)GENERATOR, (String)generatedValue.getGenerator());
    }

    public void testSetGenerator() throws Exception {
        ICompilationUnit cu = this.createTestGeneratedValueWithGenerator();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        GeneratedValueAnnotation generatedValue = (GeneratedValueAnnotation)attributeResource.getAnnotation("javax.persistence.GeneratedValue");
        GeneratedValueTests.assertEquals((String)GENERATOR, (String)generatedValue.getGenerator());
        generatedValue.setGenerator("foo");
        GeneratedValueTests.assertEquals((String)"foo", (String)generatedValue.getGenerator());
        this.assertSourceContains("@GeneratedValue(generator=\"foo\")", cu);
        generatedValue.setGenerator(null);
        GeneratedValueTests.assertNull((Object)generatedValue.getGenerator());
        this.assertSourceDoesNotContain("generator", cu);
        this.assertSourceContains("@GeneratedValue", cu);
    }

    public void testGetStrategy() throws Exception {
        ICompilationUnit cu = this.createTestGeneratedValueWithStrategy();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        GeneratedValueAnnotation generatedValue = (GeneratedValueAnnotation)attributeResource.getAnnotation("javax.persistence.GeneratedValue");
        GeneratedValueTests.assertEquals((Object)GenerationType.SEQUENCE, (Object)generatedValue.getStrategy());
    }

    public void testSetStrategy() throws Exception {
        ICompilationUnit cu = this.createTestGeneratedValueWithStrategy();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        GeneratedValueAnnotation generatedValue = (GeneratedValueAnnotation)attributeResource.getAnnotation("javax.persistence.GeneratedValue");
        GeneratedValueTests.assertEquals((Object)GenerationType.SEQUENCE, (Object)generatedValue.getStrategy());
        generatedValue.setStrategy(GenerationType.TABLE);
        GeneratedValueTests.assertEquals((Object)GenerationType.TABLE, (Object)generatedValue.getStrategy());
        this.assertSourceContains("@GeneratedValue(strategy=TABLE)", cu);
        generatedValue.setStrategy(null);
        GeneratedValueTests.assertNull((Object)generatedValue.getStrategy());
        this.assertSourceDoesNotContain("strategy", cu);
        this.assertSourceContains("@GeneratedValue", cu);
    }
}

