/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.EntityAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityImpl
extends AbstractResourceAnnotation<Type>
implements EntityAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Entity");
    private final AnnotationElementAdapter<String> nameAdapter = new ShortCircuitAnnotationElementAdapter<String>((Member)this.getMember(), NAME_ADAPTER);
    private static final DeclarationAnnotationElementAdapter<String> NAME_ADAPTER = EntityImpl.buildNameAdapter();
    private String name;

    protected EntityImpl(JavaResourcePersistentType parent, Type type) {
        super(parent, type, DECLARATION_ANNOTATION_ADAPTER);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.name = this.name(astRoot);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.Entity";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        if (this.attributeValueHasNotChanged(this.name, newName)) {
            return;
        }
        String oldName = this.name;
        this.name = newName;
        this.nameAdapter.setValue(newName);
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(NAME_ADAPTER, astRoot);
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        this.setName(this.name(astRoot));
    }

    protected String name(CompilationUnit astRoot) {
        return this.nameAdapter.getValue(astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildNameAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(DECLARATION_ANNOTATION_ADAPTER, "name", false);
    }

    public static class EntityAnnotationDefinition
    implements AnnotationDefinition {
        private static final EntityAnnotationDefinition INSTANCE = new EntityAnnotationDefinition();

        public static EntityAnnotationDefinition instance() {
            return INSTANCE;
        }

        private EntityAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new EntityImpl((JavaResourcePersistentType)parent, (Type)member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "javax.persistence.Entity";
        }
    }
}

