/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.ddlgen;

import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.eclipselink.core.internal.ddlgen.EclipseLinkDDLGenerator;
import org.eclipse.jpt.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.eclipselink.ui.internal.ddlgen.wizards.GenerateDDLWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkDDLGeneratorUi {
    private JpaProject project;
    private String projectLocation;
    private IStructuredSelection selection;

    public static void generate(JpaProject project, String projectLocation, IStructuredSelection selection) {
        if (project == null) {
            throw new NullPointerException();
        }
        new EclipseLinkDDLGeneratorUi(project, projectLocation, selection).generate();
    }

    private EclipseLinkDDLGeneratorUi() {
    }

    private EclipseLinkDDLGeneratorUi(JpaProject project, String projectLocation, IStructuredSelection selection) {
        this.project = project;
        this.selection = selection;
        this.projectLocation = projectLocation;
    }

    protected void generate() {
        int returnCode;
        PersistenceUnit persistenceUnit = this.getPersistenceUnits().next();
        String puName = persistenceUnit.getName();
        if (!this.displayGeneratingDDLWarning()) {
            return;
        }
        GenerateDDLWizard wizard = new GenerateDDLWizard(this.project, this.selection);
        WizardDialog dialog = new WizardDialog(this.getCurrentShell(), (IWizard)wizard);
        dialog.create();
        if (wizard.getPageCount() > 0 && (returnCode = dialog.open()) == 1) {
            return;
        }
        GenerateDDLRunnable runnable = new GenerateDDLRunnable(puName, this.project, this.projectLocation);
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)runnable, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Shell getCurrentShell() {
        return Display.getCurrent().getActiveShell();
    }

    private boolean displayGeneratingDDLWarning() {
        String message = NLS.bind((String)EclipseLinkUiMessages.EclipseLinkDDLGeneratorUi_generatingDDLWarningMessage, (Object)System.getProperty("line.separator"), (Object)(String.valueOf(System.getProperty("line.separator")) + System.getProperty("line.separator")));
        return MessageDialog.openQuestion((Shell)this.getCurrentShell(), (String)EclipseLinkUiMessages.EclipseLinkDDLGeneratorUi_generatingDDLWarningTitle, (String)message);
    }

    protected JpaPlatform getPlatform() {
        return this.project.getJpaPlatform();
    }

    protected Iterator<PersistenceUnit> getPersistenceUnits() {
        return this.getPersistence().persistenceUnits();
    }

    protected Persistence getPersistence() {
        return this.project.getRootContext().getPersistenceXml().getPersistence();
    }

    static class GenerateDDLRunnable
    implements IWorkspaceRunnable {
        private final String puName;
        private final JpaProject project;
        private String projectLocation;

        GenerateDDLRunnable(String puName, JpaProject project, String projectLocation) {
            this.puName = puName;
            this.project = project;
            this.projectLocation = projectLocation;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            try {
                EclipseLinkDDLGenerator.generate((String)this.puName, (JpaProject)this.project, (String)this.projectLocation, (IProgressMonitor)monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
                return;
            }
            catch (RuntimeException re) {
                String msg = re.getMessage();
                String message = msg == null ? re.toString() : msg;
                this.logError(message);
                throw new RuntimeException(re);
            }
        }

        protected void logError(String message) {
            this.displayError(message);
        }

        private void displayError(String message) {
            String msg = MessageFormat.format(message, message);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)msg);
        }

        private Shell getShell() {
            Shell[] shells;
            Shell shell;
            Display display = Display.getCurrent();
            Shell shell2 = shell = display == null ? null : display.getActiveShell();
            if (shell == null && display != null && (shells = display.getShells()).length > 0) {
                shell = shells[0];
            }
            return shell;
        }
    }
}

