/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests.views.model.jsp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ConverterTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ValidatorTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.common.runtime.tests.model.RuntimeTestUtil;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.internal.tld.IJSFConstants;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.JSPTagResolvingStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TagIntrospectingStrategy;
import org.eclipse.jst.jsf.designtime.tests.views.model.jsp.BaseStrategyTestClass;
import org.eclipse.jst.jsf.designtime.tests.views.model.jsp.VerifyRegistryUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestTagIntrospectingStrategy
extends BaseStrategyTestClass {
    @Override
    protected JSPTagResolvingStrategy createStrategy() {
        return new TagIntrospectingStrategy(this._webProjectTestEnv.getTestProject());
    }

    public void testGetNotFoundIndicator() {
        TestTagIntrospectingStrategy.assertNull((Object)this._strategy.getNotFoundIndicator());
    }

    public void testGetId() {
        TestTagIntrospectingStrategy.assertEquals((String)"org.eclipse.jst.jsf.designtime.TagIntrospectingStrategy", (String)this._strategy.getId());
    }

    @Override
    protected List<String> getTestUris() {
        return Collections.unmodifiableList(Arrays.asList("http://java.sun.com/jsf/core", "http://java.sun.com/jsf/html"));
    }

    @Override
    protected List<VerifyRegistryUtil.Verifier> createVerifiers(Map<String, ITagElement> tagElements, String uri) {
        if ("http://java.sun.com/jsf/core".equals(uri)) {
            return TestTagIntrospectingStrategy.createCoreVerifiers(this._jsfVersion, tagElements);
        }
        return super.createVerifiers(tagElements, uri);
    }

    @Override
    protected BaseStrategyTestClass.ExpectedTagCount getExpectedTagCount(String uri) {
        if ("http://java.sun.com/jsf/core".equals(uri)) {
            switch (this._jsfVersion) {
                case V1_0: 
                case V1_1: {
                    return new BaseStrategyTestClass.ExpectedTagCount(14, 15);
                }
                case V1_2: {
                    return new BaseStrategyTestClass.ExpectedTagCount(13, 15);
                }
            }
            throw new IllegalStateException(this._jsfVersion.toString());
        }
        return super.getExpectedTagCount(uri);
    }

    static List<VerifyRegistryUtil.Verifier> createCoreVerifiers(JSFVersion jsfVersion, Map<String, ITagElement> tagElements) {
        ConverterTypeInfo dateTimeConverterTypeInfo = ConverterTypeInfo.UNKNOWN;
        ConverterTypeInfo numberConverterTypeInfo = ConverterTypeInfo.UNKNOWN;
        ValidatorTypeInfo doubleRangeValidatorTypeInfo = ValidatorTypeInfo.UNKNOWN;
        ValidatorTypeInfo lengthValidatorTypeInfo = ValidatorTypeInfo.UNKNOWN;
        ValidatorTypeInfo longRangeValidatorTypeInfo = ValidatorTypeInfo.UNKNOWN;
        if (jsfVersion == JSFVersion.V1_2) {
            TestTagIntrospectingStrategy.assertTrue((String)("Size was " + tagElements.size() + " but expected [13,15]"), (tagElements.size() >= 13 && tagElements.size() <= 15 ? 1 : 0) != 0);
            if (tagElements.size() == 15) {
                doubleRangeValidatorTypeInfo = RuntimeTestUtil.VALIDATORINFO_DOUBLERANGE;
                lengthValidatorTypeInfo = RuntimeTestUtil.VALIDATORINFO_LENGTH;
                longRangeValidatorTypeInfo = RuntimeTestUtil.VALIDATORINFO_LONGRANGE;
            }
        } else {
            TestTagIntrospectingStrategy.assertTrue((String)("Size was " + tagElements.size() + " but expected [14,15]"), (tagElements.size() >= 14 && tagElements.size() <= 15 ? 1 : 0) != 0);
            dateTimeConverterTypeInfo = RuntimeTestUtil.CONVERTERINFO_DATETIME;
            numberConverterTypeInfo = RuntimeTestUtil.CONVERTERINFO_NUMBER;
            doubleRangeValidatorTypeInfo = RuntimeTestUtil.VALIDATORINFO_DOUBLERANGE;
            lengthValidatorTypeInfo = RuntimeTestUtil.VALIDATORINFO_LENGTH;
            longRangeValidatorTypeInfo = RuntimeTestUtil.VALIDATORINFO_LONGRANGE;
        }
        ArrayList<VerifyRegistryUtil.Verifier> verifiers = new ArrayList<VerifyRegistryUtil.Verifier>();
        if (jsfVersion != JSFVersion.V1_2) {
            verifiers.add(VerifyRegistryUtil.ATTRIBUTE_VERIFIER);
        }
        verifiers.add(new VerifyRegistryUtil.ConverterTagVerifier(IJSFConstants.TAG_IDENTIFIER_CONVERTDATETIME, dateTimeConverterTypeInfo));
        verifiers.add(VerifyRegistryUtil.CONVERTER_VERIFIER);
        verifiers.add(new VerifyRegistryUtil.ConverterTagVerifier(IJSFConstants.TAG_IDENTIFIER_CONVERTNUMBER, numberConverterTypeInfo));
        verifiers.add(VerifyRegistryUtil.FACET_VERIFIER);
        verifiers.add(VerifyRegistryUtil.PARAM_VERIFIER);
        verifiers.add(VerifyRegistryUtil.SELECTITEM_VERIFIER);
        verifiers.add(VerifyRegistryUtil.SELECTITEMS_VERIFIER);
        verifiers.add(VerifyRegistryUtil.SUBVIEW_VERIFIER);
        verifiers.add(new VerifyRegistryUtil.ValidatorTagVerifier(IJSFConstants.TAG_IDENTIFIER_VALIDATEDOUBLERANGE, doubleRangeValidatorTypeInfo));
        verifiers.add(new VerifyRegistryUtil.ValidatorTagVerifier(IJSFConstants.TAG_IDENTIFIER_VALIDATELENGTH, lengthValidatorTypeInfo));
        verifiers.add(new VerifyRegistryUtil.ValidatorTagVerifier(IJSFConstants.TAG_IDENTIFIER_VALIDATELONGRANGE, longRangeValidatorTypeInfo));
        verifiers.add(VerifyRegistryUtil.VALIDATOR_VERIFIER);
        verifiers.add(VerifyRegistryUtil.VERBATIM_VERIFIER);
        return verifiers;
    }
}

