/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.axis2.core.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jst.ws.axis2.core.utils.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Axis2CoreUtils {
    private static boolean alreadyComputedTempAxis2Directory = false;
    private static String tempAxis2Dir = null;

    public static String tempAxis2Directory() {
        if (!alreadyComputedTempAxis2Directory) {
            String[] nodes = new String[]{".metadata", ".plugins", "org.apache.axis2.facet"};
            tempAxis2Dir = FileUtils.addNodesToPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString(), nodes);
            alreadyComputedTempAxis2Directory = true;
        }
        return tempAxis2Dir;
    }

    public static String tempAxis2WebappFileLocation() {
        return Axis2CoreUtils.addAnotherNodeToPath(Axis2CoreUtils.tempAxis2Directory(), "server.properties");
    }

    public static String tempRuntimeStatusFileLocation() {
        return Axis2CoreUtils.addAnotherNodeToPath(Axis2CoreUtils.tempAxis2Directory(), "status.properties");
    }

    public static String tempWarStatusFileLocation() {
        return Axis2CoreUtils.addAnotherNodeToPath(Axis2CoreUtils.tempAxis2Directory(), "war.properties");
    }

    public static String addAnotherNodeToPath(String currentPath, String newNode) {
        return String.valueOf(currentPath) + File.separator + newNode;
    }

    public static void writePropertyToFile(File file, String key, String value) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "8859_1"));
        out.write(String.valueOf(key) + "=" + value + "\n");
        ((Writer)out).close();
    }

    public static String getServiceEndPointFromWSDL(String fileName, String serviceName) {
        String proxyEndPoint = null;
        try {
            Document doc = Axis2CoreUtils.getDocumentFromLocation(fileName);
            Element documentElement = doc.getDocumentElement();
            HashMap<String, String> portElements = new HashMap<String, String>();
            int i = 0;
            while (i < documentElement.getChildNodes().getLength()) {
                Node serviceElement = documentElement.getChildNodes().item(i);
                if (serviceElement.getNodeName().equals("wsdl:service") && serviceName.equalsIgnoreCase(serviceElement.getAttributes().getNamedItem("name").getNodeValue())) {
                    int j = 0;
                    while (j < serviceElement.getChildNodes().getLength()) {
                        Node portElement = serviceElement.getChildNodes().item(j);
                        if (portElement.getNodeName().equals("wsdl:port")) {
                            String portBinding = portElement.getAttributes().getNamedItem("binding").getNodeValue().toUpperCase();
                            int k = 0;
                            while (k < portElement.getChildNodes().getLength()) {
                                Node soapElement = portElement.getChildNodes().item(k);
                                if (!soapElement.getNodeName().equals("#text")) {
                                    String soapLocation = soapElement.getAttributes().getNamedItem("location").getNodeValue();
                                    while (portElements.containsKey(portBinding)) {
                                        portBinding = "K" + portBinding;
                                    }
                                    portElements.put(portBinding, soapLocation);
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            String portBindType = "";
            String soap11B = "SOAP11Binding".toUpperCase();
            String soap12B = "SOAP12Binding".toUpperCase();
            String httpB = "HttpBinding".toUpperCase();
            String https = "https";
            for (String string : portElements.keySet()) {
                if (proxyEndPoint == null) {
                    proxyEndPoint = (String)portElements.get(string);
                    portBindType = string;
                }
                if (string.endsWith(soap11B) && (proxyEndPoint.startsWith(https) || !portBindType.endsWith(soap11B))) {
                    proxyEndPoint = (String)portElements.get(string);
                    portBindType = string;
                }
                if (!portBindType.endsWith(soap11B) && string.endsWith(soap12B) && (proxyEndPoint.startsWith(https) || !portBindType.endsWith(soap12B))) {
                    proxyEndPoint = (String)portElements.get(string);
                    portBindType = string;
                }
                if (portBindType.endsWith(soap11B) || portBindType.endsWith(soap12B) || !string.endsWith(httpB) || !proxyEndPoint.startsWith(https) && portBindType.endsWith(httpB)) continue;
                proxyEndPoint = (String)portElements.get(string);
                portBindType = string;
            }
        }
        catch (Exception exception) {}
        return proxyEndPoint;
    }

    public static String getServiceNameFromWSDL(String fileName) {
        String serviceName = "";
        try {
            Document doc = Axis2CoreUtils.getDocumentFromLocation(fileName);
            Element documentElement = doc.getDocumentElement();
            int i = 0;
            while (i < documentElement.getChildNodes().getLength()) {
                Node serviceElement = documentElement.getChildNodes().item(i);
                if (serviceElement.getNodeName().equals("wsdl:service")) {
                    serviceName = serviceElement.getAttributes().getNamedItem("name").getNodeValue();
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return serviceName;
    }

    private static Document getDocumentFromLocation(String location) {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setNamespaceAware(false);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (location.toUpperCase().startsWith("HTTP:")) {
                URL url = new URL(location);
                doc = db.parse(url.openStream());
            } else {
                if (location.toUpperCase().startsWith("FILE:")) {
                    location = location.substring(5, location.length());
                }
                doc = db.parse(new File(location));
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException iOException) {}
        return doc;
    }
}

