/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.parser;

import org.eclipse.wst.jsdt.internal.compiler.env.ISourceMethod;

public class SourceMethod
implements ISourceMethod {
    private int modifiers;
    private int declarationStart;
    private int declarationEnd;
    private char[] returnTypeName;
    private char[] selector;
    private int nameSourceStart;
    private int nameSourceEnd;
    private char[][] argumentTypeNames;
    private char[][] argumentNames;
    private char[][] exceptionTypeNames;
    private char[] source;
    private String explicitConstructorCall;
    private int numberOfMemberMethods;
    private SourceMethod[] memberMethods;
    char[][] typeParameterNames;
    char[][][] typeParameterBounds;
    SourceMethod parent;

    public SourceMethod(int declarationStart, int modifiers, char[] returnTypeName, char[] selector, int nameSourceStart, int nameSourceEnd, char[][] argumentTypeNames, char[][] argumentNames, char[][] exceptionTypeNames, char[] source) {
        this.declarationStart = declarationStart;
        this.modifiers = modifiers;
        this.returnTypeName = returnTypeName;
        this.selector = selector;
        this.nameSourceStart = nameSourceStart;
        this.nameSourceEnd = nameSourceEnd;
        this.argumentTypeNames = argumentTypeNames;
        this.argumentNames = argumentNames;
        this.exceptionTypeNames = exceptionTypeNames;
        this.source = source;
    }

    public String displayModifiers() {
        StringBuffer buffer = new StringBuffer();
        if (this.modifiers == 0) {
            return null;
        }
        if ((this.modifiers & 1) != 0) {
            buffer.append("public ");
        }
        if ((this.modifiers & 4) != 0) {
            buffer.append("protected ");
        }
        if ((this.modifiers & 2) != 0) {
            buffer.append("private ");
        }
        if ((this.modifiers & 0x10) != 0) {
            buffer.append("final ");
        }
        if ((this.modifiers & 8) != 0) {
            buffer.append("static ");
        }
        if ((this.modifiers & 0x400) != 0) {
            buffer.append("abstract ");
        }
        if ((this.modifiers & 0x100) != 0) {
            buffer.append("native ");
        }
        if ((this.modifiers & 0x20) != 0) {
            buffer.append("synchronized ");
        }
        if (buffer.toString().trim().equals("")) {
            return null;
        }
        return buffer.toString().trim();
    }

    protected void addMemberMethod(SourceMethod sourceMemberMethod) {
        if (this.memberMethods == null) {
            this.memberMethods = new SourceMethod[4];
        }
        if (this.numberOfMemberMethods == this.memberMethods.length) {
            this.memberMethods = new SourceMethod[this.numberOfMemberMethods * 2];
            System.arraycopy(this.memberMethods, 0, this.memberMethods, 0, this.numberOfMemberMethods);
        }
        this.memberMethods[this.numberOfMemberMethods++] = sourceMemberMethod;
    }

    public SourceMethod[] getMemberMethods() {
        if (this.memberMethods != null && this.memberMethods.length != this.numberOfMemberMethods) {
            this.memberMethods = new SourceMethod[this.numberOfMemberMethods];
            System.arraycopy(this.memberMethods, 0, this.memberMethods, 0, this.numberOfMemberMethods);
        }
        return this.memberMethods;
    }

    public String getActualName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.source, this.nameSourceStart, this.nameSourceEnd - this.nameSourceStart + 1);
        return buffer.toString();
    }

    public char[][] getArgumentNames() {
        return this.argumentNames;
    }

    public char[][] getArgumentTypeNames() {
        return this.argumentTypeNames;
    }

    public int getDeclarationSourceEnd() {
        return this.declarationEnd;
    }

    public int getDeclarationSourceStart() {
        return this.declarationStart;
    }

    public char[][] getExceptionTypeNames() {
        return this.exceptionTypeNames;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public int getNameSourceEnd() {
        return this.nameSourceEnd;
    }

    public int getNameSourceStart() {
        return this.nameSourceStart;
    }

    public char[] getReturnTypeName() {
        return this.returnTypeName;
    }

    public char[] getSelector() {
        return this.selector;
    }

    public char[][][] getTypeParameterBounds() {
        return this.typeParameterBounds;
    }

    public char[][] getTypeParameterNames() {
        return this.typeParameterNames;
    }

    public boolean isConstructor() {
        return this.returnTypeName == null;
    }

    protected void setDeclarationSourceEnd(int position) {
        this.declarationEnd = position;
    }

    protected void setExplicitConstructorCall(String s) {
        this.explicitConstructorCall = s;
    }

    public String tabString(int tab) {
        String s = "";
        int i = tab;
        while (i > 0) {
            s = String.valueOf(s) + "\t";
            --i;
        }
        return s;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int tab) {
        int max;
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.tabString(tab));
        String displayModifiers = this.displayModifiers();
        if (displayModifiers != null) {
            buffer.append(displayModifiers).append(" ");
        }
        if (this.returnTypeName != null) {
            buffer.append(this.returnTypeName).append(" ");
        }
        buffer.append("function ").append(this.selector).append("(");
        if (this.argumentTypeNames != null) {
            i = 0;
            max = this.argumentTypeNames.length;
            while (i < max) {
                buffer.append(this.argumentTypeNames[i]).append(" ").append(this.argumentNames[i]).append(", ");
                ++i;
            }
        }
        buffer.append(") ");
        if (this.exceptionTypeNames != null) {
            buffer.append("throws ");
            i = 0;
            max = this.exceptionTypeNames.length;
            while (i < max) {
                buffer.append(this.exceptionTypeNames[i]).append(", ");
                ++i;
            }
        }
        buffer.append("{");
        if (this.explicitConstructorCall != null) {
            buffer.append("\n").append(this.tabString(tab + 1)).append(this.explicitConstructorCall).append(this.tabString(tab)).append("}");
        }
        if (this.numberOfMemberMethods > 0) {
            i = 0;
            while (i < this.numberOfMemberMethods) {
                buffer.append("\n").append(this.memberMethods[i].toString(tab + 1));
                ++i;
            }
            buffer.append("\n").append(this.tabString(tab));
        }
        buffer.append("}");
        return buffer.toString();
    }
}

