/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;

public class BasicParserTests
extends AbstractRegressionTest {
    public BasicParserTests(String name) {
        super(name);
    }

    public void test001() {
        this.runParseTest("{i=1;}\n", "X.js", "{\n  i = 1;\n}\n");
    }

    public void test002() {
        this.runParseTest("i=1\nj=2;\n", "X.js", "i = 1;\nj = 2;\n");
    }

    public void test003() {
        this.runParseTest("var i=1,c=4;\n", "X.js", "var i = 1, c = 4;\n");
        this.runParseTest("var i=1,c;\n", "X.js", "var i = 1, c;\n");
    }

    public void test003a() {
        this.runParseTest("var foo=null;\n", "X.js", "var foo = null;\n");
        this.runParseTest("var i=1,c;\n", "X.js", "var i = 1, c;\n");
    }

    public void test004() {
        this.runParseTest("function abc(){}\n", "X.js", "function abc() {\n}\n");
    }

    public void test004a() {
        this.runParseTest("function abc(a){}\n", "X.js", "function abc(a) {\n}\n");
    }

    public void test004b() {
        this.runParseTest("function abc(a,b){i=1;}\n", "X.js", "function abc(a, b) {\n  i = 1;\n}\n");
    }

    public void test005a() {
        this.runParseTest("i=this.v1+4;\n", "X.js", "i = (this.v1 + 4);\n");
    }

    public void test005b() {
        this.runParseTest("i=funccall(c,b);i=cc.funccall(c,b);i=dd.cc.funccall(c,b);\n", "X.js", "i = funccall(c, b);\ni = cc.funccall(c, b);\ni = dd.cc.funccall(c, b);\n");
    }

    public void test005b2() {
        this.runParseTest("i=funccall().methCall();\n", "X.js", "i = funccall().methCall();\n");
    }

    public void test005d() {
        this.runParseTest("i= function (c,b) {i=2;}\n", "X.js", "i = function (c, b) {\n  i = 2;\n};\n");
    }

    public void test005e() {
        this.runParseTest("i= 1+(z-v);i= ++z * v--;\n", "X.js", "i = (1 + (z - v));\ni = ((++ z) * (v --));\n");
    }

    public void test005f() {
        this.runParseTest("i= new abc(dd);\n", "X.js", "i = new abc(dd);\n");
    }

    public void test005f1() {
        this.runParseTest("i= new dojo.uri.Uri(1,2);\n", "X.js", "i = new dojo.uri.Uri(1, 2);\n");
    }

    public void test005f2() {
        this.runParseTest("dojo.string.normalizeNewlines = function (text,newlineChar) {i=1;}\n", "X.js", "dojo.string.normalizeNewlines = function (text, newlineChar) {\n  i = 1;\n};\n");
    }

    public void test005f3() {
        this.runParseTest("\tfunction foo() {\n\t\tvar maxUnits = 0;\n\t\t\tvar unitResult = \n\t\t\t\tnew CompilationUnitResult(\n\t\t\t\t\tnull, \n\t\t\t\t\ti, \n\t\t\t\t\tmaxUnits); \n}\n", "X.js", "function foo() {\n  var maxUnits = 0;\n  var unitResult = new   CompilationUnitResult(null, i, maxUnits);\n}\n");
    }

    public void test005f4() {
        this.runParseTest("i= new SomeClass;\n", "X.js", "i = new SomeClass;\n");
    }

    public void test005f5() {
        this.runParseTest("function f(){\ni= new SomeClass \n}\n", "X.js", "function f() {\n  i = new SomeClass;\n}\n");
    }

    public void test005f6() {
        this.runParseTest("\tfunction X(i){}\t\t\t\t\t\t\t\t\n\tfunction foo(){\t\t\t\t\t\t\t\t\n\t\tvar j = 0;\t\t\t\t\t\t\t\n\t\tvar x = new X(j);\t\t\t\t\t\t\n}\t\n", "X.js", "function X(i) {\n}\nfunction foo() {\n  var j = 0;\n  var x = new   X(j);\n}\n");
    }

    public void test005g1() {
        this.runParseTest("i= typeof objpath != \"string\";\n", "X.js", "i = ((typeof objpath) != \"string\");\n");
    }

    public void test005g2() {
        this.runParseTest("i= ar instanceof Error;\n", "X.js", "i = (ar instanceof Error);\n");
    }

    public void test005g3() {
        this.runParseTest("i= anArg.name != null ;\n", "X.js", "i = (anArg.name != null);\n");
    }

    public void test005g4() {
        this.runParseTest("i= anArg.name != undefined ;\n", "X.js", "i = (anArg.name != undefined);\n");
    }

    public void test005h1() {
        this.runParseTest("i= { a: 2 , b: 3+4};\n", "X.js", "i = {\n  a : 2,\n  b : (3 + 4)\n};\n");
    }

    public void test005h1a() {
        this.runParseTest("i= { 'a': 2 , 'b': 3+4};\n", "X.js", "i = {\n  'a' : 2,\n  'b' : (3 + 4)\n};\n");
    }

    public void test005h2() {
        this.runParseTest("i= { a: function(){ var ar={c:3,d:4,e:4}; } , b: function(cc){ var c=1;} , d:function(){}};\n", "X.js", "i = {\n  a : function () {\n  var ar = {\n    c : 3,\n    d : 4,\n    e : 4\n  };\n},\n  b : function (cc) {\n  var c = 1;\n},\n  d : function () {\n}\n};\n");
    }

    public void test005i() {
        this.runParseTest("i= arr[4];\n", "X.js", "i = arr[4];\n");
    }

    public void test005i1() {
        this.runParseTest("arr[4]=1;\n", "X.js", "arr[4] = 1;\n");
    }

    public void test005i2() {
        this.runParseTest("var arr=null;arr[4]=1;\n", "X.js", "var arr = null;\narr[4] = 1;\n");
    }

    public void test005j() {
        this.runParseTest("i= [a,b];\n", "X.js", "i = [a, b];\n");
    }

    public void test005j2() {
        this.runParseTest("i= [,a];\n", "X.js", "i = [, a];\n");
    }

    public void test005j3() {
        this.runParseTest("i= [a,];\n", "X.js", "i = [a, ];\n");
    }

    public void test005j4() {
        this.runParseTest("i= [,];\n", "X.js", "i = [, ];\n");
    }

    public void test005j5() {
        this.runParseTest("i= [];\n", "X.js", "i = [];\n");
    }

    public void test005j6() {
        this.runParseTest("i= [a,,b];\n", "X.js", "i = [a, , b];\n");
    }

    public void test005j7() {
        this.runParseTest("i= [,,];i= [,,,];i= [,,b,];\n", "X.js", "i = [, , ];\ni = [, , , ];\ni = [, , b, ];\n");
    }

    public void test007() {
        this.runParseTest("if (a>1) this.c=f+5;\n", "X.js", "if ((a > 1))\n    this.c = (f + 5);\n");
    }

    public void test008() {
        this.runParseTest("try { a=2;} catch (ex) {a=3;}\n", "X.js", "try \n  {\n    a = 2;\n  }\ncatch (ex)   {\n    a = 3;\n  }\n");
    }

    public void test009() {
        this.runParseTest("for (i=1;i<3;i++)\n  f++;\n", "X.js", "for (i = 1; (i < 3); i ++) \n  f ++;\n");
    }

    public void test009a() {
        this.runParseTest("for (;i<3;i++)\n  f++;\n", "X.js", "for (; (i < 3); i ++) \n  f ++;\n");
    }

    public void test010() {
        this.runParseTest("for (var a in this.vars)\n  f++;\n", "X.js", "for (var a in this.vars) \n  f ++;\n");
    }

    public void test011() {
        this.runParseTest("with (foo)\n  bar;\n", "X.js", "with (foo)\n  bar;\n");
    }

    public void test010a() {
        this.runParseTest("for (a in this.vars)\n  f++;\n", "X.js", "for (a in this.vars) \n  f ++;\n");
    }

    public void test015() {
        this.runParseTest("  function bar() \n{\n    System.out.println()\n  }\n", "X.js", "function bar() {\n  System.out.println();\n}\n");
    }

    public void test015a() {
        this.runParseTest("function bar() {\n  System.out\n}\n", "X.js", "function bar() {\n  System.out;\n}\n");
    }

    public void test020() {
        this.runParseTest("function Bob(firstname, lastname) {\n   var Firstname = firstname;\n   var Lastname = lastname;\n}\nBob.prototype.name = function () {return this.Fistname + this.Lastname;};\n", "X.js", "function Bob(firstname, lastname) {\n  var Firstname = firstname;\n  var Lastname = lastname;\n}\nBob.prototype.name = function () {\n  return (this.Fistname + this.Lastname);\n};\n");
    }

    public void test022() {
        this.runParseTest("var SingleQuote = {\n   Version: '1.1-beta2' \n}\n", "X.js", "var SingleQuote = {\n  Version : '1.1-beta2'\n};\n");
    }

    public void test023() {
        this.runParseTest("var Try = { \n\tthese: function() { \n\t\tvar returnValue; \n\t} \n\t} \n", "X.js", "var Try = {\n  these : function () {\n  var returnValue;\n}\n};\n");
    }

    public void test024() {
        this.runParseTest("var Try = { \n\tthese: function() { \n\t\tvar returnValue; \n\t} \n};", "X.js", "var Try = {\n  these : function () {\n  var returnValue;\n}\n};\n");
    }

    public void test026() {
        this.runParseTest("String.replace(/&/g, '&amp;');", "X.js", "String.replace(/&/g, '&amp;');\n");
    }

    public void test027() {
        this.runParseTest("  (!options) ? options = {} : '';", "X.js", "((! options) ? (options = {}) : '');\n");
    }

    public void test027b() {
        this.runParseTest("  (!options) ? '' : options = {};", "X.js", "((! options) ? '' : (options = {}));\n");
    }

    public void test028() {
        this.runParseTest(" if (typeof dojo==\"undefined\"){ \n\tfunction dj_undef(){ \n\t} \n}", "X.js", "if (((typeof dojo) == \"undefined\"))\n    {\n      function dj_undef() {\n      }\n    }\n");
    }

    public void test029() {
        this.runParseTest("  abc();", "X.js", "abc();\n");
    }

    public void test030() {
        this.runParseTest("  \"cc\".abc();", "X.js", "\"cc\".abc();\n");
    }

    public void test031() {
        this.runParseTest("var a = 1;\n// test unicode \\u00a var a =1; \nvar b = 2; \n", "X.js", "var a = 1;\nvar b = 2;\n");
    }

    public void test032() {
        this.runParseTest("var a = 1;\n/* \n* test unicode \\u00a var a =1; \n */var b = 2; \n", "X.js", "var a = 1;\nvar b = 2;\n");
    }

    public void test033() {
        this.runParseTest("var a = \"a\\>\";\n", "X.js", "var a = \"a>\";\n");
    }

    public void test034() {
        this.runParseTest("label: for (var i = 0; i < 10; i++) {\n\t     continue label;\n}", "X.js", "label: for (var i = 0;; (i < 10); i ++) \n  {\n    continue label;\n  }\n");
    }

    public void test035() {
        this.runParseTest("\"abc\\u0022def\";\n", "X.js", "\"abc\\\"def\";\n");
    }

    public void test036() {
        this.runParseTest("'abc\\u0027def';\n", "X.js", "'abc'def';\n");
    }

    public void test037() {
        this.runParseTest("\"\\u0022def\";\n", "X.js", "\"\\\"def\";\n");
    }

    public void test038() {
        this.runParseTest("\"abc\\x22def\";\n", "X.js", "\"abc\\\"def\";\n");
    }

    public void test039() {
        this.runParseTest("\"\\x22def\";\n", "X.js", "\"\\\"def\";\n");
    }

    public void test040() {
        this.runParseTest("var onStart = function() { \n\tthis.onStart.fire();\n\tthis.runtimeAttributes = {};\n\tfor (var attr in this.attributes) {\n\t\tthis.xyz(attr);\n\t}\n};", "X.js", "var onStart = function () {\n  this.onStart.fire();\n  this.runtimeAttributes = {};\n  for (var attr in this.attributes) \n    {\n      this.xyz(attr);\n    }\n};\n");
    }

    public void test041() {
        this.runParseTest("(function (){});\n", "X.js", "function () {\n};\n");
    }

    public void test042() {
        this.runParseTest("function trim(oldString)\n{\nvar newString = oldString;\nvar safety = 0;\nvar safetyLimit = 10000;\nwhile(newString.charAt(0) == \" \" && safety < safetyLimit){\n\tnewString = newString.substring(1);\n\tsafety++;\n}\nwhile(newString.charAt(newString.length-1) == \" \" && safety < safetyLimit){\nnewString = newString.substring(0, newString.length-1);\n\tsafety++\n\t}\nreturn newString;\n};", "X.js", "function trim(oldString) {\n  var newString = oldString;\n  var safety = 0;\n  var safetyLimit = 10000;\n  while (((newString.charAt(0) == \" \") && (safety < safetyLimit)))    {\n      newString = newString.substring(1);\n      safety ++;\n    }\n  while (((newString.charAt((newString.length - 1)) == \" \") && (safety < safetyLimit)))    {\n      newString = newString.substring(0, (newString.length - 1));\n      safety ++;\n    }\n  return newString;\n}\n;\n");
    }

    public void test043() {
        this.runParseTest("Foo=function(){}\nbar=function(){}", "X.js", "Foo = function () {\n};\nbar = function () {\n};\n");
    }

    public void test044() {
        this.runParseTest("ptr[i]();", "X.js", "ptr[i]();\n");
    }

    public void test045() {
        this.runParseTest("((weight + 1)/2)", "X.js", "((weight + 1) / 2);\n");
    }

    public void test046() {
        this.runParseTest("a=1,b=2", "X.js", "(a = 1), (b = 2);\n");
    }

    public void test046b() {
        this.runParseTest("a=1,funcall(0),5", "X.js", "(a = 1), funcall(0), 5;\n");
    }

    public void test050() {
        this.runParseTest("if (true) var c=1;", "X.js", "if (true)\n    var c = 1;\n");
    }

    public void test051() {
        this.runParseTest("var c=function(){}.bind();", "X.js", "var c = function () {\n}.bind();\n");
    }

    public void test051b() {
        this.runParseTest("transforms = map(function (){\n}.bind()).reject(function (){\n});", "X.js", "transforms = map(function () {\n}.bind()).reject(function () {\n});\n");
    }

    public void test051c() {
        this.runParseTest("map(function(){if(true) {} else if(true)var components = value.match(),unit =  null;}.bind(this));", "X.js", "map(function () {\n  if (true)\n      {\n      }\n  else\n      if (true)\n          var components = value.match(), unit = null;\n}.bind(this));\n");
    }

    public void test051d() {
        this.runParseTest("function bb(){if(true)var components = value.match(),unit =  null;};", "X.js", "function bb() {\n  if (true)\n      var components = value.match(), unit = null;\n}\n;\n");
    }
}

