/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.oaametadata;

import org.eclipse.wst.jsdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.oaametadata.ClassData;
import org.eclipse.wst.jsdt.internal.oaametadata.LibraryAPIs;
import org.eclipse.wst.jsdt.internal.oaametadata.Method;
import org.eclipse.wst.jsdt.internal.oaametadata.Parameter;
import org.eclipse.wst.jsdt.internal.oaametadata.Property;

public class MetadataSourceElementNotifier {
    LibraryAPIs apis;
    ISourceElementRequestor requestor;
    HashtableOfObject notifiedTypes = new HashtableOfObject();

    public MetadataSourceElementNotifier(LibraryAPIs apis, ISourceElementRequestor requestor) {
        this.requestor = requestor;
        this.apis = apis;
    }

    public void notifyRequestor() {
        this.requestor.enterCompilationUnit();
        if (this.apis.classes != null) {
            int i = 0;
            while (i < this.apis.classes.length) {
                this.notifySourceElementRequestor(this.apis.classes[i]);
                ++i;
            }
        }
        this.requestor.exitCompilationUnit(0);
    }

    public void notifySourceElementRequestor(ClassData clazz) {
        Method method;
        int methodInx;
        char[] typeName = clazz.name.toCharArray();
        if (this.notifiedTypes.containsKey(typeName)) {
            return;
        }
        this.notifiedTypes.put(typeName, null);
        ISourceElementRequestor.TypeInfo typeInfo = new ISourceElementRequestor.TypeInfo();
        typeInfo.declarationStart = 0;
        typeInfo.modifiers = 0;
        typeInfo.name = typeName;
        typeInfo.nameSourceStart = 0;
        typeInfo.nameSourceEnd = 0;
        if (clazz.superclass != null) {
            typeInfo.superclass = clazz.superclass.toCharArray();
        }
        typeInfo.superinterfaces = null;
        typeInfo.secondary = false;
        typeInfo.anonymousMember = false;
        this.requestor.enterType(typeInfo);
        Property[] fields = clazz.getFields();
        int attributeInx = 0;
        while (attributeInx < fields.length) {
            Property field = fields[attributeInx];
            ISourceElementRequestor.FieldInfo fieldInfo = new ISourceElementRequestor.FieldInfo();
            fieldInfo.declarationStart = 0;
            fieldInfo.name = field.name.toCharArray();
            fieldInfo.modifiers = 0;
            if (field.isStatic()) {
                fieldInfo.modifiers |= 8;
            }
            fieldInfo.nameSourceStart = 0;
            fieldInfo.nameSourceEnd = 0;
            fieldInfo.type = field.dataType != null ? field.dataType.toCharArray() : null;
            this.requestor.enterField(fieldInfo);
            int initializationStart = 0;
            this.requestor.exitField(initializationStart, 0, 0);
            ++attributeInx;
        }
        if (clazz.constructors != null) {
            methodInx = 0;
            while (methodInx < clazz.constructors.length) {
                method = clazz.constructors[methodInx];
                boolean isConstructor = true;
                this.notifyMethod(method, isConstructor);
                ++methodInx;
            }
        }
        if (clazz.methods != null) {
            methodInx = 0;
            while (methodInx < clazz.methods.length) {
                method = clazz.methods[methodInx];
                boolean isConstructor = false;
                this.notifyMethod(method, isConstructor);
                ++methodInx;
            }
        }
        this.requestor.exitType(0);
    }

    private void notifyMethod(Method method, boolean isConstructor) {
        ISourceElementRequestor.MethodInfo methodInfo = new ISourceElementRequestor.MethodInfo();
        methodInfo.isConstructor = isConstructor;
        Object argumentTypes = null;
        Object argumentNames = null;
        Parameter[] arguments = method.parameters;
        if (arguments != null) {
            int argumentLength = arguments.length;
            argumentTypes = new char[argumentLength][];
            argumentNames = new char[argumentLength][];
            int i = 0;
            while (i < argumentLength) {
                if (arguments[i].dataType != null) {
                    argumentTypes[i] = arguments[i].dataType.toCharArray();
                }
                argumentNames[i] = arguments[i].name.toCharArray();
                ++i;
            }
        }
        methodInfo.declarationStart = 0;
        methodInfo.modifiers = 0;
        if (method.isStatic()) {
            methodInfo.modifiers |= 8;
        }
        methodInfo.name = isConstructor ? new char[]{} : method.name.toCharArray();
        methodInfo.nameSourceStart = 0;
        methodInfo.nameSourceEnd = 0;
        methodInfo.parameterTypes = argumentTypes;
        methodInfo.parameterNames = argumentNames;
        methodInfo.exceptionTypes = null;
        methodInfo.typeParameters = null;
        methodInfo.annotationPositions = null;
        methodInfo.categories = null;
        this.requestor.enterMethod(methodInfo);
        this.requestor.exitMethod(0, -1, -1);
    }
}

