/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.format;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.formatter.DefaultXMLPartitionFormatter;
import org.eclipse.wst.xml.core.internal.formatter.XMLFormattingPreferences;
import org.eclipse.wst.xml.core.tests.util.StringCompareUtil;

public class TestPartitionFormatterXML
extends TestCase {
    private static final String UTF_8 = "UTF-8";
    private StringCompareUtil fStringCompareUtil;
    private DefaultXMLPartitionFormatter partitionFormatter;

    protected void setUp() throws Exception {
        this.partitionFormatter = new DefaultXMLPartitionFormatter();
        this.fStringCompareUtil = new StringCompareUtil();
    }

    private IStructuredModel getModelForEdit(String filename) {
        IStructuredModel model = null;
        try {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
            if (inStream == null) {
                throw new FileNotFoundException("Can't file resource stream " + filename);
            }
            String baseFile = ((Object)((Object)this)).getClass().getResource(filename).toString();
            model = modelManager.getModelForEdit(baseFile, inStream, new URIResolver(baseFile){
                String fBase;
                {
                    this.fBase = string;
                }

                public String getFileBaseLocation() {
                    return this.fBase;
                }

                public String getLocationByURI(String uri) {
                    return this.getLocationByURI(uri, this.fBase);
                }

                public String getLocationByURI(String uri, boolean resolveCrossProjectLinks) {
                    return this.getLocationByURI(uri);
                }

                public String getLocationByURI(String uri, String baseReference) {
                    int lastSlash = baseReference.lastIndexOf("/");
                    if (lastSlash > 0) {
                        return String.valueOf(baseReference.substring(0, lastSlash + 1)) + uri;
                    }
                    return baseReference;
                }

                public String getLocationByURI(String uri, String baseReference, boolean resolveCrossProjectLinks) {
                    return this.getLocationByURI(uri, baseReference);
                }

                public IProject getProject() {
                    return null;
                }

                public IContainer getRootLocation() {
                    return null;
                }

                public InputStream getURIStream(String uri) {
                    return this.getClass().getResourceAsStream(this.getLocationByURI(uri));
                }

                public void setFileBaseLocation(String newLocation) {
                    this.fBase = newLocation;
                }

                public void setProject(IProject newProject) {
                }
            });
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return model;
    }

    protected void formatAndAssertEquals(String beforePath, String afterPath) throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals(beforePath, afterPath, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void formatAndAssertEquals(String beforePath, String afterPath, XMLFormattingPreferences prefs) throws UnsupportedEncodingException, IOException, CoreException {
        IStructuredModel afterModel;
        block8: {
            IStructuredModel beforeModel = null;
            afterModel = null;
            try {
                beforeModel = this.getModelForEdit(beforePath);
                TestPartitionFormatterXML.assertNotNull((String)("could not retrieve structured model for : " + beforePath), (Object)beforeModel);
                afterModel = this.getModelForEdit(afterPath);
                TestPartitionFormatterXML.assertNotNull((String)("could not retrieve structured model for : " + afterPath), (Object)afterModel);
                IStructuredDocument document = beforeModel.getStructuredDocument();
                String normalizedContents = document.get();
                normalizedContents = StringUtils.replace((String)normalizedContents, (String)"\r\n", (String)"\n");
                normalizedContents = StringUtils.replace((String)normalizedContents, (String)"\r", (String)"\n");
                document.set(normalizedContents);
                if (prefs == null) {
                    prefs = new XMLFormattingPreferences();
                }
                TextEdit edit = this.partitionFormatter.format(beforeModel, 0, document.getLength(), prefs);
                try {
                    edit.apply((IDocument)document);
                }
                catch (MalformedTreeException e) {
                    e.printStackTrace();
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                ByteArrayOutputStream formattedBytes = new ByteArrayOutputStream();
                beforeModel.save((OutputStream)formattedBytes);
                ByteArrayOutputStream afterBytes = new ByteArrayOutputStream();
                afterModel.save((OutputStream)afterBytes);
                String expectedContents = new String(afterBytes.toByteArray(), UTF_8);
                String actualContents = new String(formattedBytes.toByteArray(), UTF_8);
                expectedContents = StringUtils.replace((String)expectedContents, (String)"\r\n", (String)"\n");
                expectedContents = StringUtils.replace((String)expectedContents, (String)"\r", (String)"\n");
                actualContents = StringUtils.replace((String)actualContents, (String)"\r\n", (String)"\n");
                actualContents = StringUtils.replace((String)actualContents, (String)"\r", (String)"\n");
                TestPartitionFormatterXML.assertTrue((String)("Formatted document differs from the expected.\nExpected Contents:\n" + expectedContents + "\nActual Contents:\n" + actualContents), (boolean)this.fStringCompareUtil.equalsIgnoreLineSeperator(expectedContents, actualContents));
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                if (beforeModel != null) {
                    beforeModel.releaseFromEdit();
                }
                if (afterModel == null) throw throwable;
                afterModel.releaseFromEdit();
                throw throwable;
            }
            {
                Object var13_17 = null;
                if (beforeModel == null) break block8;
            }
            beforeModel.releaseFromEdit();
        }
        if (afterModel == null) return;
        afterModel.releaseFromEdit();
    }

    public void testSimpleXml() throws UnsupportedEncodingException, IOException, CoreException {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setClearAllBlankLines(true);
        this.formatAndAssertEquals("testfiles/xml/simple-standalone.xml", "testfiles/xml/simple-standalone-newfmt.xml", prefs);
    }

    public void testWhitespaceFormatXSD() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/xml/xml-whitespace-xsd.xml", "testfiles/xml/xml-whitespace-xsd-actual.xml");
    }

    public void testPreserveFormat() throws UnsupportedEncodingException, IOException, CoreException {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setClearAllBlankLines(true);
        this.formatAndAssertEquals("testfiles/xml/xml-space-preserve-standalone.xml", "testfiles/xml/xml-space-preserve-standalone-newfmt.xml", prefs);
    }

    public void testPreserveFormatDTD() throws UnsupportedEncodingException, IOException, CoreException {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setClearAllBlankLines(true);
        this.formatAndAssertEquals("testfiles/xml/xml-space-preserve-dtd.xml", "testfiles/xml/xml-space-preserve-dtd-newfmt.xml", prefs);
    }

    public void testOneLineFormat() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/xml/oneline.xml", "testfiles/xml/oneline-fmt.xml");
    }

    public void testOneLineTextNodeFormat() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/xml/onelineTextNode.xml", "testfiles/xml/onelineTextNode-newfmt.xml");
    }

    public void testEmptyContentNodeFormat() throws UnsupportedEncodingException, IOException, CoreException {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setIndentMultipleAttributes(true);
        this.formatAndAssertEquals("testfiles/xml/usetagswithemptycontent.xml", "testfiles/xml/usetagswithemptycontent-fmt.xml", prefs);
    }

    public void testXSLFormat() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/xml/xslattributetext.xsl", "testfiles/xml/xslattributetext-fmt.xsl");
    }

    public void testEntityFormat() throws UnsupportedEncodingException, IOException, CoreException {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setClearAllBlankLines(true);
        this.formatAndAssertEquals("testfiles/xml/entities.xml", "testfiles/xml/entities-newfmt.xml", prefs);
    }

    public void testPreservePCDATAFormat() throws UnsupportedEncodingException, IOException, CoreException {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setPCDataWhitespaceStrategy("PRESERVE");
        prefs.setClearAllBlankLines(true);
        this.formatAndAssertEquals("testfiles/xml/xml-preservepcdata.xml", "testfiles/xml/xml-preservepcdata-yes-fmt.xml", prefs);
        prefs.setPCDataWhitespaceStrategy("COLLAPSE");
        this.formatAndAssertEquals("testfiles/xml/xml-preservepcdata.xml", "testfiles/xml/xml-preservepcdata-no-newfmt.xml", prefs);
    }

    public void testPreserveCDATAFormat() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/xml/usecdata.xml", "testfiles/xml/usecdata-fmt.xml");
    }

    public void testSplitAttributesFormat() throws UnsupportedEncodingException, IOException, CoreException {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setIndentMultipleAttributes(true);
        prefs.setAlignFinalBracket(false);
        this.formatAndAssertEquals("testfiles/xml/multiattributes2.xml", "testfiles/xml/multiattributes2-yessplit-noalign-newfmt.xml", prefs);
        prefs.setIndentMultipleAttributes(false);
        prefs.setAlignFinalBracket(false);
        this.formatAndAssertEquals("testfiles/xml/multiattributes2.xml", "testfiles/xml/multiattributes2-nosplit-noalign-newfmt.xml", prefs);
    }

    public void testAlignEndBracketFormat() throws UnsupportedEncodingException, IOException, CoreException {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setIndentMultipleAttributes(false);
        prefs.setAlignFinalBracket(true);
        this.formatAndAssertEquals("testfiles/xml/multiattributes.xml", "testfiles/xml/multiattributes-nosplit-yesalign-newfmt.xml", prefs);
        prefs.setIndentMultipleAttributes(true);
        prefs.setAlignFinalBracket(true);
        this.formatAndAssertEquals("testfiles/xml/multiattributes.xml", "testfiles/xml/multiattributes-yessplit-yesalign-newfmt.xml", prefs);
    }

    public void testSpaceBeforeEmptyCloseTag() throws UnsupportedEncodingException, IOException, CoreException {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setSpaceBeforeEmptyCloseTag(false);
        this.formatAndAssertEquals("testfiles/xml/xml-empty-tag-space.xml", "testfiles/xml/xml-empty-tag-space-none-newfmt.xml", prefs);
        prefs.setSpaceBeforeEmptyCloseTag(true);
        this.formatAndAssertEquals("testfiles/xml/xml-empty-tag-space.xml", "testfiles/xml/xml-empty-tag-space-newfmt.xml", prefs);
    }

    public void testProcessingInstruction() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/xml/processinginstruction.xml", "testfiles/xml/processinginstruction-fmt.xml");
    }

    public void testComments() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/xml/xml-comment.xml", "testfiles/xml/xml-comment-newfmt.xml");
    }

    public void testKeepEmptyLines() throws UnsupportedEncodingException, IOException, CoreException {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setClearAllBlankLines(false);
        this.formatAndAssertEquals("testfiles/xml/xml-keep-blank-lines.xml", "testfiles/xml/xml-keep-blank-lines-fmt.xml", prefs);
    }

    public void testClearBlankLines() throws UnsupportedEncodingException, IOException, CoreException {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setClearAllBlankLines(true);
        this.formatAndAssertEquals("testfiles/xml/xml-keep-blank-lines.xml", "testfiles/xml/xml-clear-blank-lines-fmt.xml", prefs);
    }
}

