/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.ejb.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.jee.model.tests.AbstractTest;
import org.eclipse.jst.jee.model.tests.SynchronousModelChangedListener;
import org.eclipse.jst.jee.project.facet.IEJBCreateDeploymentFilesDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class GenerateDDTest
extends TestCase {
    private static final String EJB_JAR_CONTENT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><ejb-jar xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:ejb=\"http://java.sun.com/xml/ns/javaee/ejb-jar_3_0.xsd\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/ejb-jar_3_0.xsd\" version=\"3.0\"><enterprise-beans>\t\t<session>\t\t\t<ejb-name>NMTOKEN</ejb-name>\t\t</session>\t</enterprise-beans></ejb-jar>";
    private IModelProvider fixture = null;
    private IProject project = null;

    public static Test suite() {
        TestSuite suite = new TestSuite(GenerateDDTest.class);
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = ProjectUtil.createEJBProject(GenerateDDTest.class.getSimpleName(), null, 30, true);
        this.fixture = ModelProviderManager.getModelProvider((IProject)this.project);
    }

    protected void tearDown() throws Exception {
        ProjectUtil.deleteProject(this.project);
        super.tearDown();
    }

    public void testGenerateDD() throws Exception {
        IFile file = this.project.getFile("ejbModule/META-INF/ejb-jar.xml");
        GenerateDDTest.assertFalse((boolean)file.exists());
        SynchronousModelChangedListener listener = new SynchronousModelChangedListener(1);
        this.fixture.addListener((IModelProviderListener)listener);
        IDataModel dataModel = DataModelFactory.createDataModel(IEJBCreateDeploymentFilesDataModelProperties.class);
        dataModel.setProperty("ICreateDeploymentFilesDataModelProperties.TARGET_PROJECT", (Object)this.project);
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        AbstractTest.saveFile(file, EJB_JAR_CONTENT);
        listener.waitForEvents();
        this.fixture.removeListener((IModelProviderListener)listener);
        GenerateDDTest.assertEquals((Object)new Integer(1), (Object)new Integer(listener.getReceivedEvents().size()));
    }
}

