/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import junit.framework.AssertionFailedError;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.common.project.facet.JavaFacetInstallDataModelProvider;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EjbFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EjbFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.jee.model.tests.ChangeListenerWithSemaphore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractTest {
    private static final String EJB_API_JAR_LOCATION = "/home/kiko/local/jboss-4.2.1.GA/server/default/lib/jboss-ejb3x.jar";

    public static IFacetedProject createEjbProject(String earName, String ejbProjectName, String clientName) throws Exception {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new EjbFacetProjectCreationDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)ejbProjectName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = facetMap.getFacetDataModel("jst.ejb");
        facetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)IJ2EEFacetConstants.EJB_30);
        if (earName != null) {
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", (Object)true);
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)earName);
            if (clientName != null) {
                facetModel.setBooleanProperty("IEjbFacetInstallDataModelProperties.CREATE_CLIENT", true);
                facetModel.setStringProperty("IEjbFacetInstallDataModelProperties.CLIENT_NAME ", clientName);
            }
        } else {
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", (Object)false);
        }
        facetModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", true);
        IDataModel javaFacetModel = facetMap.getFacetDataModel("jst.java");
        javaFacetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)JavaFacetUtils.JAVA_50);
        dm.getDefaultOperation().execute(null, null);
        IFacetedProject project = ProjectFacetsManager.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(ejbProjectName));
        AbstractTest.addEjbApiToClassPath(project);
        return project;
    }

    public static IFacetedProject createEjbProject(String projectName) throws Exception {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new EjbFacetProjectCreationDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projectName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetDataModelMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel javaFacetDataModel = facetDataModelMap.getFacetDataModel("jst.java");
        javaFacetDataModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)JavaFacetUtils.JAVA_50);
        IDataModel ejbFacetDataModel = facetDataModelMap.getFacetDataModel("jst.ejb");
        ejbFacetDataModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)IJ2EEFacetConstants.EJB_30);
        dm.getDefaultOperation().execute(null, null);
        IFacetedProject project = ProjectFacetsManager.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
        AbstractTest.addEjbApiToClassPath(project);
        return project;
    }

    public static void deleteProject(final String projectName) throws InterruptedException {
        WorkspaceJob deleteJob = new WorkspaceJob("Delete project job..."){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).delete(true, monitor);
                return Status.OK_STATUS;
            }
        };
        deleteJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        deleteJob.schedule();
        deleteJob.join();
    }

    public static void closeProject(final String projectName) throws Exception {
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                project.close(monitor);
            }
        }, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IFacetedProject.Action setupEjbInstallAction() {
        IDataModel ejbFacetInstallDataModel = DataModelFactory.createDataModel((IDataModelProvider)new EjbFacetInstallDataModelProvider());
        ejbFacetInstallDataModel.setProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", (Object)"ejbModule");
        ejbFacetInstallDataModel.setProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", (Object)true);
        IProjectFacetVersion webfacetversion = ProjectFacetsManager.getProjectFacet((String)"jst.ejb").getVersion("3.0");
        IFacetedProject.Action action = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, webfacetversion, (Object)ejbFacetInstallDataModel);
        return action;
    }

    public static IFacetedProject.Action setupJavaInstallAction() {
        IProjectFacetVersion javafacetversion = ProjectFacetsManager.getProjectFacet((String)"jst.java").getVersion("5.0");
        IDataModel javaFacetInstallDataModel = DataModelFactory.createDataModel((IDataModelProvider)new JavaFacetInstallDataModelProvider());
        javaFacetInstallDataModel.setProperty("IJavaFacetInstallDataModelProperties.SOURCE_FOLDER_NAME", (Object)"ejbModule");
        IFacetedProject.Action action = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, javafacetversion, (Object)javaFacetInstallDataModel);
        return action;
    }

    private static void addEjbApiToClassPath(IFacetedProject facetProj) throws JavaModelException {
        IClasspathEntry entry;
        Path classPath = new Path(EJB_API_JAR_LOCATION);
        IJavaProject javaProject = JavaCore.create((IProject)facetProj.getProject());
        IClasspathEntry[] entries = new IClasspathEntry[javaProject.getRawClasspath().length + 1];
        System.arraycopy(javaProject.getRawClasspath(), 0, entries, 0, entries.length - 1);
        entries[entries.length - 1] = entry = JavaCore.newLibraryEntry((IPath)classPath, null, null);
        javaProject.setRawClasspath(entries, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static Collection<IResourceChangeEvent> saveFile(IFile file, String content) throws Exception {
        ChangeListenerWithSemaphore listener = new ChangeListenerWithSemaphore(1);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 16);
        int retries = 3;
        while (retries > 0) {
            try {
                if (file.exists()) {
                    AbstractTest.setContents(content, file);
                } else {
                    AbstractTest.createFile(content, file);
                }
                if (!listener.waitForEvents()) continue;
                retries = 0;
                break;
            }
            catch (CoreException e) {
                e.printStackTrace();
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
                System.runFinalization();
                System.gc();
                listener = new ChangeListenerWithSemaphore(1);
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 16);
            }
            finally {
                --retries;
            }
        }
        if (retries != -1) {
            throw new AssertionFailedError("The number of retries is <" + retries + ">");
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        return listener.getReceivedEvents();
    }

    public static void createFile(final String content, final IFile file) throws Exception {
        BlockProgressMonitor monitor = new BlockProgressMonitor();
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                try {
                    stream.write(content.getBytes());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                file.create((InputStream)new ByteArrayInputStream(stream.toByteArray()), true, monitor);
            }
        }, ResourcesPlugin.getWorkspace().getRuleFactory().createRule((IResource)file), 1, (IProgressMonitor)monitor);
        if (!monitor.waitForEvent()) {
            throw new IllegalStateException("Monitor not finished...");
        }
    }

    public static void setContents(final String content, final IFile file) throws Exception {
        BlockProgressMonitor monitor = new BlockProgressMonitor();
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                try {
                    manager.connect(file.getFullPath(), LocationKind.IFILE, monitor);
                    ITextFileBuffer buffer = manager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
                    IDocument document = buffer.getDocument();
                    document.set(content);
                    buffer.commit(monitor, true);
                }
                finally {
                    manager.disconnect(file.getFullPath(), LocationKind.IFILE, monitor);
                }
            }
        }, ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)file), 0, (IProgressMonitor)monitor);
        if (!monitor.waitForEvent()) {
            throw new IllegalStateException("Monitor not finished...");
        }
    }

    public static void deleteFile(final IFile file) throws Exception {
        ChangeListenerWithSemaphore listener = new ChangeListenerWithSemaphore(1);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 16);
        int retries = 3;
        while (retries > 0) {
            try {
                BlockProgressMonitor monitor = new BlockProgressMonitor();
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        file.delete(false, monitor);
                        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, monitor);
                    }
                }, (IProgressMonitor)monitor);
                if (!monitor.waitForEvent()) {
                    throw new IllegalStateException("Monitor not finished...");
                }
                if (!listener.waitForEvents()) continue;
                retries = 0;
                break;
            }
            catch (CoreException coreException) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
                System.runFinalization();
                System.gc();
                listener = new ChangeListenerWithSemaphore(1);
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 1);
            }
            finally {
                --retries;
            }
        }
        if (retries != -1) {
            throw new AssertionFailedError("The number of retries for file<" + file + "> is <" + retries + ">");
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
    }

    public static IFacetedProject createWebProject(String projectName) throws Exception {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetProjectCreationDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projectName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetDataModelMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel javaFacetDataModel = facetDataModelMap.getFacetDataModel("jst.java");
        javaFacetDataModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)JavaFacetUtils.JAVA_50);
        IDataModel ejbFacetDataModel = facetDataModelMap.getFacetDataModel("jst.web");
        ejbFacetDataModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)IJ2EEFacetConstants.DYNAMIC_WEB_25);
        dm.getDefaultOperation().execute(null, null);
        IFacetedProject project = ProjectFacetsManager.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
        AbstractTest.addEjbApiToClassPath(project);
        return project;
    }

    private static class BlockProgressMonitor
    implements IProgressMonitor {
        private Semaphore semaphore = new Semaphore(2);
        private boolean canceled;

        public BlockProgressMonitor() throws InterruptedException {
            this.semaphore.acquire();
        }

        public void beginTask(String name, int totalWork) {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public boolean waitForEvent() throws InterruptedException {
            return this.semaphore.tryAcquire(5L, TimeUnit.SECONDS);
        }

        public void done() {
            this.semaphore.release();
        }

        public void internalWorked(double work) {
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void setCanceled(boolean value) {
            this.semaphore.release();
            this.canceled = value;
        }

        public void setTaskName(String name) {
        }

        public void subTask(String name) {
        }

        public void worked(int work) {
        }
    }
}

