/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.beaninfo;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jem.internal.beaninfo.BeanDecorator;
import org.eclipse.jem.internal.beaninfo.EventSetDecorator;
import org.eclipse.jem.internal.beaninfo.IndexedPropertyDecorator;
import org.eclipse.jem.internal.beaninfo.MethodDecorator;
import org.eclipse.jem.internal.beaninfo.MethodProxy;
import org.eclipse.jem.internal.beaninfo.ParameterDecorator;
import org.eclipse.jem.internal.beaninfo.PropertyDecorator;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.java.ArrayType;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaEvent;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.TypeKind;
import org.eclipse.jem.tests.beaninfo.AbstractBeanInfoTestCase;

public class TestStandard
extends AbstractBeanInfoTestCase {
    public TestStandard() {
    }

    public TestStandard(String name) {
        super(name);
    }

    public void testArrayClassType() {
        JavaClass at = (JavaClass)JavaRefFactory.eINSTANCE.reflectType("org.eclipse.jem.tests.beaninfo.Test1Class[]", this.rset);
        TestStandard.assertTrue((boolean)at.isArray());
        TestStandard.assertSame((Object)TypeKind.CLASS_LITERAL, (Object)at.getKind());
        TestStandard.assertEquals((int)1, (int)((ArrayType)at).getArrayDimensions());
        TestStandard.assertTrue((boolean)at.isPublic());
        TestStandard.assertTrue((boolean)"java.lang.Object".equals(at.getSupertype().getQualifiedName()));
        TestStandard.assertTrue((at.getImplementsInterfaces().size() == 2 ? 1 : 0) != 0);
        TestStandard.assertTrue((boolean)at.getMethods().isEmpty());
        TestStandard.assertTrue((boolean)at.getFields().isEmpty());
        TestStandard.assertTrue((boolean)at.getProperties().isEmpty());
        TestStandard.assertTrue((boolean)at.getEvents().isEmpty());
        TestStandard.assertTrue((boolean)at.getEOperations().isEmpty());
    }

    public void testArrayPrimitiveType() {
        JavaClass at = (JavaClass)JavaRefFactory.eINSTANCE.reflectType("int[]", this.rset);
        TestStandard.assertTrue((boolean)at.isArray());
        TestStandard.assertSame((Object)TypeKind.CLASS_LITERAL, (Object)at.getKind());
        TestStandard.assertEquals((int)1, (int)((ArrayType)at).getArrayDimensions());
        TestStandard.assertTrue((boolean)at.isPublic());
        TestStandard.assertTrue((boolean)"java.lang.Object".equals(at.getSupertype().getQualifiedName()));
        TestStandard.assertTrue((at.getImplementsInterfaces().size() == 2 ? 1 : 0) != 0);
        TestStandard.assertTrue((boolean)at.getMethods().isEmpty());
        TestStandard.assertTrue((boolean)at.getFields().isEmpty());
        TestStandard.assertTrue((boolean)at.getProperties().isEmpty());
        TestStandard.assertTrue((boolean)at.getEvents().isEmpty());
        TestStandard.assertTrue((boolean)at.getEOperations().isEmpty());
    }

    public void testArrayUndefined() {
        JavaClass at = (JavaClass)JavaRefFactory.eINSTANCE.reflectType("XYZ[]", this.rset);
        TestStandard.assertTrue((boolean)at.isArray());
        TestStandard.assertSame((Object)TypeKind.UNDEFINED_LITERAL, (Object)at.getKind());
    }

    public void testArrayClassType2Dim() {
        JavaClass at = (JavaClass)JavaRefFactory.eINSTANCE.reflectType("org.eclipse.jem.tests.beaninfo.Test1Class[][]", this.rset);
        TestStandard.assertTrue((boolean)at.isArray());
        TestStandard.assertSame((Object)TypeKind.CLASS_LITERAL, (Object)at.getKind());
        TestStandard.assertEquals((int)2, (int)((ArrayType)at).getArrayDimensions());
        TestStandard.assertTrue((boolean)at.isPublic());
        TestStandard.assertTrue((boolean)"java.lang.Object".equals(at.getSupertype().getQualifiedName()));
        TestStandard.assertTrue((at.getImplementsInterfaces().size() == 2 ? 1 : 0) != 0);
        TestStandard.assertTrue((boolean)at.getMethods().isEmpty());
        TestStandard.assertTrue((boolean)at.getFields().isEmpty());
        TestStandard.assertTrue((boolean)at.getProperties().isEmpty());
        TestStandard.assertTrue((boolean)at.getEvents().isEmpty());
        TestStandard.assertTrue((boolean)at.getEOperations().isEmpty());
    }

    public void testArrayPrimitiveType2Dim() {
        JavaClass at = (JavaClass)JavaRefFactory.eINSTANCE.reflectType("int[][]", this.rset);
        TestStandard.assertTrue((boolean)at.isArray());
        TestStandard.assertSame((Object)TypeKind.CLASS_LITERAL, (Object)at.getKind());
        TestStandard.assertEquals((int)2, (int)((ArrayType)at).getArrayDimensions());
        TestStandard.assertTrue((boolean)at.isPublic());
        TestStandard.assertTrue((boolean)"java.lang.Object".equals(at.getSupertype().getQualifiedName()));
        TestStandard.assertTrue((at.getImplementsInterfaces().size() == 2 ? 1 : 0) != 0);
        TestStandard.assertTrue((boolean)at.getMethods().isEmpty());
        TestStandard.assertTrue((boolean)at.getFields().isEmpty());
        TestStandard.assertTrue((boolean)at.getProperties().isEmpty());
        TestStandard.assertTrue((boolean)at.getEvents().isEmpty());
        TestStandard.assertTrue((boolean)at.getEOperations().isEmpty());
    }

    public void testArrayUndefined2Dim() {
        JavaClass at = (JavaClass)JavaRefFactory.eINSTANCE.reflectType("XYZ[][]", this.rset);
        TestStandard.assertTrue((boolean)at.isArray());
        TestStandard.assertSame((Object)TypeKind.UNDEFINED_LITERAL, (Object)at.getKind());
    }

    public void testArrayInnerClassType() {
        JavaClass at = (JavaClass)JavaRefFactory.eINSTANCE.reflectType("org.eclipse.jem.tests.beaninfo.Customer$Account[]", this.rset);
        TestStandard.assertTrue((boolean)at.isArray());
        TestStandard.assertSame((Object)TypeKind.CLASS_LITERAL, (Object)at.getKind());
        TestStandard.assertEquals((int)1, (int)((ArrayType)at).getArrayDimensions());
        TestStandard.assertTrue((boolean)at.isPublic());
        TestStandard.assertTrue((boolean)"java.lang.Object".equals(at.getSupertype().getQualifiedName()));
        TestStandard.assertTrue((at.getImplementsInterfaces().size() == 2 ? 1 : 0) != 0);
        TestStandard.assertTrue((boolean)at.getMethods().isEmpty());
        TestStandard.assertTrue((boolean)at.getFields().isEmpty());
        TestStandard.assertTrue((boolean)at.getProperties().isEmpty());
        TestStandard.assertTrue((boolean)at.getEvents().isEmpty());
        TestStandard.assertTrue((boolean)at.getEOperations().isEmpty());
    }

    public void testBeanDecoratorReflected() {
        JavaClass test1Class = this.getTest1Class();
        BeanDecorator bd = Utilities.getBeanDecorator((EModelElement)test1Class);
        TestStandard.assertEquals((String)"Test1Class", (String)bd.getName());
        TestStandard.assertNull((Object)bd.getCustomizerClass());
    }

    protected JavaClass getTest1Class() {
        JavaClass test1Class = (JavaClass)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#Test1Class"), true);
        return test1Class;
    }

    public void testLocalReflectedProperties() {
        EList allLocalFeatures = this.getTest1Class().getProperties();
        TestStandard.assertEquals((int)2, (int)allLocalFeatures.size());
        Iterator itr = Utilities.getPropertiesIterator((EList)allLocalFeatures);
        boolean found = false;
        while (itr.hasNext()) {
            PropertyDecorator pd = (PropertyDecorator)itr.next();
            if (!pd.getName().equals("foo")) continue;
            found = true;
            TestStandard.assertTrue((boolean)(pd instanceof IndexedPropertyDecorator));
            IndexedPropertyDecorator ip = (IndexedPropertyDecorator)pd;
            JavaHelpers type = (JavaHelpers)ip.getPropertyType();
            TestStandard.assertEquals((String)"java.lang.String[]", (String)type.getQualifiedName());
            if (!type.getQualifiedName().equals("java.lang.String[]")) {
                // empty if block
            }
            Method mthd = ip.getReadMethod();
            TestStandard.assertSame((Object)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#Test1Class.getFoo("), true), (Object)mthd);
            mthd = ip.getWriteMethod();
            TestStandard.assertSame((Object)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#Test1Class.setFoo(java.lang.String[]"), true), (Object)mthd);
            mthd = ip.getIndexedReadMethod();
            TestStandard.assertSame((Object)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#Test1Class.getFoo(int"), true), (Object)mthd);
            mthd = ip.getIndexedWriteMethod();
            TestStandard.assertSame((Object)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#Test1Class.setFoo(int,java.lang.String"), true), (Object)mthd);
            break;
        }
        TestStandard.assertTrue((boolean)found);
    }

    public void testLocalReflectedOperations() {
        JavaClass test1Class = this.getTest1Class();
        EList allLocalOperations = test1Class.getEOperations();
        TestStandard.assertEquals((int)10, (int)allLocalOperations.size());
        Iterator itr = allLocalOperations.iterator();
        Method desired = (Method)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#Test1Class.setFoo(int,java.lang.String"), true);
        boolean found = false;
        while (itr.hasNext()) {
            MethodProxy bhav = (MethodProxy)itr.next();
            if (bhav.getMethod() != desired) continue;
            found = true;
            EList parms = Utilities.getMethodDecorator((EModelElement)bhav).getParameterDescriptors();
            TestStandard.assertEquals((int)2, (int)parms.size());
            ParameterDecorator pmd = (ParameterDecorator)parms.get(0);
            TestStandard.assertEquals((String)"index", (String)pmd.getName());
            break;
        }
        TestStandard.assertTrue((boolean)found);
    }

    public void testLocalReflectedEvents() {
        JavaClass test1Class = this.getTest1Class();
        EList events = test1Class.getEvents();
        TestStandard.assertEquals((int)2, (int)events.size());
        Iterator itr = events.iterator();
        boolean foundevt1 = false;
        boolean foundevt2 = false;
        while (itr.hasNext()) {
            EventSetDecorator edec;
            JavaEvent event = (JavaEvent)itr.next();
            if ("test1ClassEvent".equals(event.getName())) {
                foundevt1 = true;
                edec = Utilities.getEventSetDecorator((EModelElement)event);
                EList mlist = edec.getListenerMethods();
                TestStandard.assertEquals((int)2, (int)mlist.size());
                continue;
            }
            if (!"test1ClassUnicastEvent".equals(event.getName())) continue;
            foundevt2 = true;
            edec = Utilities.getEventSetDecorator((EModelElement)event);
            TestStandard.assertTrue((boolean)edec.isUnicast());
        }
        TestStandard.assertTrue((boolean)foundevt1);
        TestStandard.assertTrue((boolean)foundevt2);
    }

    protected JavaClass getTest2ClassB() {
        return (JavaClass)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#Test2ClassB"), true);
    }

    public void testBeanDecoratorIntrospected() {
        JavaClass test2ClassB = this.getTest2ClassB();
        BeanDecorator bd = Utilities.getBeanDecorator((EModelElement)test2ClassB);
        TestStandard.assertEquals((String)"Test2ClassB", (String)bd.getName());
        TestStandard.assertEquals((String)"A name for this class.", (String)bd.getDisplayName());
        TestStandard.assertFalse((boolean)bd.isExpert());
        TestStandard.assertSame((Object)test2ClassB, (Object)bd.getCustomizerClass());
    }

    public void testLocalIntrospectedProperties() {
        JavaClass test2ClassB = this.getTest2ClassB();
        EList allLocalFeatures = test2ClassB.getProperties();
        TestStandard.assertEquals((int)2, (int)allLocalFeatures.size());
        Iterator itr = Utilities.getPropertiesIterator((EList)allLocalFeatures);
        boolean gotSet = false;
        boolean gotFoo = false;
        while (itr.hasNext()) {
            PropertyDecorator pd = (PropertyDecorator)itr.next();
            Method mthd = null;
            if (pd.getName().equals("setA")) {
                gotSet = true;
                mthd = pd.getReadMethod();
                TestStandard.assertSame((Object)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#Test2ClassB.isSetA("), true), (Object)mthd);
                continue;
            }
            if (!pd.getName().equals("foo")) continue;
            gotFoo = true;
            IndexedPropertyDecorator ipd = (IndexedPropertyDecorator)pd;
            mthd = ipd.getIndexedReadMethod();
            TestStandard.assertSame((Object)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#Test2ClassB.getFoo(int"), true), (Object)mthd);
        }
        TestStandard.assertTrue((boolean)gotSet);
        TestStandard.assertTrue((boolean)gotFoo);
    }

    public void testLocalIntrospectedOperations() {
        JavaClass test2ClassB = this.getTest2ClassB();
        EList allLocalOperations = test2ClassB.getEOperations();
        TestStandard.assertEquals((int)2, (int)allLocalOperations.size());
        boolean found = false;
        Iterator itr = test2ClassB.getEOperations().iterator();
        while (itr.hasNext()) {
            EOperation bhav = (EOperation)itr.next();
            if (!bhav.getName().equals("setSetA")) continue;
            EList parms = Utilities.getMethodDecorator((EModelElement)bhav).getParameterDescriptors();
            TestStandard.assertEquals((int)1, (int)parms.size());
            ParameterDecorator pmd = (ParameterDecorator)parms.get(0);
            TestStandard.assertEquals((String)"aBooleanSetting", (String)pmd.getName());
            found = true;
            break;
        }
        TestStandard.assertTrue((boolean)found);
    }

    public void testLocalIntrospectedEvents() {
        JavaClass test2ClassB = this.getTest2ClassB();
        EList events = test2ClassB.getEvents();
        TestStandard.assertEquals((int)1, (int)events.size());
        JavaEvent event = (JavaEvent)events.get(0);
        TestStandard.assertEquals((String)"overrideName", (String)event.getName());
        EventSetDecorator edec = Utilities.getEventSetDecorator((EModelElement)event);
        TestStandard.assertEquals((String)"ITest1ClassEventListener", (String)edec.getListenerType().getName());
        EList mlist = edec.getListenerMethods();
        TestStandard.assertEquals((int)1, (int)mlist.size());
        MethodProxy mproxy = (MethodProxy)mlist.get(0);
        MethodDecorator mdec = Utilities.getMethodDecorator((EModelElement)mproxy);
        TestStandard.assertEquals((String)"event1", (String)mdec.getName());
        TestStandard.assertEquals((String)"Event 1", (String)mdec.getDisplayName());
    }

    public void testSuperTypes() {
        JavaClass testClass = this.getTest1Class();
        this.objFeaturesSetup();
        TestStandard.assertEquals((int)(2 + this.objFeatures), (int)testClass.getAllProperties().size());
        JavaClass test1ClassA = this.getTest1ClassA();
        TestStandard.assertNotNull((Object)test1ClassA);
        TestStandard.assertEquals((int)(3 + this.objFeatures), (int)test1ClassA.getAllProperties().size());
    }

    protected JavaClass getTest1ClassA() {
        return (JavaClass)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#Test1ClassA"), true);
    }

    public void testSuperTypesEvents() {
        JavaClass test1ClassA = this.getTest1ClassA();
        EList events = test1ClassA.getAllEvents();
        TestStandard.assertEquals((int)2, (int)events.size());
        Iterator itr = events.iterator();
        boolean foundevt1 = false;
        boolean foundevt2 = false;
        while (itr.hasNext()) {
            EventSetDecorator edec;
            JavaEvent event = (JavaEvent)itr.next();
            if ("test1ClassEvent".equals(event.getName())) {
                foundevt1 = true;
                edec = Utilities.getEventSetDecorator((EModelElement)event);
                EList mlist = edec.getListenerMethods();
                TestStandard.assertEquals((int)2, (int)mlist.size());
                continue;
            }
            if (!"test1ClassUnicastEvent".equals(event.getName())) continue;
            foundevt2 = true;
            edec = Utilities.getEventSetDecorator((EModelElement)event);
            TestStandard.assertTrue((boolean)edec.isUnicast());
        }
        TestStandard.assertTrue((boolean)foundevt1);
        TestStandard.assertTrue((boolean)foundevt2);
    }

    protected JavaClass getTest2Class() {
        return (JavaClass)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#Test2Class"), true);
    }

    protected JavaClass getTest2ClassA() {
        return (JavaClass)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#Test2ClassA"), true);
    }

    public void testSuperTypeHideProperty() {
        JavaClass test2Class = this.getTest2Class();
        this.objFeaturesSetup();
        TestStandard.assertEquals((int)(2 + this.objNonProperties), (int)test2Class.getAllProperties().size());
        JavaClass test2ClassA = this.getTest2ClassA();
        TestStandard.assertEquals((int)(3 + this.objNonProperties), (int)test2ClassA.getAllProperties().size());
        JavaClass test2ClassB = this.getTest2ClassB();
        TestStandard.assertEquals((int)(4 + this.objNonProperties), (int)test2ClassB.getAllProperties().size());
    }

    public void testIndexedBeanInfo() {
        JavaClass test2Class = this.getTest2Class();
        Iterator itr = Utilities.getPropertiesIterator((EList)test2Class.getProperties());
        boolean found = false;
        while (itr.hasNext()) {
            PropertyDecorator pd = (PropertyDecorator)itr.next();
            if (!pd.getName().equals("fooBar")) continue;
            found = true;
            TestStandard.assertTrue((boolean)(pd instanceof IndexedPropertyDecorator));
            IndexedPropertyDecorator ip = (IndexedPropertyDecorator)pd;
            JavaHelpers type = (JavaHelpers)ip.getPropertyType();
            TestStandard.assertEquals((String)"java.lang.String[]", (String)type.getQualifiedName());
            Method mthd = ip.getReadMethod();
            TestStandard.assertSame((Object)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#Test2Class.getFooBar("), true), (Object)mthd);
            mthd = ip.getWriteMethod();
            TestStandard.assertSame((Object)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#Test2Class.setFooBar(java.lang.String[]"), true), (Object)mthd);
            mthd = ip.getIndexedReadMethod();
            TestStandard.assertSame((Object)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#Test2Class.getFooBar(int"), true), (Object)mthd);
            mthd = ip.getIndexedWriteMethod();
            TestStandard.assertSame((Object)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#Test2Class.setFooBar(int,java.lang.String"), true), (Object)mthd);
            break;
        }
        TestStandard.assertTrue((boolean)found);
    }

    protected JavaClass getTest2ClassC() {
        return (JavaClass)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#Test2ClassC"), true);
    }

    public void testBeanInfoProject() {
        JavaClass test2ClassC = this.getTest2ClassC();
        BeanDecorator bd = Utilities.getBeanDecorator((EModelElement)test2ClassC);
        TestStandard.assertNotNull((Object)bd);
        TestStandard.assertEquals((String)"Test2ClassC from BeanInfo", (String)bd.getDisplayName());
    }

    public void testOverride() {
        JavaClass test2ClassB = this.getTest2ClassB();
        EStructuralFeature p = test2ClassB.getEStructuralFeature("setA");
        TestStandard.assertNotNull((Object)p);
        PropertyDecorator pd = Utilities.getPropertyDecorator((EModelElement)p);
        TestStandard.assertFalse((boolean)pd.isExpert());
        JavaClass test2ClassC = this.getTest2ClassC();
        p = test2ClassC.getEStructuralFeature("setA");
        TestStandard.assertNotNull((Object)p);
        pd = Utilities.getPropertyDecorator((EModelElement)p);
        TestStandard.assertTrue((boolean)pd.isExpert());
    }

    protected JavaClass getTest2ClassPreq() {
        return (JavaClass)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo.prereq#Test2ClassPreq"), true);
    }

    public void testPrereqedProjects() {
        JavaClass test2ClassPrereq = this.getTest2ClassPreq();
        this.objFeaturesSetup();
        TestStandard.assertEquals((int)(1 + this.objFeatures), (int)test2ClassPrereq.getAllProperties().size());
        EStructuralFeature f = test2ClassPrereq.getEStructuralFeature("aSet");
        TestStandard.assertNotNull((Object)f);
        PropertyDecorator pd = Utilities.getPropertyDecorator((EModelElement)f);
        TestStandard.assertTrue((boolean)pd.isExpert());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemovePropRebuild() throws CoreException {
        this.objFeaturesSetup();
        JavaClass test1Class = this.getTest1Class();
        JavaClass test1ClassA = this.getTest1ClassA();
        TestStandard.assertEquals((int)(2 + this.objFeatures), (int)test1Class.getAllProperties().size());
        TestStandard.assertEquals((int)(3 + this.objFeatures), (int)test1ClassA.getAllProperties().size());
        try {
            test1Class.getEStructuralFeatures().remove(0);
            TestStandard.assertEquals((int)(1 + this.objFeatures), (int)test1Class.getAllProperties().size());
            TestStandard.assertEquals((int)(2 + this.objFeatures), (int)test1ClassA.getAllProperties().size());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject project = this.nature.getProject();
            ISchedulingRule projectRule = workspace.getRuleFactory().modifyRule((IResource)project);
            workspace.run(new IWorkspaceRunnable(project){
                private final /* synthetic */ IProject val$project;
                {
                    this.val$project = iProject;
                }

                public void run(IProgressMonitor monitor) throws CoreException {
                    this.val$project.close(monitor);
                    this.val$project.open(monitor);
                }
            }, projectRule, 0, null);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = this.nature.getProject();
        ISchedulingRule projectRule = workspace.getRuleFactory().modifyRule((IResource)project);
        workspace.run(new /* invalid duplicate definition of identical inner class */, projectRule, 0, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveEventRebuild() throws CoreException {
        JavaClass test1Class = this.getTest1Class();
        JavaClass test1ClassA = this.getTest1ClassA();
        TestStandard.assertEquals((int)2, (int)test1Class.getAllEvents().size());
        TestStandard.assertEquals((int)2, (int)test1ClassA.getAllEvents().size());
        try {
            test1Class.getEvents().remove(0);
            TestStandard.assertEquals((int)1, (int)test1Class.getAllEvents().size());
            TestStandard.assertEquals((int)1, (int)test1ClassA.getAllEvents().size());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            IProject project = this.nature.getProject();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            ISchedulingRule projectRule = workspace.getRuleFactory().modifyRule((IResource)project);
            workspace.run(new IWorkspaceRunnable(project){
                private final /* synthetic */ IProject val$project;
                {
                    this.val$project = iProject;
                }

                public void run(IProgressMonitor monitor) throws CoreException {
                    this.val$project.close(monitor);
                    this.val$project.open(monitor);
                }
            }, projectRule, 0, null);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        IProject project = this.nature.getProject();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ISchedulingRule projectRule = workspace.getRuleFactory().modifyRule((IResource)project);
        workspace.run(new /* invalid duplicate definition of identical inner class */, projectRule, 0, null);
    }

    protected JavaClass getCustomer() {
        return (JavaClass)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#Customer"), true);
    }

    public void testInnerClass() {
        JavaClass customer = this.getCustomer();
        EList allLocalFeatures = customer.getProperties();
        TestStandard.assertEquals((int)2, (int)allLocalFeatures.size());
        Iterator itr = allLocalFeatures.iterator();
        boolean found = false;
        while (itr.hasNext()) {
            EStructuralFeature ea = (EStructuralFeature)itr.next();
            if (!"savings".equals(ea.getName())) continue;
            found = true;
            JavaClass innerClass = (JavaClass)ea.getEType();
            TestStandard.assertEquals((String)"Customer$Account", (String)innerClass.getName());
            allLocalFeatures = innerClass.getProperties();
            TestStandard.assertEquals((int)2, (int)allLocalFeatures.size());
        }
        TestStandard.assertTrue((boolean)found);
    }

    protected JavaClass getTestBoundNotBound() {
        return (JavaClass)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#TestBoundNotBound"), true);
    }

    public void testNotBoundReflection() {
        JavaClass testBoundNotBound = this.getTestBoundNotBound();
        EList allLocalFeatures = testBoundNotBound.getProperties();
        TestStandard.assertEquals((int)1, (int)allLocalFeatures.size());
        EStructuralFeature ea = (EStructuralFeature)allLocalFeatures.get(0);
        PropertyDecorator pd = Utilities.getPropertyDecorator((EModelElement)ea);
        TestStandard.assertNotNull((Object)pd);
        TestStandard.assertFalse((boolean)pd.isBound());
    }

    protected JavaClass getTestBoundSuper() {
        return (JavaClass)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#TestBoundSuper"), true);
    }

    public void testBoundReflection() {
        JavaClass testBoundSuper = this.getTestBoundSuper();
        EList allLocalFeatures = testBoundSuper.getProperties();
        TestStandard.assertEquals((int)1, (int)allLocalFeatures.size());
        EStructuralFeature ea = (EStructuralFeature)allLocalFeatures.get(0);
        PropertyDecorator pd = Utilities.getPropertyDecorator((EModelElement)ea);
        TestStandard.assertNotNull((Object)pd);
        TestStandard.assertTrue((boolean)pd.isBound());
    }

    protected JavaClass getTestBoundSub() {
        return (JavaClass)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#TestBoundSub"), true);
    }

    public void testBoundReflectionSubclass() {
        JavaClass testBoundSub = this.getTestBoundSub();
        EList allLocalFeatures = testBoundSub.getProperties();
        TestStandard.assertEquals((int)1, (int)allLocalFeatures.size());
        EStructuralFeature ea = (EStructuralFeature)allLocalFeatures.get(0);
        PropertyDecorator pd = Utilities.getPropertyDecorator((EModelElement)ea);
        TestStandard.assertNotNull((Object)pd);
        TestStandard.assertTrue((boolean)pd.isBound());
    }

    public void testOverridesFile() {
        JavaClass testOverride = (JavaClass)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#TestOverrides"), true);
        TestStandard.assertNotNull((Object)testOverride);
        EStructuralFeature xyz = testOverride.getEStructuralFeature("xyz");
        TestStandard.assertNotNull((Object)xyz);
        TestStandard.assertEquals((Object)this.rset.getEObject(URI.createURI((String)"java:/#int"), true), (Object)xyz.getEType());
        TestStandard.assertNotNull((Object)xyz.getEAnnotation("Override Annotation"));
    }

    public void test79083() {
        JavaClass testOverride = (JavaClass)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#TestOverrides"), true);
        TestStandard.assertNotNull((Object)testOverride);
        EStructuralFeature test79083 = testOverride.getEStructuralFeature("test79083");
        TestStandard.assertNotNull((Object)test79083);
        TestStandard.assertEquals((Object)EcorePackage.eINSTANCE.getEObject(), (Object)test79083.getEType());
    }
}

