/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.proxy.initParser.tree;

import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.IProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.initParser.tree.ForExpression;
import org.eclipse.jem.internal.proxy.initParser.tree.NoExpressionValueException;
import org.eclipse.jem.tests.proxy.initParser.AbstractInitParserTestCase;
import org.eclipse.jem.tests.proxy.initParser.tree.ASTTreeInitStringParserTestHelper;

public class TestCompatibleMethods
extends AbstractInitParserTestCase {
    public TestCompatibleMethods(String name) {
        super(name);
    }

    protected ASTTreeInitStringParserTestHelper getTreeParser() {
        return (ASTTreeInitStringParserTestHelper)this.testHelper;
    }

    protected IBeanProxy executeQQQ(IBeanProxy a1, IBeanProxy a2) throws ThrowableProxy, IllegalStateException, NoExpressionValueException {
        ProxyFactoryRegistry registry = this.getTreeParser().getRegistry();
        IExpression exp = registry.getBeanProxyFactory().createExpression();
        exp.createMethodInvocation(ForExpression.ROOTEXPRESSION, "qqq", true, 2);
        exp.createClassInstanceCreation(ForExpression.METHOD_RECEIVER, "org.eclipse.jem.tests.proxy.initParser.tree.TestCompatibleMethodsData1", 0);
        exp.createProxyExpression(ForExpression.METHOD_ARGUMENT, (IProxy)a1);
        exp.createProxyExpression(ForExpression.METHOD_ARGUMENT, (IProxy)a2);
        return exp.getExpressionValue();
    }

    public void testAmbiguous() throws Throwable {
        ProxyFactoryRegistry registry = this.getTreeParser().getRegistry();
        try {
            this.executeQQQ((IBeanProxy)registry.getBeanProxyFactory().createBeanProxyWith(new Integer(1)), (IBeanProxy)registry.getBeanProxyFactory().createBeanProxyWith(new Integer(1)));
        }
        catch (ThrowableProxy e) {
            if (e.getTypeProxy().getTypeName().equals("org.eclipse.jem.internal.proxy.common.AmbiguousMethodException")) {
                return;
            }
            throw e;
        }
        TestCompatibleMethods.fail((String)"Should of thrown ambiquous.");
    }

    public void testExactMatch() throws Throwable {
        ProxyFactoryRegistry registry = this.getTreeParser().getRegistry();
        IIntegerBeanProxy result = (IIntegerBeanProxy)this.executeQQQ((IBeanProxy)registry.getBeanProxyFactory().createBeanProxyWith(new Integer(1)), registry.getBeanProxyFactory().createBeanProxyFrom("new Object()"));
        TestCompatibleMethods.assertEquals((int)2, (int)result.intValue());
        result = (IIntegerBeanProxy)this.executeQQQ(registry.getBeanProxyFactory().createBeanProxyFrom("new Object()"), registry.getBeanProxyFactory().createBeanProxyFrom("new Object()"));
        TestCompatibleMethods.assertEquals((int)0, (int)result.intValue());
    }

    public void testCompatibleMatch() throws Throwable {
        ProxyFactoryRegistry registry = this.getTreeParser().getRegistry();
        IIntegerBeanProxy result = (IIntegerBeanProxy)this.executeQQQ((IBeanProxy)registry.getBeanProxyFactory().createBeanProxyWith((Number)new Float(1.0f)), (IBeanProxy)registry.getBeanProxyFactory().createBeanProxyWith(new Integer(1)));
        TestCompatibleMethods.assertEquals((int)1, (int)result.intValue());
        result = (IIntegerBeanProxy)this.executeQQQ((IBeanProxy)registry.getBeanProxyFactory().createBeanProxyWith((Number)new Float(1.0f)), registry.getBeanProxyFactory().createBeanProxyFrom("new Object()"));
        TestCompatibleMethods.assertEquals((int)0, (int)result.intValue());
    }
}

