/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.sample.filesystem;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jst.validation.sample.filesystem.FilesystemManager;
import org.eclipse.jst.validation.sample.filesystem.IFilesystemHelper;
import org.eclipse.jst.validation.sample.filesystem.ValidatorMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class MessageManager {
    private static MessageManager _singleton = null;
    private Comparator _comparator = null;
    private Map _validationMessages = new HashMap(10);

    private MessageManager() {
    }

    public static MessageManager getManager() {
        if (_singleton == null) {
            _singleton = new MessageManager();
        }
        return _singleton;
    }

    public Map getMessages(int messageTypes) {
        HashMap<String, List> messages = new HashMap<String, List>();
        Iterator iterator = this._validationMessages.values().iterator();
        while (iterator.hasNext()) {
            ValidatorMessages mssg = (ValidatorMessages)iterator.next();
            messages.put(mssg.getValidator().getClass().getName(), mssg.getMessages(messageTypes));
        }
        return messages;
    }

    public ValidatorMessages getMessages(IValidator validator) {
        if (validator == null) {
            return null;
        }
        ValidatorMessages message = (ValidatorMessages)this._validationMessages.get(validator.getClass().getName());
        if (message == null) {
            message = new ValidatorMessages(validator);
            this._validationMessages.put(validator.getClass().getName(), message);
        }
        return message;
    }

    public void removeAllMessages(IValidator validator) {
        if (validator == null) {
            return;
        }
        this._validationMessages.remove(validator.getClass().getName());
    }

    public void removeAllMessages(IValidator validator, Object object) {
        if (validator == null) {
            return;
        }
        ValidatorMessages message = this.getMessages(validator);
        if (message != null) {
            message.removeAllMessages(object);
        }
    }

    public void removeMessageSubset(IValidator validator, Object object, String groupName) {
        if (validator == null) {
            return;
        }
        ValidatorMessages message = this.getMessages(validator);
        if (message != null) {
            message.removeAllMessages(object);
        }
    }

    public static String formatMessage(IValidator validator, IMessage message) {
        if (message == null) {
            return "";
        }
        int severity = message.getSeverity();
        Object object = message.getTargetObject();
        StringBuffer formattedMessage = new StringBuffer();
        switch (severity) {
            case 1: {
                formattedMessage.append("Error: ");
                break;
            }
            case 4: {
                formattedMessage.append("Information: ");
                break;
            }
            default: {
                formattedMessage.append("Warning: ");
            }
        }
        formattedMessage.append(message.getText());
        if (object != null) {
            String fileName = FilesystemManager.getManager().getHelper(validator).getFileName(message);
            int lineNumber = message.getLineNumber();
            if (fileName != null || lineNumber != 0) {
                formattedMessage.append("[");
                if (fileName != null) {
                    formattedMessage.append(fileName);
                }
                if (lineNumber != 0) {
                    formattedMessage.append(" line number: ");
                    formattedMessage.append(String.valueOf(lineNumber));
                }
                formattedMessage.append("] ");
            }
        }
        return formattedMessage.toString();
    }

    public Comparator getMessageComparator(final IFilesystemHelper helper) {
        if (this._comparator == null) {
            this._comparator = new Comparator(){

                protected int compare(String a, String b) {
                    if (a == null && b == null) {
                        return 0;
                    }
                    if (a == null) {
                        return -1;
                    }
                    if (b == null) {
                        return 1;
                    }
                    return a.compareTo(b);
                }

                protected int compare(int a, int b) {
                    if (a == 0 && b == 0) {
                        return 0;
                    }
                    if (a == 0) {
                        return -1;
                    }
                    if (b == 0) {
                        return 1;
                    }
                    return a - b;
                }

                public int compare(Object a, Object b) {
                    String bFileName;
                    if (a == null && b == null) {
                        return 0;
                    }
                    if (a == null) {
                        return -1;
                    }
                    if (b == null) {
                        return 1;
                    }
                    IMessage aMssg = (IMessage)a;
                    IMessage bMssg = (IMessage)b;
                    String aFileName = helper.getFileName(aMssg);
                    int result = this.compare(aFileName, bFileName = helper.getFileName(bMssg));
                    if (result != 0) {
                        return result;
                    }
                    int aLineNumber = aMssg.getLineNumber();
                    int bLineNumber = bMssg.getLineNumber();
                    return this.compare(aLineNumber, bLineNumber);
                }
            };
        }
        return this._comparator;
    }
}

