package oracle.adfdemo.view.faces.composite;

import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;

public class CompositeTest
{
  public CompositeTest()
  {
  }

  public UIComponent getDateInput()
  {
    return _dateInput;
  }

  public void setDateInput(UIComponent dateInput)
  {
    _dateInput = dateInput;
  }

  private UIComponent _dateInput = new ForceRendererType();

  /**
   * Turns out there's no easy way to simply replace the renderer
   * for a control like UIInput;  UIComponentTag will call setRendererType()
   * after consulting the "binding" attribute, overriding anything
   * done in either the getter or setter.  So, here's a subclass
   * that forces the renderer type to a constant.  The alternative
   * is writing a custom JSP tag to do the same, but then you
   * have to re-invent the wheel as far as the input tag goes.
   */
  static public class ForceRendererType extends UIInput
  {
    public String getRendererType()
    {
      return "oracle.adfdemo.DateField";
    }
  }
}
