/* Copyright (c) Oracle Corporation 2004. All Rights Reserved. */

package oracle.adfdemo.view.faces.email;

import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;

/**
 * Bean which provides preferences data
 *
 * @version 1.0
 */
public class PreferencesData
{
  /**
   * Branding type for "regular" branding, which includes the
   * corporate brand, a large product brand, and global button
   * icons.
   */
  public static String REGULAR_BRANDING = "regular";

  /**
   * Branding type for "medium" branding, which includes the
   * corporate brand, a smaller product brand, and no global
   * button icons
   */
  public static String MEDIUM_BRANDING = "medium";

  /**
   * Branding type for "small" branding, which includes the
   * corporate brand, no product brand, and no global
   * button icons
   */
  public static String SMALL_BRANDING = "small";

  /**
   * Creates a PreferencesData object with default preferences
   */
  public PreferencesData()
  {
    // need public accesibility mode constants declared in ADF Faces!
    _branding = REGULAR_BRANDING;
    _rowsShown = _DEFAULT_ROWS_SHOWN;
    _displayFolderTree = true;
    _displaySenderColumn = true;
    _displayDateColumn = true;
    _displaySizeColumn = true;
    _lookAndFeel = "oracle";
    _accessibilityMode = "default";
  }


  /**
   * @todo Provide internationalized list.
   */
  public List getLookAndFeelItems()
  {
    return _LOOK_AND_FEELS;
  }


  /**
   * @todo Provide internationalized list.
   */
  public List getAccessibilityModeItems()
  {
    return _ACCESSIBILITY_MODES;
  }

  /**
   * Returns the look-and-feel for the application.
   */
  public String getLookAndFeel()
  {
    return _lookAndFeel;
  }


  /**
   * Returns the look-and-feel for the application.
   */
  public void setLookAndFeel(String lookAndFeel)
  {
    _lookAndFeel = lookAndFeel;
  }

  /**
   * Returns the AccessibilityMode for this user
   */
  public String getAccessibilityMode()
  {
    return _accessibilityMode;
  }


  /**
   * Returns the branding type: REGULAR_BRANDING,
   * MEDIUM_BRANDING or SMALL_BRANDING
   */
  public String getBranding()
  {
    return _branding;
  }

  /**
   * Returns the numbers of rows to display in the messages table.
   */
  public int getRowsShown()
  {
    return _rowsShown;
  }

  /**
   * Gets whether the SideBar with the folder tree is displayed
   */
  public boolean getDisplayFolderTree()
  {
    return _displayFolderTree;
  }

  /**
   * Sets whether the SideBar with the folder tree is displayed
   */
  public void setDisplayFolderTree(boolean isDisplayed)
  {
    _displayFolderTree = isDisplayed;
  }

  /**
   * Gets whether the sender column is displayed
   */
  public boolean getDisplaySenderColumn()
  {
    return _displaySenderColumn;
  }

  /**
   * Sets whether the sender column is displayed
   */
  public void setDisplaySenderColumn(boolean isDisplayed)
  {
    _displaySenderColumn = isDisplayed;
  }

  /**
   * Gets whether the date column is displayed
   */
  public boolean getDisplayDateColumn()
  {
    return _displayDateColumn;
  }

  /**
   * Sets whether the date column is displayed
   */
  public void setDisplayDateColumn(boolean isDisplayed)
  {
    _displayDateColumn = isDisplayed;
  }

  /**
   * Gets whether the size column is displayed
   */
  public boolean getDisplaySizeColumn()
  {
    return _displaySizeColumn;
  }

  /**
   * Sets whether the size column is displayed
   */
  public void setDisplaySizeColumn(boolean isDisplayed)
  {
    _displaySizeColumn = isDisplayed;
  }

  /**
   * Gets whether the user wants to preview the email message underneath
   * the message list
   */
  public boolean isPreviewMessageMode()
  {
    return _isPreviewMessageMode;
  }

  /**
   * Sets whether the user wants to preview the email message underneath
   * the message list
   */
  public void setPreviewMessageMode(boolean enable)
  {
    _isPreviewMessageMode = enable;
  }

  /**
   * Sets the AccessibilityMode for this user.
   */
  public void setAccessibilityMode(String accessibilityMode)
  {
    _accessibilityMode = accessibilityMode;
  }

  /**
   * Sets the branding.  Must be one of: REGULAR_BRANDING,
   * MEDIUM_BRANDING, or SMALL_BRANDING.
   */
  public void setBranding(String branding)
  {
    // assert (REGULAR_BRANDING.equals(branding) ||
  //    MEDIUM_BRANDING.equals(branding)  ||
  //    SMALL_BRANDING.equals(branding));

    _branding = branding;
  }

  /**
   * Sets the number of rows to show in the messages table.
   */
  public void setRowsShown(int rowsShown)
  {
    // assert rowsShown > 0;

    if (rowsShown > 0)
      _rowsShown = rowsShown;
  }

  private String  _accessibilityMode;  // The accessibility mode
  private String  _branding;          // The branding type
  private String  _lookAndFeel;          // The branding type
  private int     _rowsShown;         // How many rows to show
  private boolean _displayFolderTree;
  private boolean _displaySenderColumn;
  private boolean _displayDateColumn;
  private boolean _displaySizeColumn;
  private boolean _isPreviewMessageMode = false;

  private static final int _DEFAULT_ROWS_SHOWN = 25;

  private static final List _ACCESSIBILITY_MODES = new ArrayList();
  static
  {
    _ACCESSIBILITY_MODES.add(new SelectItem("default", "Default"));
    _ACCESSIBILITY_MODES.add(new SelectItem("inaccessible", "None"));
    _ACCESSIBILITY_MODES.add(new SelectItem("screenReader", "Screen Readers"));
  }

  private static final List _LOOK_AND_FEELS = new ArrayList();
  static
  {
    _LOOK_AND_FEELS.add(new SelectItem("oracle", "Oracle"));
    _LOOK_AND_FEELS.add(new SelectItem("minimal", "Minimal"));
  }
}
