package oracle.adfdemo.view.faces.table;
import java.io.Serializable;
import javax.faces.model.DataModel;

public class DynamicModel extends DataModel implements Serializable 
{
  public DynamicModel()
  {
  }
  
  public int getRowCount()
  {
    return _rowCount;    
  }
  
  public void setRowCount(int count)
  {
    if ((count >= -1) && (count <= 400))
      _rowCount = count;
  }
  
  public int getActualRowCount()
  {
    return _length;
  }
  
  public void setActualRowCount(int count)
  {
    if ((count >= 0) && (count <= 400))
      _length = count;
  }
  
  public int getBlockSize()
  {
    return _blockSize;
  }
  
  public void setBlockSize(int blockSize)
  {
    if (blockSize >= 0)
    {
      _blockSize = blockSize;
    }
  }
  
  public boolean isRowAvailable()
  {
    return (_index >= 0) && (_index < _length);
  }
  
  public Object getRowData()
  {
    return isRowAvailable() ? new Integer(_index) : null;
  }
  
  public int getRowIndex()
  {
    return _index;
  }
  
  public void setRowIndex(int index)
  {
    _index = index;
  }
  
  public Object getWrappedData()
  {
    return this;
  }
  
  public void setWrappedData(Object obj)
  {
    throw new UnsupportedOperationException();
  }
    
  private int _rowCount = -1;
  private int _length = 25;
  private int _index = -1;
  private int _blockSize = 10;
}