/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.utils;

import java.util.regex.Pattern;

public class StringUtil {
    private static final Pattern htmlToNewline = Pattern.compile("</p>|<br>");
    private static final Pattern removeHTMLTags = Pattern.compile("<[/?\\w\\s=\"\\.\\#]+>");
    private static final Pattern trimInteriorWhitespace = Pattern.compile("[ ]+");

    public static String splitVariable(String variable) {
        StringBuffer output = new StringBuffer("");
        boolean isCapitalLeading = false;
        boolean isLastSpace = false;
        int i = 0;
        int n = variable.length();
        while (i < n) {
            char nextLetter;
            int nextIndex;
            char letter = variable.charAt(i);
            if (letter == '_' || letter == '$') {
                output.append(" ");
                isCapitalLeading = false;
                isLastSpace = true;
            } else if (Character.isLowerCase(letter) && (nextIndex = i + 1) < n && Character.isUpperCase(nextLetter = variable.charAt(nextIndex))) {
                if (isCapitalLeading) {
                    output.append(letter);
                    isLastSpace = false;
                } else {
                    output.append(Character.toUpperCase(letter));
                    isLastSpace = false;
                }
                if (!isLastSpace) {
                    output.append(' ');
                    isLastSpace = true;
                }
                isCapitalLeading = false;
            } else if (Character.isUpperCase(letter) && (nextIndex = i + 1) < n && Character.isLowerCase(nextLetter = variable.charAt(nextIndex))) {
                if (!isLastSpace) {
                    output.append(' ');
                    isLastSpace = true;
                }
                output.append(letter);
                isCapitalLeading = true;
                isLastSpace = false;
            } else if (isCapitalLeading) {
                output.append(letter);
                isLastSpace = false;
            } else {
                output.append(Character.toUpperCase(letter));
                isCapitalLeading = true;
                isLastSpace = false;
            }
            ++i;
        }
        return output.toString().trim();
    }

    public static boolean isSameString(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static String filterConvertString(String text) {
        if (text == null) {
            return "";
        }
        String result = htmlToNewline.matcher(text).replaceAll("\n");
        result = removeHTMLTags.matcher(result).replaceAll("");
        result = trimInteriorWhitespace.matcher(result).replaceAll(" ");
        return result;
    }

    public static boolean isEmptyString(String str) {
        return str == null || str.length() == 0;
    }
}

