/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility.jdt;

import java.beans.Introspector;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jpt.core.internal.utility.jdt.ASTNodeTextRange;
import org.eclipse.jpt.core.internal.utility.jdt.DefaultAnnotationEditFormatter;
import org.eclipse.jpt.core.internal.utility.jdt.JDTAttribute;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.internal.utility.jdt.JPTTools;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.core.utility.jdt.MethodAttribute;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.CommandExecutorProvider;
import org.eclipse.jpt.utility.JavaType;
import org.eclipse.jpt.utility.MethodSignature;
import org.eclipse.jpt.utility.internal.SimpleMethodSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTMethodAttribute
extends JDTAttribute
implements MethodAttribute {
    private final JavaType[] parameterTypes;

    public static JDTMethodAttribute newInstance(Type declaringType, MethodSignature signature, int occurrence, ICompilationUnit compilationUnit, CommandExecutorProvider modifySharedDocumentCommandExecutorProvider) {
        return JDTMethodAttribute.newInstance(declaringType, signature, occurrence, compilationUnit, modifySharedDocumentCommandExecutorProvider, DefaultAnnotationEditFormatter.instance());
    }

    public static JDTMethodAttribute newInstance(Type declaringType, MethodSignature signature, int occurrence, ICompilationUnit compilationUnit, CommandExecutorProvider modifySharedDocumentCommandExecutorProvider, AnnotationEditFormatter annotationEditFormatter) {
        return new JDTMethodAttribute(declaringType, signature, occurrence, compilationUnit, modifySharedDocumentCommandExecutorProvider, annotationEditFormatter);
    }

    public JDTMethodAttribute(Type declaringType, MethodSignature methodSignature, int occurrence, ICompilationUnit compilationUnit, CommandExecutorProvider modifySharedDocumentCommandExecutorProvider) {
        this(declaringType, methodSignature, occurrence, compilationUnit, modifySharedDocumentCommandExecutorProvider, (AnnotationEditFormatter)DefaultAnnotationEditFormatter.instance());
    }

    public JDTMethodAttribute(Type declaringType, MethodSignature methodSignature, int occurrence, ICompilationUnit compilationUnit, CommandExecutorProvider modifySharedDocumentCommandExecutorProvider, AnnotationEditFormatter annotationEditFormatter) {
        super(declaringType, methodSignature.getName(), occurrence, compilationUnit, modifySharedDocumentCommandExecutorProvider, annotationEditFormatter);
        this.parameterTypes = methodSignature.getParameterTypes();
    }

    public JDTMethodAttribute(Type declaringType, String name, String[] parameterTypeNames, int occurrence, ICompilationUnit compilationUnit) {
        this(declaringType, (MethodSignature)new SimpleMethodSignature(name, parameterTypeNames), occurrence, compilationUnit, CommandExecutorProvider.Default.instance(), (AnnotationEditFormatter)DefaultAnnotationEditFormatter.instance());
    }

    @Override
    public IMethodBinding getBinding(CompilationUnit astRoot) {
        return this.getBodyDeclaration(astRoot).resolveBinding();
    }

    @Override
    public MethodDeclaration getBodyDeclaration(CompilationUnit astRoot) {
        int count = 0;
        MethodDeclaration[] methodDeclarationArray = this.getDeclaringTypeMethodDeclarations(astRoot);
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            if (this.matches(methodDeclaration) && ++count == this.getOccurrence()) {
                return methodDeclaration;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public boolean matches(MethodSignature signature, int occurrence) {
        return this.matches(signature) && occurrence == this.getOccurrence();
    }

    protected boolean matches(MethodSignature signature) {
        return signature.getName().equals(this.getName_()) && Arrays.equals(this.parameterTypes, signature.getParameterTypes());
    }

    protected boolean matches(MethodDeclaration methodDeclaration) {
        return this.matches(JDTTools.buildMethodSignature(methodDeclaration));
    }

    protected static List<SingleVariableDeclaration> parameters(MethodDeclaration methodDeclaration) {
        return methodDeclaration.parameters();
    }

    @Override
    public boolean matches(String memberName, int occurrence) {
        throw new UnsupportedOperationException("Use #matches(org.eclipse.jdt.core.dom.MethodDeclaration, int).");
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return new ASTNodeTextRange((ASTNode)this.getBodyDeclaration(astRoot).getName());
    }

    @Override
    public String getAttributeName() {
        String name = this.getName_();
        int beginIndex = 0;
        if (name.startsWith("get")) {
            beginIndex = 3;
        } else if (name.startsWith("is")) {
            beginIndex = 2;
        }
        return Introspector.decapitalize(name.substring(beginIndex));
    }

    @Override
    public ITypeBinding getTypeBinding(CompilationUnit astRoot) {
        IMethodBinding methodBinding = this.getBodyDeclaration(astRoot).resolveBinding();
        if (methodBinding != null) {
            return methodBinding.getReturnType();
        }
        return null;
    }

    @Override
    public boolean isMethod() {
        return true;
    }

    @Override
    public boolean isPersistable(CompilationUnit astRoot) {
        IMethodBinding binding = this.getBinding(astRoot);
        return binding == null ? false : JPTTools.methodIsPersistablePropertyGetter(binding);
    }

    protected MethodDeclaration[] getDeclaringTypeMethodDeclarations(CompilationUnit astRoot) {
        return this.getDeclaringTypeDeclaration(astRoot).getMethods();
    }
}

