/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test.setup;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.validation.test.BVTValidationPlugin;
import org.eclipse.jst.validation.test.setup.AImportOperation;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;

public class JARImportOperation
extends AImportOperation {
    public static void createProject(IProject project, IPath locationPath, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            if (!project.exists()) {
                IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
                if (Platform.getLocation().equals((Object)locationPath)) {
                    locationPath = null;
                }
                desc.setLocation(locationPath);
                project.create(desc, monitor);
                monitor = null;
            }
            if (!project.isOpen()) {
                project.open(monitor);
                monitor = null;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static void addJavaNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = "org.eclipse.jdt.core.javanature";
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        } else {
            monitor.worked(1);
        }
    }

    private void configureProject(IProgressMonitor monitor, IProject project) {
        try {
            IClasspathEntry rtJar;
            IJavaProject jp = JavaCore.create((IProject)project);
            jp.setRawClasspath(null, (IProgressMonitor)new SubProgressMonitor(monitor, 7));
            IClasspathEntry[] existingClasspath = jp.getRawClasspath();
            IClasspathEntry[] classpath = new IClasspathEntry[existingClasspath.length + 1];
            System.arraycopy(existingClasspath, 0, classpath, 0, existingClasspath.length);
            classpath[existingClasspath.length] = rtJar = JavaCore.newVariableEntry((IPath)new Path("JRE_LIB"), (IPath)new Path("JRE_SRC"), null);
            jp.setRawClasspath(classpath, (IProgressMonitor)new SubProgressMonitor(monitor, 7));
            ValidatorManager.addProjectBuildValidationSupport((IProject)project);
        }
        catch (JavaModelException exc) {
            BVTValidationPlugin.getPlugin().handleException(exc);
        }
    }

    protected IProject createNewProject(IProgressMonitor monitor, String projectName, File inputFile) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        try {
            JARImportOperation.createProject(project, null, monitor);
            JARImportOperation.addJavaNature(project, monitor);
            this.configureProject(monitor, project);
        }
        catch (CoreException exc) {
            BVTValidationPlugin.getPlugin().handleException(exc);
        }
        return project;
    }

    protected void createFolder(IProgressMonitor monitor, IProject project, IPath pathname) throws CoreException {
        IFolder folder = project.getFolder(pathname);
        IContainer container = folder.getParent();
        if (!container.exists()) {
            this.createFolder(monitor, project, container.getProjectRelativePath());
        }
        if (!folder.exists()) {
            folder.create(true, true, monitor);
        }
    }

    protected void createFile(IProgressMonitor monitor, IProject project, IPath pathname, InputStream stream) throws CoreException {
        IFile nfile = project.getFile(pathname);
        IContainer container = nfile.getParent();
        if (!container.exists()) {
            this.createFolder(monitor, project, container.getProjectRelativePath());
        }
        if (!nfile.exists()) {
            nfile.create(stream, true, monitor);
        }
    }

    protected boolean importFile(IProgressMonitor monitor, IProject project, File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                Path pathname = new Path(zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    this.createFolder(monitor, project, (IPath)pathname);
                    continue;
                }
                this.createFile(monitor, project, (IPath)pathname, zipFile.getInputStream(zipEntry));
            }
            return true;
        }
        catch (IOException exc) {
            BVTValidationPlugin.getPlugin().handleException(exc);
            return false;
        }
        catch (CoreException exc) {
            BVTValidationPlugin.getPlugin().handleException(exc);
            return false;
        }
    }
}

