/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.test;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ReadOnlyDirectory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;

public class SaveTests
extends TestCase {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    static /* synthetic */ Class class$0;

    public SaveTests(String name) {
        super(name);
    }

    public CommonarchiveFactory getArchiveFactory() {
        return CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
    }

    public static void main(String[] args) {
        String[] className = new String[]{"com.ibm.etools.archive.test.SaveTests", "-noloading"};
        TestRunner.main((String[])className);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.archive.test.SaveTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void testSave() throws Exception {
        Archive anArchive = this.getArchiveFactory().openArchive(String.valueOf(AutomatedBVT.baseDirectory) + "example2.war");
        anArchive.saveAsNoReopen(String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/SaveTests/copy.war");
        anArchive = null;
        WARFile aWarFile = (WARFile)this.getArchiveFactory().openArchive(String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/SaveTests/copy.war");
        ReadOnlyDirectory sampleDirectory = this.getArchiveFactory().openReadOnlyDirectory(String.valueOf(AutomatedBVT.baseDirectory) + "WarTestClasses");
        int initialSize = aWarFile.getClasses().size();
        File aFile = sampleDirectory.getFileInSelfOrSubdirectory("com/ibm/etools/archive/test/WARFileTests.class");
        aWarFile.addCopyClass(aFile);
        SaveTests.assertTrue((aWarFile.getClasses().size() == initialSize + 1 ? 1 : 0) != 0);
        String classURI = ArchiveUtil.concatUri((String)"WEB-INF/classes/", (String)aFile.getURI(), (char)'/');
        SaveTests.assertTrue((boolean)aWarFile.containsFile(classURI));
        aWarFile.save();
        File classFile = aWarFile.getFile(classURI);
        SaveTests.assertTrue((String)"File should not be null", (classFile != null ? 1 : 0) != 0);
        SaveTests.assertTrue((String)"Wrong loading archive", (classFile.getLoadingContainer() == aWarFile ? 1 : 0) != 0);
        SaveTests.assertTrue((String)"Wrong original URI", (boolean)classFile.getOriginalURI().equals(classURI));
        aWarFile.saveAs("testOutput/SaveTests/copy2.war");
        aWarFile.save();
    }

    public void testSaveDirectory() throws Exception {
        Archive anArchive = this.getArchiveFactory().openArchive(String.valueOf(AutomatedBVT.baseDirectory) + "sample.ear");
        anArchive.saveAsNoReopen(String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/SaveTests/sample-copied.ear");
        anArchive = null;
        EARFile anEARFile = (EARFile)this.getArchiveFactory().openArchive(String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/SaveTests/sample-copied.ear");
        anEARFile.getDeploymentDescriptor();
        anEARFile.extractNoReopen(2);
    }
}

