package oracle.adfdemo.view.faces.survey;

import java.util.ArrayList;

/***
 *  class CheckboxQuestionBean
 *
 * This bean represents a single multiple-answer checkbox style question.
 * It has fields for the question prompt, a list of choices, and all the
 * correct checkboxes in the answer.
 *
 * [Note: Due to a lack of support for dynamically iterating through data in
 * early releases of ADF Faces, this bean contains special get methods that help
 * iterate through the list of choices for printing out on the screen.]
 *
 * ***/

public class CheckboxQuestionBean implements java.io.Serializable
{

 /** The question prompt as a String object */
 private String   _prompt;

 /** arbitrary number of possible answer choices (Strings) */
 private ArrayList  _choices;

 /** A variable that is used to iterate over the answer choices in this bean*/
 private int   _answerIndex;

  /** An integer that represents the correct checkbox choices */
  private int   _correctAnswer;

  /** the booleans to represent the correct choices */
  private boolean   _checkbox0;
  private boolean   _checkbox1;
  private boolean   _checkbox2;
  private boolean   _checkbox3;

  // a debug flag
  private boolean debug = false;



  /**
    *  Class constructor (no arguments).
    */
  public CheckboxQuestionBean()
  {
    _answerIndex = 0;
  }

    /**
     *  Class constructor.
     */
    public CheckboxQuestionBean(String prompt, ArrayList choices, int correctAnswer,
        boolean checkbox0, boolean checkbox1, boolean checkbox2, boolean checkbox3)
    {
      _prompt = prompt;
      _choices = choices;
      _answerIndex = 0;
      _correctAnswer = correctAnswer;

      _checkbox0 = checkbox0;
      _checkbox1 = checkbox1;
      _checkbox2 = checkbox2;
      _checkbox3 = checkbox3;
    }


  /*** Accessors ***/

 /**
   *  returns the question prompt.
   *
   *  @return the question prompt
   */
 public String getPrompt()
 {
    // after getting the prompt, we want to initialize the iterator index
    // for the answers
    _answerIndex = 0;
  return _prompt;
 }

  /**
    *  returns the next answer string.  This method is designed to approximate
    *  dynamic iteration through the possible answer choices.  It uses the
    *  "answerIndex" variable to keep track of the current answer choice to
    *  display.
    *
    *  @return  the next answer choice
    */
  public String getAnswerString()
 {

    if (debug) {
      System.out.println("in getAnswerString for [" + _prompt + "], answerIndex is:" + _answerIndex);
    }

    String result = (String)_choices.get(_answerIndex);
    _answerIndex++;
    return result;
 }


  /*** util functions ***/

  /**
   * resets the iterator index variable so that the answer choices can be
   * iterated through again from the beginning.
   */
 public void reset()
  {
    _answerIndex = 0;
  }

  /**
   * typical toString method
   *
   * @return a String representation of a QuestionBean
   */
  public String toString()
  {
    String str = _prompt + "; " + "answerIndex: " + _answerIndex + "; "+ _choices.toString();
    return str;
  }


  /**
   * returns a message describing the correct answer choices.
   *
   * @return a message describing the correct answer choices
   */
 public String getCorrectAnswerMessage()
 {
    String message = "The correct answer is: ";
    String bitMap = Integer.toBinaryString(_correctAnswer);
    int i,j;
    boolean atLeastOneSelected = false;

    // since toBinaryString() library method does not put in leading zeros,
    // we need to make sure bitMap is as long as NUMBER_OF_ANSWER_CHOICES
    while (bitMap.length() < SurveyBean.NUMBER_OF_ANSWER_CHOICES)
    {
      // prepend leading zeros
      bitMap = '0' + bitMap;
    }

    // beginning with the NUMBER_OF_ANSWER_CHOICES-th bit from the right
    // check until the end of the string
    for (i=bitMap.length()-SurveyBean.NUMBER_OF_ANSWER_CHOICES, j=0;
          i<bitMap.length() && j<_choices.size();
          i++, j++)
    {
      // if the considered bit is 1
      if (debug)
      {
        System.out.println("in cbqb, bitMap is: " + bitMap + ", getting " + i + "th char, which is: " + bitMap.charAt(i));
      }
      if( bitMap.charAt(i) == '1')
      {
         // it's a correct solution
         message = message + (String)_choices.get(j) + " & ";
         atLeastOneSelected = true;
      }
    } //end for loop

    if (atLeastOneSelected)
    {
      // remove extra " & " from end of message
      message = message.substring(0, message.length()-3);
    }

    return message;
 }


  /**
   * Returns a message describing the correct answer for a particular checkbox.
   *
   * @param   checkboxNum the index of the checkbox
   *
   * @return a message describing the correct answer choices
   */
 public String getCorrectAnswerMessage(int checkboxNum)
 {
    String message = "INCORRECT";
//    String message = "The correct answer is: ";
//
//    switch (checkboxNum)
//    {
//      case(0):
//        message = message + getCheckbox0();
//        break;
//      case(1):
//        message = message + getCheckbox1();
//        break;
//      case(2):
//        message = message + getCheckbox2();
//        break;
//      case(3):
//        message = message + getCheckbox3();
//        break;
//    }

    return message;
 }

/*** IDE generated accessors ***/

  public boolean getCheckbox0()
  {
    return _checkbox0;
  }


  public boolean getCheckbox1()
  {
    return _checkbox1;
  }


  public boolean getCheckbox2()
  {
    return _checkbox2;
  }


  public boolean getCheckbox3()
  {
    return _checkbox3;
  }


  public int getCorrectAnswer()
  {
    return _correctAnswer;
  }

}
