/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsil.perspective;

import java.util.Hashtable;
import javax.servlet.ServletContext;
import org.eclipse.wst.ws.internal.datamodel.BasicModel;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Perspective;
import org.eclipse.wst.ws.internal.explorer.platform.util.DirUtils;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.actions.OpenWSILAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.actions.SwitchPerspectiveFromWSILAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.perspective.WsilMainNode;

public class WSILPerspective
extends Perspective {
    private BasicModel model_;
    private NodeManager nodeManager_;
    private String perspectiveContentFramesetCols_;
    private String savedPerspectiveContentFramesetCols_;
    private String actionsContainerFramesetRows_;
    private String savedActionsContainerFramesetRows_;

    public WSILPerspective(Controller controller) {
        super("wsil", controller);
    }

    public final void initPerspective(ServletContext application) {
        this.model_ = new BasicModel("WsilModel");
        TreeElement treeElement = new TreeElement(this.getMessage("WSIL_MAIN_NODE"), (Model)this.model_);
        this.model_.setRootElement((Element)treeElement);
        this.nodeManager_ = new NodeManager(this.controller_);
        WsilMainNode wsilMainNode = new WsilMainNode(treeElement, this.nodeManager_);
        this.nodeManager_.setRootNode(wsilMainNode);
        this.perspectiveContentFramesetCols_ = !DirUtils.isRTL() ? "30%,*" : "*,30%";
        this.savedPerspectiveContentFramesetCols_ = this.perspectiveContentFramesetCols_;
        this.savedActionsContainerFramesetRows_ = this.actionsContainerFramesetRows_ = "75%,*";
    }

    public final void preloadWSIL(String[] wsilURL) {
        if (wsilURL != null) {
            int index = 0;
            while (index < wsilURL.length) {
                OpenWSILAction action = new OpenWSILAction(this.controller_);
                Hashtable table = action.getPropertyTable();
                table.put("wsilURL", wsilURL[index]);
                table.put("wsilInspectionType", String.valueOf(0));
                action.run();
                ++index;
            }
            if (wsilURL.length > 0) {
                this.controller_.setCurrentPerspective(1);
            }
        }
    }

    public NodeManager getNodeManager() {
        return this.nodeManager_;
    }

    public String getPerspectiveContentPage() {
        return "wsil/wsil_perspective_content.jsp";
    }

    public int getPerspectiveId() {
        return 1;
    }

    public String getPanesFile() {
        return "wsil/scripts/wsilPanes.jsp";
    }

    public String getFramesetsFile() {
        return "wsil/scripts/wsilframesets.jsp";
    }

    public String getProcessFramesetsForm() {
        return "wsil/forms/ProcessWSILFramesetsForm.jsp";
    }

    public String getTreeContentVar() {
        return "wsilNavigatorContent";
    }

    public String getTreeContentPage() {
        return "wsil/wsil_navigator_content.jsp";
    }

    public String getPropertiesContainerVar() {
        return "wsilPropertiesContainer";
    }

    public String getPropertiesContainerPage() {
        return "wsil/wsil_properties_container.jsp";
    }

    public String getStatusContentVar() {
        return "wsilStatusContent";
    }

    public String getStatusContentPage() {
        return "wsil/wsil_status_content.jsp";
    }

    public final String getPerspectiveContentFramesetCols() {
        return this.perspectiveContentFramesetCols_;
    }

    public final void setPerspectiveContentFramesetCols(String cols) {
        this.perspectiveContentFramesetCols_ = cols;
    }

    public final String getSavedPerspectiveContentFramesetCols() {
        return this.savedPerspectiveContentFramesetCols_;
    }

    public final void setSavedPerspectiveContentFramesetCols(String cols) {
        this.savedPerspectiveContentFramesetCols_ = cols;
    }

    public final String getActionsContainerFramesetRows() {
        return this.actionsContainerFramesetRows_;
    }

    public final void setActionsContainerFramesetRows(String rows) {
        this.actionsContainerFramesetRows_ = rows;
    }

    public final String getSavedActionsContainerFramesetRows() {
        return this.savedActionsContainerFramesetRows_;
    }

    public final void setSavedActionsContainerFramesetRows(String rows) {
        this.savedActionsContainerFramesetRows_ = rows;
    }

    public final String getSwitchPerspectiveFormActionLink(int targetPerspectiveId, boolean forHistory) {
        return SwitchPerspectiveFromWSILAction.getFormActionLink(targetPerspectiveId, forHistory);
    }
}

