/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.common;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.WrappedException;

public class StatusObjectHandler {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    private static final int MAX_DETAILS = 16;

    public static IStatus generateTreeStatus(IStatus status) {
        LinkedList statusList = new LinkedList();
        StatusObjectHandler.appendStatus(16, statusList, status, status.getSeverity());
        if (statusList.size() > 0) {
            IStatus newStatus = (IStatus)statusList.removeFirst();
            if (statusList.size() > 0) {
                IStatus[] secondaryStatusArray = new IStatus[statusList.size()];
                int n = 0;
                Iterator i = statusList.iterator();
                while (i.hasNext()) {
                    secondaryStatusArray[n++] = (IStatus)i.next();
                }
                newStatus = new MultiStatus(status.getPlugin(), status.getCode(), secondaryStatusArray, status.getMessage(), status.getException());
            }
            return newStatus;
        }
        return null;
    }

    private static int appendStatus(int max, List statusList, IStatus status, int severity) {
        if (max > 0 && status != null) {
            if (status.getMessage() != null) {
                max = StatusObjectHandler.append(statusList, max, severity, status.getPlugin(), status.getCode(), status.getMessage(), status.getException());
            }
            max = StatusObjectHandler.appendThrowable(max, statusList, status.getException(), severity);
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length && max > 0) {
                max = StatusObjectHandler.appendStatus(max, statusList, children[i], severity);
                ++i;
            }
        }
        return max;
    }

    private static int appendThrowable(int max, List statusList, Throwable throwable, int severity) {
        if (max > 0 && throwable != null) {
            if (throwable.getLocalizedMessage() != null) {
                max = StatusObjectHandler.append(statusList, max, severity, "org.eclipse.jst.ws", 0, throwable.getLocalizedMessage(), throwable);
            }
            if (throwable instanceof WrappedException) {
                WrappedException wexc = (WrappedException)throwable;
                max = StatusObjectHandler.appendThrowable(max, statusList, wexc.exception(), severity);
            }
            if (throwable instanceof CoreException) {
                CoreException cexc = (CoreException)throwable;
                max = StatusObjectHandler.appendStatus(max, statusList, cexc.getStatus(), severity);
            }
        }
        return max;
    }

    private static int append(List statusList, int max, int severity, String id, int code, String message, Throwable throwable) {
        if (max > 0) {
            Status status = new Status(severity, id, code, message, throwable);
            statusList.add(status);
            --max;
        }
        return max;
    }
}

