/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;

public class TomcatServerUtil {
    protected TomcatServerUtil() {
    }

    protected static int getClasspathKindFromString(String kindStr) {
        if (kindStr.equalsIgnoreCase("var")) {
            return 4;
        }
        if (kindStr.equalsIgnoreCase("lib")) {
            return 1;
        }
        return -1;
    }

    protected static String getClasspathKindToString(int kind) {
        switch (kind) {
            case 1: {
                return "lib";
            }
            case 4: {
                return "var";
            }
        }
        return "unknown";
    }

    protected static IClasspathEntry createClasspathEntry(IPath path, int kind, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath) {
        switch (kind) {
            case 1: {
                if (!path.isAbsolute()) {
                    return null;
                }
                return JavaCore.newLibraryEntry((IPath)path, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath);
            }
            case 4: {
                return JavaCore.newVariableEntry((IPath)path, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath);
            }
        }
        return null;
    }
}

