/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.rules;

import java.util.ArrayList;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;

public class StructuredDocumentDamagerRepairer
extends DefaultDamagerRepairer {
    private LineStyleProvider fProvider = null;

    public StructuredDocumentDamagerRepairer() {
        super((ITokenScanner)new RuleBasedScanner());
    }

    public StructuredDocumentDamagerRepairer(LineStyleProvider provider) {
        super((ITokenScanner)new RuleBasedScanner());
        this.fProvider = provider;
    }

    public void createPresentation(TextPresentation presentation, ITypedRegion region) {
        if (this.fProvider != null) {
            int numberOfStyles;
            ArrayList styles = new ArrayList();
            boolean handled = this.fProvider.prepareRegions(region, region.getOffset(), region.getLength(), styles);
            if (handled && (numberOfStyles = styles.size()) > 0) {
                StyleRange firstRange = (StyleRange)styles.get(0);
                StyleRange lastRange = (StyleRange)styles.get(numberOfStyles - 1);
                if (region.getOffset() <= firstRange.start && lastRange.start + lastRange.length <= region.getOffset() + region.getLength()) {
                    int i = 0;
                    while (i < numberOfStyles) {
                        presentation.addStyleRange((StyleRange)styles.get(i));
                        ++i;
                    }
                }
            }
        }
    }

    public void setProvider(LineStyleProvider provider) {
        this.fProvider = provider;
    }
}

