/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.InheritanceType;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaTable;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaTable;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.TableAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaTable
extends AbstractJavaTable
implements JavaTable {
    protected JavaResourcePersistentMember persistentResource;

    public GenericJavaTable(JavaEntity parent) {
        super(parent);
    }

    @Override
    public void initializeFromResource(JavaResourcePersistentMember persistentResource) {
        this.persistentResource = persistentResource;
        this.initializeFromResource(this.getTableResource());
    }

    @Override
    protected TableAnnotation getTableResource() {
        return (TableAnnotation)this.persistentResource.getNonNullAnnotation(this.getAnnotationName());
    }

    @Override
    protected String getAnnotationName() {
        return "javax.persistence.Table";
    }

    @Override
    public JavaEntity getParent() {
        return (JavaEntity)super.getParent();
    }

    protected JavaEntity getJavaEntity() {
        return this.getParent();
    }

    protected Entity getRootEntity() {
        return this.getJavaEntity().getRootEntity();
    }

    @Override
    protected String defaultName() {
        if (this.getJavaEntity().getInheritanceStrategy() == InheritanceType.SINGLE_TABLE && this.getRootEntity() != this.getJavaEntity()) {
            return this.getRootEntity().getTable().getName();
        }
        return this.getJavaEntity().getName();
    }

    @Override
    protected String defaultSchema() {
        if (this.getJavaEntity().getInheritanceStrategy() == InheritanceType.SINGLE_TABLE && this.getRootEntity() != this.getJavaEntity()) {
            return this.getRootEntity().getTable().getSchema();
        }
        return super.defaultSchema();
    }

    @Override
    protected String defaultCatalog() {
        if (this.getJavaEntity().getInheritanceStrategy() == InheritanceType.SINGLE_TABLE && this.getRootEntity() != this.getJavaEntity()) {
            return this.getRootEntity().getTable().getCatalog();
        }
        return super.defaultCatalog();
    }

    @Override
    public void update(JavaResourcePersistentMember persistentResource) {
        this.persistentResource = persistentResource;
        this.update(this.getTableResource());
    }

    @Override
    public void addToMessages(List<IMessage> messages, CompilationUnit astRoot) {
        super.addToMessages(messages, astRoot);
        boolean doContinue = this.connectionProfileIsActive();
        String schema = this.getSchema();
        if (doContinue && !this.hasResolvedSchema()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "TABLE_UNRESOLVED_SCHEMA", new String[]{schema, this.getName()}, this, this.getSchemaTextRange(astRoot)));
            doContinue = false;
        }
        if (doContinue && !this.isResolved()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "TABLE_UNRESOLVED_NAME", new String[]{this.getName()}, this, this.getNameTextRange(astRoot)));
        }
    }
}

