/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.javaee.core.EjbLocalRef;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.core.Listener;
import org.eclipse.jst.javaee.core.ResourceRef;
import org.eclipse.jst.javaee.core.SecurityRole;
import org.eclipse.jst.javaee.core.SecurityRoleRef;
import org.eclipse.jst.javaee.ejb.SecurityIdentityType;
import org.eclipse.jst.javaee.web.Filter;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.jee.model.internal.WebAnnotationFactory;
import org.eclipse.jst.jee.model.internal.common.AbstractAnnotationModelProvider;
import org.eclipse.jst.jee.model.internal.common.ManyToOneRelation;
import org.eclipse.jst.jee.model.internal.common.MyModelProviderEvent;
import org.eclipse.jst.jee.model.internal.common.Result;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAnnotationReader
extends AbstractAnnotationModelProvider<WebApp> {
    private static final String JAVA_EXTENSION = "java";
    private ManyToOneRelation<JavaEEObject, IFile> modelToResource;
    private ManyToOneRelation<JavaEEObject, IFile> modelToInterfaceResource;
    private WebAnnotationFactory annotationFactory;
    private WebApp ddApp;

    public WebAnnotationReader(IFacetedProject facetedProject, WebApp ddApp) {
        super(facetedProject);
        if (ddApp == null) {
            throw new IllegalArgumentException("The deployment descriptor model can not be null!");
        }
        this.ddApp = ddApp;
    }

    protected void preLoad() {
        this.modelObject = WebFactory.eINSTANCE.createWebApp();
        this.annotationFactory = WebAnnotationFactory.createFactory();
    }

    protected void loadModel() throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)this.facetedProject.getProject());
        HashSet<IFile> javaFiles = new HashSet<IFile>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getAllPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            this.visitJavaFiles(javaFiles, root);
            ++n2;
        }
        this.annotationFactory = WebAnnotationFactory.createFactory();
        this.modelToInterfaceResource = new ManyToOneRelation();
        this.modelToResource = new ManyToOneRelation();
        for (IFile file : javaFiles) {
            Result result = this.analyzeFile(file);
            if (result == null) continue;
            this.processResult(file, result);
        }
    }

    private Result analyzeFile(IFile file) throws JavaModelException {
        Assert.isTrue((boolean)JAVA_EXTENSION.equals(file.getFileExtension()), (String)"A file with extension different from \"java\" is analyzed for beans");
        ICompilationUnit compilationUnit = JavaCore.createCompilationUnitFrom((IFile)file);
        if (compilationUnit == null) {
            return null;
        }
        IType rootType = compilationUnit.findPrimaryType();
        if (rootType == null || !rootType.isClass()) {
            return null;
        }
        for (Servlet servlet : this.ddApp.getServlets()) {
            if (!rootType.getFullyQualifiedName().equals(servlet.getServletClass())) continue;
            return this.annotationFactory.createServlet(rootType, servlet.getServletName());
        }
        for (Listener listener : this.ddApp.getListeners()) {
            if (!rootType.getFullyQualifiedName().equals(listener.getListenerClass())) continue;
            return this.annotationFactory.createListener(rootType);
        }
        for (Filter filter : this.ddApp.getFilters()) {
            if (!rootType.getFullyQualifiedName().equals(filter.getFilterClass())) continue;
            return this.annotationFactory.createFilter(rootType, filter.getFilterName());
        }
        return null;
    }

    private void processResult(IFile file, Result result) throws JavaModelException {
        JavaEEObject mainObject = result.getMainObject();
        if (Servlet.class.isInstance(mainObject)) {
            this.servletFound(file, (Servlet)result.getMainObject(), result.getDependedTypes());
        }
        for (JavaEEObject additional : result.getAdditional()) {
            if (EjbLocalRef.class.isInstance(additional)) {
                this.ejbLocalRefFound(file, (EjbLocalRef)additional, result.getDependedTypes());
                continue;
            }
            if (ResourceRef.class.isInstance(additional)) {
                this.resourceRefFound(file, (ResourceRef)additional, result.getDependedTypes());
                continue;
            }
            if (SecurityRole.class.isInstance(additional)) {
                this.securityRoleFound(result.getMainObject(), (SecurityRole)additional);
                continue;
            }
            if (!SecurityIdentityType.class.isInstance(additional)) continue;
            this.securityIdentityTypeFound(file, (SecurityIdentityType)additional);
        }
    }

    private void servletFound(IFile file, Servlet servlet, Collection<IType> dependedTypes) throws JavaModelException {
        ((WebApp)this.modelObject).getServlets().add(servlet);
        this.connectObjectWithFile(file, (JavaEEObject)servlet, dependedTypes);
    }

    private void securityIdentityTypeFound(IFile file, SecurityIdentityType additional) {
    }

    private void resourceRefFound(IFile file, ResourceRef resourceRef, Collection<IType> dependedTypes) throws JavaModelException {
        ((WebApp)this.modelObject).getResourceRefs().add(resourceRef);
        this.connectObjectWithFile(file, (JavaEEObject)resourceRef, dependedTypes);
    }

    private void ejbLocalRefFound(IFile file, EjbLocalRef localRef, Collection<IType> dependedTypes) throws JavaModelException {
        ((WebApp)this.modelObject).getEjbLocalRefs().add(localRef);
        this.connectObjectWithFile(file, (JavaEEObject)localRef, dependedTypes);
    }

    private void connectObjectWithFile(IFile file, JavaEEObject localRef, Collection<IType> dependedTypes) throws JavaModelException {
        this.modelToResource.connect((Object)localRef, (Object)file);
        new HashSet(dependedTypes.size());
        for (IType type : dependedTypes) {
            IResource resource;
            if (type.isBinary() || !type.isInterface() || (resource = type.getCompilationUnit().getCorrespondingResource()) == null || !resource.exists()) continue;
            this.modelToInterfaceResource.connect((Object)localRef, (Object)((IFile)resource));
        }
    }

    private void visitJavaFiles(final Collection<IFile> javaFiles, final IPackageFragmentRoot root) throws CoreException {
        if (root.getKind() != 1) {
            return;
        }
        root.getCorrespondingResource().accept(new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                if (proxy.getType() == 1) {
                    if (proxy.getName().endsWith(".java")) {
                        IFile file = (IFile)proxy.requestResource();
                        if (root.getJavaProject().isOnClasspath((IResource)file)) {
                            javaFiles.add(file);
                        }
                    }
                    return false;
                }
                return true;
            }
        }, 0);
    }

    protected boolean isProjectRelative(IProject project) {
        if (project == null) {
            return false;
        }
        return project.equals((Object)this.facetedProject.getProject());
    }

    public void dispose() {
        MyModelProviderEvent modelEvent = this.createModelProviderEvent();
        modelEvent.addResource((Object)this.facetedProject.getProject());
        modelEvent.setEventCode(modelEvent.getEventCode() | 0x10);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.modelToResource = null;
        this.modelObject = null;
        this.notifyListeners((IModelProviderEvent)modelEvent);
        this.clearListeners();
    }

    protected synchronized void processAddedFile(IModelProviderEvent modelEvent, IFile file) throws CoreException {
        Result result = this.analyzeFile(file);
        if (result == null) {
            return;
        }
        this.processResult(file, result);
        modelEvent.addResource((Object)file);
    }

    protected synchronized void processChangedFile(IModelProviderEvent modelEvent, IFile file) throws CoreException {
        if (this.modelToResource.containsTarget((Object)file)) {
            this.processChangedModelFile(modelEvent, file);
        } else {
            this.processAddedFile(modelEvent, file);
        }
    }

    private void processChangedModelFile(IModelProviderEvent modelEvent, IFile file) throws CoreException {
        this.processRemovedFile(modelEvent, file);
        this.processAddedFile(modelEvent, file);
    }

    protected synchronized void processRemovedFile(IModelProviderEvent modelEvent, IFile file) throws CoreException {
        if (this.modelToResource.containsTarget((Object)file)) {
            this.processRemovedModelResource(modelEvent, file);
        } else if (this.modelToInterfaceResource.containsTarget((Object)file)) {
            this.processRemoveInterface(modelEvent, file);
        }
    }

    private void processRemoveInterface(IModelProviderEvent event, IFile file) {
    }

    private void processRemovedModelResource(IModelProviderEvent event, IFile file) {
        Collection modelObjects = this.modelToResource.getSources((Object)file);
        for (JavaEEObject o : modelObjects) {
            if (Servlet.class.isInstance(o)) {
                this.disconnectFromRoles(o);
            }
            EcoreUtil.remove((EObject)((EObject)o));
        }
        this.modelToResource.disconnect((Object)file);
        event.setEventCode(event.getEventCode() | 4);
        event.addResource((Object)file);
    }

    public void modify(Runnable runnable, IPath modelPath) {
    }

    public IStatus validateEdit(IPath modelPath, Object context) {
        return null;
    }

    protected Collection<SecurityRoleRef> getSecurityRoleRefs(JavaEEObject target) {
        if (Servlet.class.isInstance(target)) {
            return ((Servlet)target).getSecurityRoleRefs();
        }
        return null;
    }

    protected Collection<SecurityRole> getSecurityRoles() {
        return ((WebApp)this.modelObject).getSecurityRoles();
    }
}

