/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.synchronization;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowElement;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowLink;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowNode;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPackage;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPage;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.synchronization.FC2PFTransformer;

public class PF2FCSynchronizer
extends AdapterImpl {
    FC2PFTransformer tranformer;
    private final boolean DEBUG = false;
    private static final Logger logger = EditorPlugin.getLogger(PF2FCSynchronizer.class);

    public PF2FCSynchronizer(FC2PFTransformer tranformer) {
        this.tranformer = tranformer;
    }

    public Notifier getTarget() {
        return null;
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return type == PF2FCSynchronizer.class;
    }

    public void notifyChanged(Notification notification) {
        if (!this.isProcessorFor(notification)) {
            return;
        }
        this.tranformer.setInEvent(true);
        try {
            if (!(notification.getNotifier() instanceof PageflowElement)) {
                return;
            }
            try {
                this.processChange(notification);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        finally {
            if (notification.getEventType() != 8) {
                this.tranformer.refreshPFAdapter(this.tranformer.getPageflow());
                this.tranformer.refreshFCAdapter((EObject)this.tranformer.getFacesConfig());
            }
            this.tranformer.setInEvent(false);
        }
    }

    private boolean isProcessorFor(Notification notification) {
        return this.tranformer.isListenToNotify();
    }

    private void processChange(Notification notification) {
        PageflowElement element = (PageflowElement)notification.getNotifier();
        int type = notification.getEventType();
        switch (type) {
            case 3: {
                int featureId = notification.getFeatureID(PageflowPackage.class);
                switch (featureId) {
                    case 9: {
                        this.addOutLink(notification, element);
                        break;
                    }
                    case 10: {
                        this.addInLink(notification, element);
                        break;
                    }
                }
                if (this.tranformer.isNeedBatchOperations()) break;
                this.updateAndNotify(notification);
                break;
            }
            case 1: {
                if (notification.getNewValue() == null) break;
                this.processSet(notification, element);
                this.updateAndNotify(notification);
                break;
            }
            case 4: 
            case 6: {
                int featureId = notification.getFeatureID(PageflowPackage.class);
                switch (featureId) {
                    case 5: {
                        break;
                    }
                    case 9: 
                    case 10: {
                        this.removeLink(notification, element);
                    }
                }
                if (this.tranformer.isNeedBatchOperations()) break;
                this.updateAndNotify(notification);
            }
        }
    }

    private void processSet(Notification notification, PageflowElement element) {
        if (notification.getNewValue() != null) {
            int value = notification.getFeatureID(PageflowPackage.class);
            if (element instanceof PageflowPage) {
                this.setProperties(notification, element, value);
            } else if (element instanceof PageflowLink) {
                this.setProperties(notification, element, value);
            }
        }
    }

    private void setProperties(Notification notification, PageflowElement element, int value) {
        if (notification.getFeature() == PageflowPackage.eINSTANCE.getPFLink_Source()) {
            if (notification.getNewValue() instanceof String) {
                this.tranformer.changePFLinkStart((PageflowLink)element, (String)notification.getNewValue());
            }
        } else if (notification.getFeature() == PageflowPackage.eINSTANCE.getPFLink_Target()) {
            if (notification.getNewValue() instanceof String) {
                this.tranformer.changePFLinkEnd((PageflowLink)element, (String)notification.getNewValue());
            }
        } else {
            element.getFCElements().set((EStructuralFeature)notification.getFeature(), notification.getNewValue());
        }
    }

    private void addInLink(Notification notification, PageflowElement element) {
        PageflowNode source;
        Object value = notification.getNewValue();
        PageflowLink link = (PageflowLink)value;
        if (element instanceof PageflowPage && (source = link.getSource()) instanceof PageflowPage) {
            this.tranformer.addLink((PageflowPage)source, (PageflowPage)element, link);
        }
    }

    private void addOutLink(Notification notification, PageflowElement element) {
        PageflowNode target_;
        Object value = notification.getNewValue();
        PageflowLink link = (PageflowLink)value;
        if (element instanceof PageflowPage && (target_ = link.getTarget()) instanceof PageflowPage) {
            this.tranformer.addLink((PageflowPage)element, (PageflowPage)target_, link);
        }
    }

    private void removeLink(Notification notification, PageflowElement element) {
        NavigationCaseType caseFC;
        Object value = notification.getOldValue();
        PageflowLink link = (PageflowLink)value;
        if (!link.getFCElements().isEmpty() && (caseFC = (NavigationCaseType)link.getFCElements().getData().get(0)) != null) {
            this.tranformer.removeCase(caseFC);
        }
        link.update();
    }

    private void updateAndNotify(Notification notification) {
        this.tranformer.getPageflow().notifyModelChanged((Notification)new ENotificationImpl((InternalEObject)notification.getNotifier(), 1, 0, null, null));
    }
}

