/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.eclipse;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ResourceBundle;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.eclipse.wst.wsdl.validation.internal.IValidationMessage;
import org.eclipse.wst.wsdl.validation.internal.IValidationReport;
import org.eclipse.wst.wsdl.validation.internal.ValidationInfoImpl;
import org.eclipse.wst.wsdl.validation.internal.ValidationMessageImpl;
import org.eclipse.wst.wsdl.validation.internal.eclipse.InlineSchemaModelGrammarPoolImpl;
import org.eclipse.wst.wsdl.validation.internal.eclipse.ValidatorWrapper;
import org.eclipse.wst.wsdl.validation.internal.util.MessageGenerator;
import org.eclipse.wst.wsdl.validation.tests.internal.WSDLValidatorTestsPlugin;
import org.eclipse.wst.xml.core.internal.validation.core.NestedValidatorContext;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationInfo;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;

public class ValidatorTest
extends TestCase {
    ValidatorWrapper validator = new ValidatorWrapper();
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.wsdl.validation.internal.eclipse.ValidatorTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testValidate() {
        try {
            NestedValidatorContext context2;
            ValidationReport report2;
            ValidationReport report1;
            block19: {
                InputStream is;
                String uri;
                String PLUGIN_ABSOLUTE_PATH;
                NestedValidatorContext context;
                block18: {
                    context = new NestedValidatorContext();
                    this.validator.setupValidation(context);
                    PLUGIN_ABSOLUTE_PATH = WSDLValidatorTestsPlugin.getInstallURL();
                    uri = "file:///" + PLUGIN_ABSOLUTE_PATH + "testresources/samples/Paths/Dash-InPath/DashInPathValid.wsdl";
                    report1 = this.validator.validate(uri, null, context);
                    this.validator.teardownValidation(context);
                    this.validator.setupValidation(context);
                    report2 = null;
                    is = null;
                    try {
                        try {
                            is = new URL(uri).openStream();
                            report2 = this.validator.validate(uri, is, context);
                        }
                        catch (Exception e) {
                            ValidatorTest.fail((String)("A problem occurred while validating a valid file with an inputstream: " + e));
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_13 = null;
                        if (is == null) throw throwable;
                        try {
                            is.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    {
                        Object var8_14 = null;
                        if (is == null) break block18;
                    }
                    try {}
                    catch (IOException iOException) {}
                    is.close();
                }
                this.validator.teardownValidation(context);
                ValidatorTest.assertTrue((String)"Validation using a URI did not product a valid validation result.", (boolean)report1.isValid());
                ValidatorTest.assertEquals((String)"Validation using URI and using inputstream of the same file produces different numbers of errors.", (int)report1.getValidationMessages().length, (int)report2.getValidationMessages().length);
                context2 = new NestedValidatorContext();
                this.validator.setupValidation(context2);
                uri = "file:///" + PLUGIN_ABSOLUTE_PATH + "testresources/samples/Paths/Dash-InPath/DashInPathInvalid.wsdl";
                report1 = this.validator.validate(uri, null, context2);
                this.validator.teardownValidation(context2);
                this.validator.setupValidation(context2);
                report2 = null;
                is = null;
                try {
                    try {
                        is = new URL(uri).openStream();
                        report2 = this.validator.validate(uri, is, context2);
                    }
                    catch (Exception e) {
                        ValidatorTest.fail((String)("A problem occurred while validating an invalid file with an inputstream: " + e));
                    }
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    Object var9_12 = null;
                    if (is == null) break block19;
                }
                try {}
                catch (IOException iOException) {}
                is.close();
            }
            this.validator.teardownValidation(context2);
            ValidatorTest.assertFalse((String)"Validation using a URI did not product an invalid validation result.", (boolean)report1.isValid());
            ValidatorTest.assertEquals((String)"Validation using URI and using inputstream of the same file produces different numbers of errors.", (int)report1.getValidationMessages().length, (int)report2.getValidationMessages().length);
            return;
        }
        catch (Exception e) {
            ValidatorTest.fail((String)("Unable to locate plug-in location: " + e));
        }
    }

    public void testSetupValidation() {
        this.validator.getXMLGrammarPoolsMap().clear();
        this.validator.getXSDGrammarPoolsMap().clear();
        NestedValidatorContext context = new NestedValidatorContext();
        ValidatorTest.assertNull((String)"An XML grammar pool already exists for the context.", (Object)this.validator.getXMLGrammarPoolForContext(context));
        ValidatorTest.assertNull((String)"An XSD grammar pool already exists for the context.", (Object)this.validator.getXSDGrammarPoolForContext(context));
        this.validator.setupValidation(context);
        ValidatorTest.assertNotNull((String)"An XML grammar pool does not exist after the setupValidation method is run.", (Object)this.validator.getXMLGrammarPoolForContext(context));
        ValidatorTest.assertNotNull((String)"An XSD grammar pool does not exist after the setupValidation method is run.", (Object)this.validator.getXSDGrammarPoolForContext(context));
        this.validator.getXMLGrammarPoolsMap().clear();
        this.validator.getXSDGrammarPoolsMap().clear();
    }

    public void testTeardownValidation() {
        this.validator.getXMLGrammarPoolsMap().clear();
        this.validator.getXSDGrammarPoolsMap().clear();
        NestedValidatorContext context = new NestedValidatorContext();
        this.validator.getXMLGrammarPoolsMap().put(context, new XMLGrammarPoolImpl());
        this.validator.getXSDGrammarPoolsMap().put(context, new InlineSchemaModelGrammarPoolImpl());
        this.validator.teardownValidation(context);
        ValidatorTest.assertNull((String)"An XML grammar pool exists after the teardownValidation method is run.", (Object)this.validator.getXMLGrammarPoolForContext(context));
        ValidatorTest.assertNull((String)"An XSD grammar pool exists after the teardownValidation method is run.", (Object)this.validator.getXSDGrammarPoolForContext(context));
        this.validator.getXMLGrammarPoolsMap().clear();
        this.validator.getXSDGrammarPoolsMap().clear();
    }

    public void testConvertMessage() {
        ValidationMessageImpl message = new ValidationMessageImpl("message", 1, 2, 0, "file:/someuri");
        ValidationInfo report = new ValidationInfo("file:/someuri");
        this.validator.convertMessage((IValidationMessage)message, report);
        ValidatorTest.assertEquals((String)"The report does not have 1 message.", (int)1, (int)report.getValidationMessages().length);
        ValidatorTest.assertEquals((String)"The message string is incorrect.", (String)"message", (String)report.getValidationMessages()[0].getMessage());
        ValidatorTest.assertEquals((String)"The message line number is incorrect.", (int)1, (int)report.getValidationMessages()[0].getLineNumber());
        ValidatorTest.assertEquals((String)"The message column number is incorrect.", (int)2, (int)report.getValidationMessages()[0].getColumnNumber());
        ValidatorTest.assertEquals((String)"The message severity is incorrect.", (int)ValidationMessage.SEV_NORMAL, (int)report.getValidationMessages()[0].getSeverity());
        ValidatorTest.assertEquals((String)"The message URI is incorrect.", (String)"file:/someuri", (String)report.getValidationMessages()[0].getUri());
        ValidatorTest.assertEquals((String)"The message has an incorrectly registred nested message.", (int)0, (int)report.getNestedMessages().size());
        ValidationMessageImpl message2 = new ValidationMessageImpl("message", 1, 2, 0, "file:/someuri2");
        ValidationInfo report2 = new ValidationInfo("file:/someuri");
        this.validator.convertMessage((IValidationMessage)message2, report2);
        ValidatorTest.assertEquals((String)"The report with the nested message does not have 1 message.", (int)1, (int)report2.getValidationMessages().length);
        ValidatorTest.assertEquals((String)"The container message URI is incorrect.", (String)"file:/someuri2", (String)report2.getValidationMessages()[0].getUri());
        ValidatorTest.assertEquals((String)"The container message does not have 1 nested message.", (int)1, (int)report2.getValidationMessages()[0].getNestedMessages().size());
        ValidatorTest.assertEquals((String)"The nested message URI is incorrect.", (String)"file:/someuri2", (String)((ValidationMessage)report2.getValidationMessages()[0].getNestedMessages().get(0)).getUri());
        ValidatorTest.assertEquals((String)"The nested message string is incorrect.", (String)"message", (String)((ValidationMessage)report2.getValidationMessages()[0].getNestedMessages().get(0)).getMessage());
        ValidatorTest.assertEquals((String)"The nested message line number is incorrect.", (int)1, (int)((ValidationMessage)report2.getValidationMessages()[0].getNestedMessages().get(0)).getLineNumber());
        ValidatorTest.assertEquals((String)"The nested message column number is incorrect.", (int)2, (int)((ValidationMessage)report2.getValidationMessages()[0].getNestedMessages().get(0)).getColumnNumber());
        ValidatorTest.assertEquals((String)"The nested message severity is incorrect.", (int)ValidationMessage.SEV_NORMAL, (int)((ValidationMessage)report2.getValidationMessages()[0].getNestedMessages().get(0)).getSeverity());
        ValidatorTest.assertEquals((String)"The message does not have a nested message.", (int)1, (int)report2.getNestedMessages().size());
    }

    public void testConvertReportToXMLReport() {
        ValidationInfoImpl wsdlreport = new ValidationInfoImpl("file:/someuri", new MessageGenerator(ResourceBundle.getBundle("org.eclipse.wst.wsdl.validation.internal.eclipse.validatewsdl")));
        wsdlreport.addError("message", 1, 2, "file:/someuri");
        ValidationReport report = this.validator.convertReportToXMLReport((IValidationReport)wsdlreport);
        ValidatorTest.assertEquals((String)"The report does not have 1 message.", (int)1, (int)report.getValidationMessages().length);
        ValidatorTest.assertEquals((String)"The message string is incorrect.", (String)"message", (String)report.getValidationMessages()[0].getMessage());
        ValidatorTest.assertEquals((String)"The message line number is incorrect.", (int)1, (int)report.getValidationMessages()[0].getLineNumber());
        ValidatorTest.assertEquals((String)"The message column number is incorrect.", (int)2, (int)report.getValidationMessages()[0].getColumnNumber());
        ValidatorTest.assertEquals((String)"The message severity is incorrect.", (int)ValidationMessage.SEV_NORMAL, (int)report.getValidationMessages()[0].getSeverity());
        ValidatorTest.assertEquals((String)"The message URI is incorrect.", (String)"file:/someuri", (String)report.getValidationMessages()[0].getUri());
        ValidatorTest.assertEquals((String)"The message has an incorrectly registred nested message.", (int)0, (int)report.getNestedMessages().size());
        ValidationInfoImpl wsdlreport2 = new ValidationInfoImpl("file:/someuri", new MessageGenerator(ResourceBundle.getBundle("org.eclipse.wst.wsdl.validation.internal.eclipse.validatewsdl")));
        wsdlreport2.addError("message", 1, 2, "file:/someuri2");
        ValidationReport report2 = this.validator.convertReportToXMLReport((IValidationReport)wsdlreport2);
        ValidatorTest.assertEquals((String)"The report does not have 1 message.", (int)1, (int)report2.getValidationMessages().length);
        ValidatorTest.assertEquals((String)"The message URI is incorrect.", (String)"file:/someuri2", (String)report2.getValidationMessages()[0].getUri());
        ValidatorTest.assertEquals((String)"The message does not have 1 nested message.", (int)1, (int)report2.getValidationMessages()[0].getNestedMessages().size());
        ValidatorTest.assertEquals((String)"The message URI is incorrect.", (String)"file:/someuri2", (String)((ValidationMessage)report2.getValidationMessages()[0].getNestedMessages().get(0)).getUri());
        ValidatorTest.assertEquals((String)"The message string is incorrect.", (String)"message", (String)((ValidationMessage)report2.getValidationMessages()[0].getNestedMessages().get(0)).getMessage());
        ValidatorTest.assertEquals((String)"The message line number is incorrect.", (int)1, (int)((ValidationMessage)report2.getValidationMessages()[0].getNestedMessages().get(0)).getLineNumber());
        ValidatorTest.assertEquals((String)"The message column number is incorrect.", (int)2, (int)((ValidationMessage)report2.getValidationMessages()[0].getNestedMessages().get(0)).getColumnNumber());
        ValidatorTest.assertEquals((String)"The message severity is incorrect.", (int)ValidationMessage.SEV_NORMAL, (int)((ValidationMessage)report2.getValidationMessages()[0].getNestedMessages().get(0)).getSeverity());
        ValidatorTest.assertEquals((String)"The message does not have a nested message.", (int)1, (int)report2.getNestedMessages().size());
    }
}

