/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.ui.tests;

import java.util.Iterator;
import junit.framework.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class UITestHelper {
    protected static Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static PreferenceDialog getPreferenceDialog(String id) {
        PreferenceDialogWrapper dialog = null;
        PreferenceManager manager = WorkbenchPlugin.getDefault().getPreferenceManager();
        if (manager != null) {
            dialog = new PreferenceDialogWrapper(UITestHelper.getShell(), manager);
            dialog.create();
            for (IPreferenceNode node : manager.getElements(0)) {
                if (!node.getId().equals(id)) continue;
                dialog.showPage(node);
                break;
            }
        }
        return dialog;
    }

    public static PropertyDialog getPropertyDialog(String id, IAdaptable element) {
        Iterator pages;
        PropertyDialogWrapper dialog = null;
        PropertyPageManager manager = new PropertyPageManager();
        String title = "";
        String name = "";
        PropertyPageContributorManager.getManager().contribute(manager, (Object)element);
        IWorkbenchAdapter adapter = (IWorkbenchAdapter)element.getAdapter(IWorkbenchAdapter.class);
        if (adapter != null) {
            name = adapter.getLabel((Object)element);
        }
        if (!(pages = manager.getElements(0).iterator()).hasNext()) {
            return null;
        }
        title = "Title: " + name;
        dialog = new PropertyDialogWrapper(UITestHelper.getShell(), (PreferenceManager)manager, (ISelection)new StructuredSelection((Object)element));
        dialog.create();
        dialog.getShell().setText(title);
        for (IPreferenceNode node : manager.getElements(0)) {
            if (!node.getId().equals(id)) continue;
            dialog.showPage(node);
            break;
        }
        return dialog;
    }

    public static void assertDialog(Dialog dialog) {
        Assert.assertNotNull((Object)dialog);
        dialog.setBlockOnOpen(false);
        dialog.open();
        Shell shell = dialog.getShell();
        UITestHelper.verifyCompositeText((Composite)shell);
        dialog.close();
    }

    private static void verifyCompositeText(Composite composite) {
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            try {
                UITestHelper.verifyButtonText((Button)children[i]);
            }
            catch (ClassCastException classCastException) {
                try {
                    UITestHelper.verifyLabelText((Label)children[i]);
                }
                catch (ClassCastException classCastException2) {
                    try {
                        UITestHelper.verifyCompositeText((Composite)children[i]);
                    }
                    catch (ClassCastException classCastException3) {}
                }
            }
            ++i;
        }
    }

    private static void verifyButtonText(Button button) {
        String widget = button.toString();
        Point size = button.getSize();
        Point preferred = button.computeSize(-1, -1);
        if (preferred.y * size.y > 0) {
            preferred.y /= UITestHelper.countLines(button.getText());
            if (size.y / preferred.y > 1) {
                preferred.x /= size.y / preferred.y;
            }
        }
        String message = new StringBuffer("Warning: ").append(widget).append("\n\tActual Width -> ").append(size.x).append("\n\tRecommended Width -> ").append(preferred.x).toString();
        if (preferred.x > size.x) {
            button.getShell().dispose();
            Assert.assertTrue((String)message.toString(), (boolean)false);
        }
    }

    private static void verifyLabelText(Label label) {
        String widget = label.toString();
        Point size = label.getSize();
        Point preferred = label.computeSize(-1, -1);
        if (preferred.y * size.y > 0) {
            preferred.y /= UITestHelper.countLines(label.getText());
            if (size.y / preferred.y > 1) {
                preferred.x /= size.y / preferred.y;
            }
        }
        String message = new StringBuffer("Warning: ").append(widget).append("\n\tActual Width -> ").append(size.x).append("\n\tRecommended Width -> ").append(preferred.x).toString();
        if (preferred.x > size.x) {
            label.getShell().dispose();
            Assert.assertTrue((String)message.toString(), (boolean)false);
        }
    }

    private static int countLines(String text) {
        int newLines = 1;
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == '\n') {
                ++newLines;
            }
            ++i;
        }
        return newLines;
    }

    private static class PreferenceDialogWrapper
    extends PreferenceDialog {
        public PreferenceDialogWrapper(Shell parentShell, PreferenceManager manager) {
            super(parentShell, manager);
        }

        protected boolean showPage(IPreferenceNode node) {
            return super.showPage(node);
        }
    }

    private static class PropertyDialogWrapper
    extends PropertyDialog {
        public PropertyDialogWrapper(Shell parentShell, PreferenceManager manager, ISelection selection) {
            super(parentShell, manager, selection);
        }

        protected boolean showPage(IPreferenceNode node) {
            return super.showPage(node);
        }
    }
}

