/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMDescriptor;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMFunction;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMNode;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMNumber;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMProperty;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMUnit;
import org.eclipse.wst.css.core.internal.metamodel.util.CSSMetaModelUtil;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSPrimitiveValue;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclItem;
import org.eclipse.wst.css.core.internal.util.CSSUtil;
import org.eclipse.wst.css.core.internal.util.RegionIterator;
import org.eclipse.wst.css.ui.internal.contentassist.CSSCACandidate;
import org.eclipse.wst.css.ui.internal.contentassist.CSSContentAssistContext;
import org.eclipse.wst.css.ui.internal.contentassist.CSSProposalGenerator;
import org.eclipse.wst.css.ui.internal.image.CSSImageType;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.w3c.dom.css.CSSFontFaceRule;

class CSSProposalGeneratorForDeclarationValue
extends CSSProposalGenerator {
    private static final String IMPORTANT = "!important";
    private boolean fUseUpperCase = CSSCorePlugin.getDefault().getPluginPreferences().getInt("propValueCase") == 2;
    private boolean fAppendSemiColon;

    CSSProposalGeneratorForDeclarationValue(CSSContentAssistContext context) {
        super(context);
    }

    private void addFunction(List candidates, CSSMMFunction prop) {
        CSSProposalGenerator.StringAndOffset sao;
        String text = prop.toString();
        if (!this.isMatch(text)) {
            return;
        }
        int cursorPos = 0;
        StringBuffer buf = new StringBuffer();
        if (prop.getName().equals("uri")) {
            sao = this.generateURI();
            buf.append(sao.fString);
            cursorPos = sao.fOffset;
        } else {
            buf.append(prop.toString());
            cursorPos = buf.length();
            sao = this.generateParenthesis();
            buf.append(sao.fString);
            cursorPos += sao.fOffset;
        }
        text = buf.toString();
        text = this.fUseUpperCase ? text.toUpperCase() : text.toLowerCase();
        CSSCACandidate item = new CSSCACandidate();
        item.setReplacementString(text);
        item.setCursorPosition(cursorPos);
        item.setDisplayString(text);
        item.setImageType(CSSImageType.VALUE_FUNCTION);
        this.appendSemiColon(item);
        candidates.add(item);
    }

    private void addNumber(List candidates, CSSMMNumber prop) {
        String fullText = this.fContext.getTextToReplace();
        int unitIndex = -1;
        int i = 0;
        while (i < fullText.length()) {
            if (!Character.isDigit(fullText.charAt(i))) break;
            unitIndex = i + 1;
            ++i;
        }
        String unitSubText = "";
        String numSubText = "";
        if (unitIndex >= 0) {
            numSubText = fullText.substring(0, unitIndex);
            if (unitIndex < fullText.length()) {
                unitSubText = fullText.substring(unitIndex);
            }
        } else {
            unitSubText = fullText;
        }
        Iterator i2 = prop.getDescendants();
        while (i2.hasNext()) {
            CSSMMUnit unit = (CSSMMUnit)i2.next();
            String unitString = unit.getUnitString();
            if (unitSubText.length() > 0 && unitString.indexOf(unitSubText) != 0 || numSubText.length() > 0 && unitString.equals("#")) continue;
            String text = String.valueOf(numSubText) + unitString;
            text = this.fUseUpperCase ? text.toUpperCase() : text.toLowerCase();
            CSSCACandidate item = new CSSCACandidate();
            item.setReplacementString(text);
            if (numSubText.length() > 0 || text.equals("#")) {
                item.setCursorPosition(text.length());
            } else {
                item.setCursorPosition(0);
            }
            item.setDisplayString(text);
            item.setImageType(CSSImageType.VALUE_NUMBER);
            this.appendSemiColon(item);
            candidates.add(item);
        }
    }

    private void checkSemiColon() {
        this.fAppendSemiColon = false;
        ITextRegion targetRegion = this.fContext.getTargetRegion();
        if (targetRegion != null && targetRegion.getType() != "DECLARATION_DELIMITER") {
            IStructuredDocumentRegion nextStructuredDocumentRegion;
            RegionIterator iterator = this.fContext.getRegionIterator();
            IStructuredDocumentRegion container = iterator.getStructuredDocumentRegion();
            while (iterator.hasNext()) {
                ITextRegion region = iterator.next();
                if (iterator.getStructuredDocumentRegion() != container) break;
                if (region.getType() != "DECLARATION_SEPARATOR") continue;
                this.fAppendSemiColon = true;
                break;
            }
            if (!this.fAppendSemiColon && CSSUtil.getStructuredDocumentRegionType((IStructuredDocumentRegion)(nextStructuredDocumentRegion = CSSUtil.findNextSignificantNode((IStructuredDocumentRegion)container))) != "DECLARATION_DELIMITER") {
                this.fAppendSemiColon = true;
            }
        }
    }

    private void appendSemiColon(CSSCACandidate item) {
        if (this.fAppendSemiColon) {
            String replacementString = item.getReplacementString();
            item.setReplacementString(String.valueOf(replacementString) + ";");
            int cursorPosition = item.getCursorPosition();
            if (replacementString.length() <= cursorPosition) {
                item.setCursorPosition(++cursorPosition);
            }
        }
    }

    private void addSemiColon(List candidates) {
        ICSSNode targetNode = this.fContext.getTargetNode();
        if (targetNode instanceof ICSSStyleDeclItem) {
            ICSSNode firstChild = targetNode.getFirstChild();
            if (firstChild == null) {
                return;
            }
            if (firstChild instanceof IndexedRegion) {
                int startOffset = ((IndexedRegion)firstChild).getStartOffset();
                if (this.fContext.getCursorPos() <= startOffset) {
                    return;
                }
            }
        }
        boolean bAddCloser = false;
        ITextRegion targetRegion = this.fContext.getTargetRegion();
        if (targetRegion != null && targetRegion.getType() != "DECLARATION_DELIMITER") {
            IStructuredDocumentRegion nextStructuredDocumentRegion;
            RegionIterator iterator = this.fContext.getRegionIterator();
            IStructuredDocumentRegion container = iterator.getStructuredDocumentRegion();
            while (iterator.hasNext()) {
                ITextRegion region = iterator.next();
                if (iterator.getStructuredDocumentRegion() != container) break;
                if (region.getType() != "DECLARATION_SEPARATOR") continue;
                bAddCloser = true;
                break;
            }
            if (!bAddCloser && CSSUtil.getStructuredDocumentRegionType((IStructuredDocumentRegion)(nextStructuredDocumentRegion = CSSUtil.findNextSignificantNode((IStructuredDocumentRegion)container))) != "DECLARATION_DELIMITER") {
                bAddCloser = true;
            }
        }
        if (bAddCloser) {
            CSSCACandidate item = new CSSCACandidate();
            String text = String.valueOf(this.fContext.getTextToReplace()) + ";";
            item.setReplacementString(text);
            item.setCursorPosition(text.length());
            item.setDisplayString(";");
            item.setImageType(null);
            candidates.add(item);
        }
    }

    private void addString(List candidates, String text) {
        if (!this.isMatch(text)) {
            return;
        }
        text = this.fUseUpperCase ? text.toUpperCase() : text.toLowerCase();
        CSSCACandidate item = new CSSCACandidate();
        item.setReplacementString(text);
        item.setCursorPosition(text.length());
        item.setDisplayString(text);
        item.setImageType(CSSImageType.VALUE_STRING);
        this.appendSemiColon(item);
        candidates.add(item);
    }

    private void addImportant(List candidates) {
        int startOffset;
        ICSSNode lastChild;
        ICSSNode targetNode = this.fContext.getTargetNode();
        while (targetNode instanceof ICSSPrimitiveValue) {
            targetNode = targetNode.getParentNode();
        }
        if (!(targetNode instanceof ICSSStyleDeclItem)) {
            return;
        }
        String priority = ((ICSSStyleDeclItem)targetNode).getPriority();
        if ((priority == null || priority.length() == 0) && (lastChild = targetNode.getLastChild()) instanceof IndexedRegion && (startOffset = ((IndexedRegion)lastChild).getStartOffset()) < this.fContext.getCursorPos() && this.isMatch(IMPORTANT)) {
            CSSCACandidate item = new CSSCACandidate();
            item.setReplacementString(IMPORTANT);
            item.setCursorPosition(IMPORTANT.length());
            item.setDisplayString(IMPORTANT);
            item.setImageType(CSSImageType.VALUE_STRING);
            this.appendSemiColon(item);
            candidates.add(item);
        }
    }

    protected Iterator getCandidates() {
        ArrayList candidates = new ArrayList();
        this.checkSemiColon();
        String name = this.getPropertyName();
        if (name != null) {
            CSSMetaModelUtil util = new CSSMetaModelUtil(this.fContext.getMetaModel());
            Iterator i = Collections.EMPTY_LIST.iterator();
            if (this.isFontFaceRule()) {
                CSSMMDescriptor desc = util.getDescriptor(name);
                if (desc != null) {
                    i = desc.getValues();
                }
            } else {
                CSSMMProperty prop = util.getProperty(name);
                if (prop != null) {
                    i = prop.getValues();
                }
            }
            while (i.hasNext()) {
                CSSMMNode val = (CSSMMNode)i.next();
                String valueType = val.getType();
                if (valueType == "CSSMM.Keyword") {
                    this.addString(candidates, val.toString());
                    continue;
                }
                if (valueType == "CSSMM.Number") {
                    this.addNumber(candidates, (CSSMMNumber)val);
                    continue;
                }
                if (valueType != "CSSMM.Function") continue;
                this.addFunction(candidates, (CSSMMFunction)val);
            }
        }
        this.addImportant(candidates);
        this.addSemiColon(candidates);
        return candidates.iterator();
    }

    private String getPropertyName() {
        ICSSNode targetNode = this.fContext.getTargetNode();
        while (targetNode instanceof ICSSPrimitiveValue) {
            targetNode = targetNode.getParentNode();
        }
        if (targetNode instanceof ICSSStyleDeclItem) {
            return ((ICSSStyleDeclItem)targetNode).getPropertyName();
        }
        return null;
    }

    private boolean isFontFaceRule() {
        ICSSNode targetNode = this.fContext.getTargetNode();
        while (targetNode instanceof ICSSPrimitiveValue) {
            targetNode = targetNode.getParentNode();
        }
        if (targetNode instanceof ICSSStyleDeclItem && (targetNode = targetNode.getParentNode()) != null) {
            targetNode = targetNode.getParentNode();
        }
        return targetNode instanceof CSSFontFaceRule;
    }
}

