/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.caching;

import java.util.ListIterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.eclipselink.core.internal.context.caching.Caching;
import org.eclipse.jpt.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.eclipselink.ui.internal.JptEclipseLinkUiPlugin;
import org.eclipse.jpt.eclipselink.ui.internal.caching.EntityCacheProperties;
import org.eclipse.jpt.eclipselink.ui.internal.caching.EntityCachingPropertyComposite;
import org.eclipse.jpt.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.ui.internal.widgets.AbstractPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityListComposite
extends AbstractPane<Caching> {
    public EntityListComposite(AbstractPane<Caching> parentComposite, Composite parent) {
        super(parentComposite, parent);
    }

    protected void initializeLayout(Composite container) {
        container = this.buildTitledPane(container, EclipseLinkUiMessages.CachingEntityListComposite_groupTitle);
        WritablePropertyValueModel<EntityCacheProperties> entityHolder = this.buildEntityHolder();
        new AddRemoveListPane((AbstractPane)this, container, this.buildEntitiesAdapter(), this.buildEntityCachingListHolder(), entityHolder, this.buildEntityLabelProvider(), null);
        EntityCachingPropertyComposite pane = new EntityCachingPropertyComposite(this, (PropertyValueModel<EntityCacheProperties>)entityHolder, container);
        this.installPaneEnabler(entityHolder, pane);
    }

    private AddRemovePane.Adapter buildEntitiesAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                EntityListComposite.this.addEntities(listSelectionModel);
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Caching caching = (Caching)EntityListComposite.this.subject();
                Object[] objectArray = listSelectionModel.selectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    EntityCacheProperties entityCaching = (EntityCacheProperties)((Object)item);
                    caching.removeEntity(entityCaching.getEntityName());
                    ++n2;
                }
            }
        };
    }

    private void addEntities(ObjectListSelectionModel listSelectionModel) {
        IType type = this.chooseEntity();
        if (type != null) {
            String entityName = this.getEntityName(type.getFullyQualifiedName());
            if (entityName == null) {
                entityName = type.getElementName();
            }
            if (!((Caching)this.subject()).entityExists(entityName)) {
                String entity = ((Caching)this.subject()).addEntity(entityName);
                listSelectionModel.setSelectedValue((Object)entity);
            }
        }
    }

    private String getEntityName(String fullyQualifiedTypeName) {
        TypeMapping mapping;
        PersistentType persistentType = ((Caching)this.subject()).persistenceUnit().getPersistentType(fullyQualifiedTypeName);
        if (persistentType != null && persistentType.getMappingKey() == "entity" && (mapping = persistentType.getMapping()) instanceof Entity) {
            return ((Entity)mapping).getName();
        }
        return null;
    }

    private IType chooseEntity() {
        SelectionDialog typeSelectionDialog;
        IPackageFragmentRoot root = this.packageFragmentRoot();
        if (root == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{root.getJavaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            typeSelectionDialog = JavaUI.createTypeDialog((Shell)this.shell(), (IRunnableContext)service, (IJavaSearchScope)scope, (int)2, (boolean)false, (String)"");
        }
        catch (JavaModelException e) {
            JptEclipseLinkUiPlugin.log(e);
            return null;
        }
        typeSelectionDialog.setTitle(EclipseLinkUiMessages.CachingEntityListComposite_dialogTitle);
        typeSelectionDialog.setMessage(EclipseLinkUiMessages.CachingEntityListComposite_dialogMessage);
        if (typeSelectionDialog.open() == 0) {
            return (IType)typeSelectionDialog.getResult()[0];
        }
        return null;
    }

    private IPackageFragmentRoot packageFragmentRoot() {
        IProject project = ((Caching)this.subject()).getJpaProject().getProject();
        IJavaProject root = JavaCore.create((IProject)project);
        try {
            return root.getAllPackageFragmentRoots()[0];
        }
        catch (JavaModelException e) {
            JptEclipseLinkUiPlugin.log(e);
            return null;
        }
    }

    private ILabelProvider buildEntityLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                EntityCacheProperties entityCaching = (EntityCacheProperties)((Object)element);
                return entityCaching.getEntityName();
            }
        };
    }

    private WritablePropertyValueModel<EntityCacheProperties> buildEntityHolder() {
        return new SimplePropertyValueModel();
    }

    private ListValueModel<EntityCacheProperties> buildEntityCachingListHolder() {
        return new TransformationListValueModelAdapter<String, EntityCacheProperties>(this.buildEntitiesListHolder()){

            protected EntityCacheProperties transformItem(String item) {
                return new EntityCacheProperties((Caching)EntityListComposite.this.subject(), item);
            }
        };
    }

    private ListValueModel<String> buildEntitiesListHolder() {
        return new ListAspectAdapter<Caching, String>(this.getSubjectHolder(), new String[]{"entitiesListProperty"}){

            protected ListIterator<String> listIterator_() {
                return ((Caching)this.subject).entities();
            }

            protected int size_() {
                return ((Caching)this.subject).entitiesSize();
            }
        };
    }

    private void installPaneEnabler(WritablePropertyValueModel<EntityCacheProperties> entityHolder, EntityCachingPropertyComposite pane) {
        new PaneEnabler(this.buildPaneEnablerHolder(entityHolder), (AbstractPane)pane);
    }

    private PropertyValueModel<Boolean> buildPaneEnablerHolder(WritablePropertyValueModel<EntityCacheProperties> entityHolder) {
        return new TransformationPropertyValueModel<EntityCacheProperties, Boolean>(entityHolder){

            protected Boolean transform_(EntityCacheProperties value) {
                return value.entityNameIsValid();
            }
        };
    }
}

