/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.model.value.SimpleListValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationListValueModelAdapter;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationListValueModelAdapterTests
extends TestCase {
    private SimpleListValueModel<String> listHolder;
    private ListValueModel<String> transformedListHolder;
    ListChangeEvent event;
    String eventType;
    private static final String ADD = "add";
    private static final String REMOVE = "remove";
    private static final String REPLACE = "replace";
    private static final String MOVE = "move";
    private static final String CLEAR = "clear";
    private static final String CHANGE = "change";

    public TransformationListValueModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.listHolder = new SimpleListValueModel(this.buildList());
        this.transformedListHolder = this.buildTransformedListHolder((ListValueModel<String>)this.listHolder);
    }

    private List<String> buildList() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("foo");
        result.add("bar");
        result.add("baz");
        return result;
    }

    private List<String> buildTransformedList() {
        return this.transform(this.buildList());
    }

    private List<String> transform(List<String> list) {
        ArrayList<String> result = new ArrayList<String>(list.size());
        for (String string : list) {
            if (string == null) {
                result.add(null);
                continue;
            }
            result.add(string.toUpperCase());
        }
        return result;
    }

    private List<String> buildAddList() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("joo");
        result.add("jar");
        result.add("jaz");
        return result;
    }

    private List<String> buildTransformedAddList() {
        return this.transform(this.buildAddList());
    }

    ListValueModel<String> buildTransformedListHolder(ListValueModel<String> lvm) {
        return new TransformationListValueModelAdapter<String, String>(lvm){

            protected String transformItem(String s) {
                return s == null ? null : s.toUpperCase();
            }
        };
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testIterator() {
        this.transformedListHolder.addListChangeListener("list values", this.buildListener());
        TransformationListValueModelAdapterTests.assertEquals(this.buildTransformedList(), (Object)CollectionTools.list((Iterator)this.transformedListHolder.iterator()));
    }

    public void testStaleValues() {
        ListChangeListener listener = this.buildListener();
        this.transformedListHolder.addListChangeListener("list values", listener);
        TransformationListValueModelAdapterTests.assertEquals(this.buildTransformedList(), (Object)CollectionTools.list((Iterator)this.transformedListHolder.iterator()));
        this.transformedListHolder.removeListChangeListener("list values", listener);
        TransformationListValueModelAdapterTests.assertEquals((Object)Collections.EMPTY_LIST, (Object)CollectionTools.list((Iterator)this.transformedListHolder.iterator()));
    }

    public void testSize() {
        this.transformedListHolder.addListChangeListener("list values", this.buildListener());
        TransformationListValueModelAdapterTests.assertEquals((int)this.buildTransformedList().size(), (int)CollectionTools.size((Iterator)this.transformedListHolder.iterator()));
    }

    private boolean transformedListContains(Object item) {
        return CollectionTools.contains((Iterator)this.transformedListHolder.iterator(), (Object)item);
    }

    private boolean transformedListContainsAll(Collection<String> items) {
        return CollectionTools.containsAll((Iterator)this.transformedListHolder.iterator(), items);
    }

    private boolean transformedListContainsAny(Collection<String> items) {
        List transformedList = CollectionTools.list((Iterator)this.transformedListHolder.iterator());
        Iterator<String> stream = items.iterator();
        while (stream.hasNext()) {
            if (!transformedList.contains(stream.next())) continue;
            return true;
        }
        return false;
    }

    public void testAdd() {
        this.transformedListHolder.addListChangeListener("list values", this.buildListener());
        TransformationListValueModelAdapterTests.assertFalse((boolean)this.transformedListContains("JOO"));
        this.listHolder.add(2, (Object)"joo");
        TransformationListValueModelAdapterTests.assertTrue((boolean)this.transformedListContains("JOO"));
        TransformationListValueModelAdapterTests.assertFalse((boolean)this.transformedListContains(null));
        this.listHolder.add(0, null);
        TransformationListValueModelAdapterTests.assertTrue((boolean)this.transformedListContains(null));
    }

    public void testAddAll() {
        this.transformedListHolder.addListChangeListener("list values", this.buildListener());
        TransformationListValueModelAdapterTests.assertFalse((boolean)this.transformedListContainsAny(this.buildTransformedAddList()));
        this.listHolder.addAll(2, this.buildAddList());
        TransformationListValueModelAdapterTests.assertTrue((boolean)this.transformedListContainsAll(this.buildTransformedAddList()));
    }

    public void testRemove() {
        this.transformedListHolder.addListChangeListener("list values", this.buildListener());
        TransformationListValueModelAdapterTests.assertTrue((boolean)this.transformedListContains("BAR"));
        this.listHolder.remove(this.buildList().indexOf("bar"));
        TransformationListValueModelAdapterTests.assertFalse((boolean)this.transformedListContains("BAR"));
        this.listHolder.add(1, null);
        TransformationListValueModelAdapterTests.assertTrue((boolean)this.transformedListContains(null));
        this.listHolder.remove(1);
        TransformationListValueModelAdapterTests.assertFalse((boolean)this.transformedListContains(null));
    }

    public void testListChangeGeneric() {
        this.transformedListHolder.addListChangeListener(this.buildListener());
        this.verifyListChange();
    }

    public void testListChangeNamed() {
        this.transformedListHolder.addListChangeListener("list values", this.buildListener());
        this.verifyListChange();
    }

    private void verifyListChange() {
        this.event = null;
        this.eventType = null;
        this.listHolder.add(1, (Object)"joo");
        this.verifyEvent(ADD, 1, "JOO");
        this.event = null;
        this.eventType = null;
        this.listHolder.add(1, null);
        this.verifyEvent(ADD, 1, null);
        this.event = null;
        this.eventType = null;
        this.listHolder.remove(1);
        this.verifyEvent(REMOVE, 1, null);
        this.event = null;
        this.eventType = null;
        this.listHolder.remove(1);
        this.verifyEvent(REMOVE, 1, "JOO");
        this.event = null;
        this.eventType = null;
        this.listHolder.addAll(0, this.buildList());
        this.verifyEvent(ADD);
        TransformationListValueModelAdapterTests.assertEquals(this.buildTransformedList(), (Object)CollectionTools.list((Iterator)this.event.items()));
        this.event = null;
        this.eventType = null;
        this.listHolder.set(0, (Object)"joo");
        this.verifyEvent(REPLACE);
        TransformationListValueModelAdapterTests.assertFalse((boolean)CollectionTools.contains((Iterator)this.event.items(), (Object)"FOO"));
        TransformationListValueModelAdapterTests.assertTrue((boolean)CollectionTools.contains((Iterator)this.event.items(), (Object)"JOO"));
    }

    private ListChangeListener buildListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                TransformationListValueModelAdapterTests.this.eventType = TransformationListValueModelAdapterTests.ADD;
                TransformationListValueModelAdapterTests.this.event = e;
            }

            public void itemsRemoved(ListChangeEvent e) {
                TransformationListValueModelAdapterTests.this.eventType = TransformationListValueModelAdapterTests.REMOVE;
                TransformationListValueModelAdapterTests.this.event = e;
            }

            public void itemsReplaced(ListChangeEvent e) {
                TransformationListValueModelAdapterTests.this.eventType = TransformationListValueModelAdapterTests.REPLACE;
                TransformationListValueModelAdapterTests.this.event = e;
            }

            public void itemsMoved(ListChangeEvent e) {
                TransformationListValueModelAdapterTests.this.eventType = TransformationListValueModelAdapterTests.MOVE;
                TransformationListValueModelAdapterTests.this.event = e;
            }

            public void listCleared(ListChangeEvent e) {
                TransformationListValueModelAdapterTests.this.eventType = TransformationListValueModelAdapterTests.CLEAR;
                TransformationListValueModelAdapterTests.this.event = e;
            }

            public void listChanged(ListChangeEvent e) {
                TransformationListValueModelAdapterTests.this.eventType = TransformationListValueModelAdapterTests.CHANGE;
                TransformationListValueModelAdapterTests.this.event = e;
            }
        };
    }

    private void verifyEvent(String type) {
        TransformationListValueModelAdapterTests.assertEquals((String)type, (String)this.eventType);
        TransformationListValueModelAdapterTests.assertEquals(this.transformedListHolder, (Object)this.event.getSource());
        TransformationListValueModelAdapterTests.assertEquals((String)"list values", (String)this.event.getListName());
    }

    private void verifyEvent(String type, int index, Object item) {
        this.verifyEvent(type);
        TransformationListValueModelAdapterTests.assertEquals((int)index, (int)this.event.getIndex());
        TransformationListValueModelAdapterTests.assertEquals((Object)item, this.event.items().next());
    }

    public void testHasListeners() {
        TransformationListValueModelAdapterTests.assertFalse((boolean)this.listHolder.hasAnyListChangeListeners("list values"));
        ListChangeListener listener = this.buildListener();
        this.transformedListHolder.addListChangeListener("list values", listener);
        TransformationListValueModelAdapterTests.assertTrue((boolean)this.listHolder.hasAnyListChangeListeners("list values"));
        this.transformedListHolder.removeListChangeListener("list values", listener);
        TransformationListValueModelAdapterTests.assertFalse((boolean)this.listHolder.hasAnyListChangeListeners("list values"));
        this.transformedListHolder.addListChangeListener(listener);
        TransformationListValueModelAdapterTests.assertTrue((boolean)this.listHolder.hasAnyListChangeListeners("list values"));
        this.transformedListHolder.removeListChangeListener(listener);
        TransformationListValueModelAdapterTests.assertFalse((boolean)this.listHolder.hasAnyListChangeListeners("list values"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TransformerTests
    extends TransformationListValueModelAdapterTests {
        public TransformerTests(String name) {
            super(name);
        }

        @Override
        ListValueModel<String> buildTransformedListHolder(ListValueModel<String> lvm) {
            return new TransformationListValueModelAdapter(lvm, this.buildTransformer());
        }

        private Transformer<String, String> buildTransformer() {
            return new Transformer<String, String>(){

                public String transform(String s) {
                    return s == null ? null : s.toUpperCase();
                }
            };
        }
    }
}

