/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.iterators;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneIterator<E>
implements Iterator<E> {
    private final Iterator<Object> nestedIterator;
    private E current;
    private final Mutator<E> mutator;
    private boolean removeAllowed;

    public CloneIterator(Collection<? extends E> c) {
        this(c, Mutator.ReadOnly.instance());
    }

    public CloneIterator(Collection<? extends E> c, Mutator<E> mutator) {
        this.nestedIterator = new ArrayIterator<Object>(c.toArray());
        this.current = null;
        this.mutator = mutator;
        this.removeAllowed = false;
    }

    @Override
    public boolean hasNext() {
        return this.nestedIterator.hasNext();
    }

    @Override
    public E next() {
        this.current = this.nestedNext();
        this.removeAllowed = true;
        return this.current;
    }

    @Override
    public void remove() {
        if (!this.removeAllowed) {
            throw new IllegalStateException();
        }
        this.remove(this.current);
        this.removeAllowed = false;
    }

    protected E nestedNext() {
        return (E)this.nestedIterator.next();
    }

    protected void remove(E e) {
        this.mutator.remove(e);
    }

    public String toString() {
        return StringTools.buildToStringFor(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Mutator<T> {
        public void remove(T var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class ReadOnly<S>
        implements Mutator<S> {
            public static final Mutator INSTANCE = new ReadOnly();

            public static <R> Mutator<R> instance() {
                return INSTANCE;
            }

            private ReadOnly() {
            }

            @Override
            public void remove(Object current) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "CloneIterator.Mutator.ReadOnly";
            }
        }
    }
}

