/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EjbFactory;
import org.eclipse.jst.jee.model.internal.EJBAnnotationReader;
import org.eclipse.jst.jee.model.internal.Ejb3ModelProvider;
import org.eclipse.jst.jee.model.internal.common.AbstractMergedModelProvider;
import org.eclipse.jst.jee.model.internal.mergers.EjbJarMerger;
import org.eclipse.jst.jee.model.internal.mergers.ModelElementMerger;
import org.eclipse.jst.jee.model.internal.mergers.ModelException;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJB3MergedModelProvider
extends AbstractMergedModelProvider<EJBJar> {
    private IProject clientProject;

    public EJB3MergedModelProvider(IProject project) {
        super(project);
    }

    protected IModelProvider loadAnnotationModel(EJBJar ddModel) throws CoreException {
        if (ddModel.getEjbClientJar() != null) {
            this.clientProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getClientNameFromJarName(ddModel.getEjbClientJar()));
        }
        return new EJBAnnotationReader(ProjectFacetsManager.create((IProject)this.project), this.clientProject);
    }

    protected IModelProvider loadDeploymentDescriptorModel() throws CoreException {
        return new Ejb3ModelProvider(this.project);
    }

    protected EJBJar getAnnotationEjbJar() {
        return this.annotationModelProvider != null ? (EJBJar)this.annotationModelProvider.getModelObject() : null;
    }

    protected EJBJar getXmlEjbJar() {
        return this.ddProvider != null ? (EJBJar)this.ddProvider.getModelObject() : null;
    }

    public Object getModelObject(IPath modelPath) {
        return null;
    }

    public void modify(Runnable runnable, IPath modelPath) {
        if (this.mergedModel == null) {
            this.getMergedModel();
        }
        if (this.isDisposed()) {
            return;
        }
        this.modifyWithBackup(runnable, modelPath);
    }

    private void modifyWithBackup(Runnable runnable, IPath modelPath) {
        EJBJar backup = (EJBJar)this.mergedModel;
        try {
            this.mergedModel = (EJBJar)this.ddProvider.getModelObject();
            this.ddProvider.modify(runnable, modelPath);
        }
        finally {
            this.mergedModel = backup;
        }
        this.clearModel((EJBJar)this.mergedModel);
        if (this.mergedModel == null) {
            this.mergedModel = (EJBJar)this.getMergedModel();
        } else {
            this.merge(this.getXmlEjbJar(), this.getAnnotationEjbJar());
        }
    }

    protected void annotationModelChanged(IModelProviderEvent event) {
        this.internalModelChanged(event);
    }

    protected void xmlModelChanged(IModelProviderEvent event) {
        this.internalModelChanged(event);
    }

    private synchronized void internalModelChanged(IModelProviderEvent event) {
        if (this.clientProject == null && this.getXmlEjbJar().getEjbClientJar() != null) {
            this.reloadAnnotationModel();
        } else if (this.clientProject != null && !this.clientProject.getName().equals(this.getClientNameFromJarName(this.getXmlEjbJar().getEjbClientJar()))) {
            this.reloadAnnotationModel();
        }
        this.merge(this.getXmlEjbJar(), this.getAnnotationEjbJar());
        this.notifyListeners(event);
    }

    private void reloadAnnotationModel() {
        try {
            this.disableInternalNotifications();
            ((EJBAnnotationReader)this.annotationModelProvider).dispose();
            this.annotationModelProvider = this.loadAnnotationModel(this.getXmlEjbJar());
            this.enableInternalNotifications();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private String getClientNameFromJarName(String jarName) {
        if (jarName == null) {
            return null;
        }
        if (jarName.endsWith(".jar")) {
            return jarName.substring(0, jarName.lastIndexOf(".jar"));
        }
        return jarName;
    }

    protected EJBJar merge(EJBJar ddModel, EJBJar annotationsModel) {
        try {
            if (this.mergedModel != ddModel) {
                this.clearModel((EJBJar)this.mergedModel);
                ((EJBJar)this.mergedModel).setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
                this.mergeWithModel(ddModel);
                this.mergeWithModel(annotationsModel);
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return (EJBJar)this.mergedModel;
    }

    private void mergeWithModel(EJBJar model) throws ModelException {
        if (model == null) {
            return;
        }
        EjbJarMerger merger = new EjbJarMerger((JavaEEObject)this.mergedModel, (JavaEEObject)model, ModelElementMerger.ADD);
        merger.process();
    }

    private void clearModel(EJBJar jar) {
        jar.setAssemblyDescriptor(null);
        jar.setEnterpriseBeans(null);
        jar.getDescriptions().clear();
        jar.getDisplayNames().clear();
        jar.setRelationships(null);
        jar.setEjbClientJar(null);
        jar.setInterceptors(null);
        jar.getIcons().clear();
    }

    protected EJBJar createNewModelInstance() {
        return EjbFactory.eINSTANCE.createEJBJar();
    }
}

