/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.component;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.ResolverUtil;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.ui.internal.component.ComponentMasterDetailBlock;
import org.eclipse.jst.jsf.ui.internal.component.DTJSFViewModel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class ComponentTreeView
extends PageBookView {
    private FormToolkit _toolkit;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.setTitleImage(JSFUICommonPlugin.getDefault().getImage("jsf_view.gif"));
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        page.setMessage("Nothing to display");
        return page;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        this._toolkit = new FormToolkit(this.getPageBook().getDisplay());
        ComponentPage page = new ComponentPage(this.getDocumentFromPart(part), this._toolkit);
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)this.getPageBook());
        return new PageBookView.PageRec(part, (IPage)page);
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        pageRecord.page.dispose();
        pageRecord.dispose();
    }

    private IDocument getDocumentFromPart(IWorkbenchPart part) {
        return (IDocument)part.getAdapter(IDocument.class);
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        DesignTimeApplicationManager manager;
        IFile file;
        IDocument document = this.getDocumentFromPart(part);
        if (document != null && (file = ResolverUtil.getFileForDocument((IDocument)document)) != null && (manager = DesignTimeApplicationManager.getInstance((IProject)file.getProject())) != null) {
            return manager.hasDTFacesContext(file);
        }
        return false;
    }

    private static class ComponentPage
    extends Page {
        private final IDocument _document;
        private final FormToolkit _toolkit;
        private ComponentMasterDetailBlock _masterDetailBlock;
        private Form _form;
        private DTJSFViewModel _model;

        public ComponentPage(IDocument document, FormToolkit toolkit) {
            this._document = document;
            this._toolkit = toolkit;
        }

        public void createControl(Composite parent) {
            this._model = new DTJSFViewModel((IStructuredDocument)this._document);
            this._form = this._toolkit.createForm(parent);
            this._form.setLayoutData((Object)new GridData(4, 4, true, true));
            this._masterDetailBlock = new ComponentMasterDetailBlock(this._model);
            this._masterDetailBlock.createContent(this._toolkit, this._form);
        }

        public void dispose() {
            super.dispose();
            this._model.dispose();
        }

        public Control getControl() {
            return this._form;
        }

        public void setFocus() {
        }
    }
}

