/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.tests;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.tests.validation.Activator;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;
import org.eclipse.wst.validation.tests.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestValidator
extends AbstractValidator {
    private static final String SimpleName = "Test1";

    public static String id() {
        return "org.eclipse.wst.common.tests.validation.Test1";
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        ValidationResult vr = new ValidationResult();
        InputStream in = null;
        try {
            try {
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    in = file.getContents();
                    BufferedReader rdr = new BufferedReader(new InputStreamReader(in));
                    this.process(vr, rdr, resource, state);
                }
            }
            catch (Exception e) {
                Activator.getDefault().handleException(e);
                Misc.close(in);
            }
        }
        finally {
            Misc.close(in);
        }
        return vr;
    }

    public String getId() {
        return TestValidator.id();
    }

    private void process(ValidationResult vr, BufferedReader rdr, IResource resource, ValidationState state) throws IOException, CoreException {
        String line = null;
        int count = 0;
        HashMap<String, String> map = null;
        while ((line = rdr.readLine()) != null) {
            String msg;
            ++count;
            int severity = -1;
            String[] tokens = line.split("\\s");
            String token = tokens[0];
            severity = this.findSeverity(token, severity);
            if (severity == -1 && map != null) {
                String renamed = (String)map.get(token);
                severity = this.findSeverity(renamed, severity);
            }
            if (severity != -1) {
                ValidatorMessage message = ValidatorMessage.create((String)(String.valueOf(line) + "(by " + this.getName() + ")"), (IResource)resource);
                message.setAttribute("lineNumber", count);
                message.setAttribute("severity", severity);
                vr.add(message);
            }
            if (!token.equals("include") || (msg = this.processInclude(vr, tokens, resource, map = new HashMap<String, String>(10))) == null) continue;
            ValidatorMessage message = ValidatorMessage.create((String)msg, (IResource)resource);
            message.setAttribute("lineNumber", count);
            message.setAttribute("severity", 2);
            vr.add(message);
        }
    }

    private int findSeverity(String token, int dft) {
        if (token == null) {
            return dft;
        }
        if (token.equals("error")) {
            return 2;
        }
        if (token.equals("warning")) {
            return 1;
        }
        if (token.equals("info")) {
            return 0;
        }
        return dft;
    }

    private String processInclude(ValidationResult vr, String[] tokens, IResource resource, Map<String, String> map) throws IOException, CoreException {
        IContainer parent = resource.getParent();
        IFile file = parent.getFile((IPath)new Path(tokens[1]));
        if (!file.exists()) {
            return "Could not find file: " + file;
        }
        InputStream in = null;
        try {
            in = file.getContents();
            BufferedReader rdr = new BufferedReader(new InputStreamReader(in));
            String line = null;
            while ((line = rdr.readLine()) != null) {
                String[] p = line.split("\\s");
                if (p.length != 3 || !"map".equals(p[0])) continue;
                map.put(p[1], p[2]);
            }
        }
        finally {
            Misc.close(in);
        }
        IResource[] depends = new IResource[]{file};
        vr.setDependsOn(depends);
        return null;
    }

    public String getName() {
        return "TestValidator1";
    }
}

