/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.wst.jsdt.core.BindingKey;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;

public class BindingKeyTests
extends AbstractJavaModelTests {
    static /* synthetic */ Class class$0;

    public BindingKeyTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.BindingKeyTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return BindingKeyTests.buildModelTestSuite(clazz);
    }

    protected void assertBindingKeyEquals(String expected, String key) {
        if (!expected.equals(key)) {
            System.out.println(String.valueOf(this.displayString(key, 3)) + ",");
        }
        BindingKeyTests.assertEquals((String)expected, (String)key);
    }

    protected void assertBindingKeySignatureEquals(String expected, String key) {
        BindingKey bindingKey = new BindingKey(key);
        String signature = bindingKey.toSignature();
        if (!expected.equals(signature)) {
            System.out.println(String.valueOf(this.displayString(signature, 3)) + ",");
        }
        BindingKeyTests.assertEquals((String)expected, (String)signature);
    }

    public void test001() {
        this.assertBindingKeySignatureEquals("p", "p");
    }

    public void test002() {
        this.assertBindingKeySignatureEquals("Lp.X;", "Lp/X;");
    }

    public void test003() {
        this.assertBindingKeySignatureEquals("LClazz;", "LClazz;");
    }

    public void test004() {
        this.assertBindingKeySignatureEquals("Lp.X$Member;", "Lp/X$Member;");
    }

    public void test005() {
        this.assertBindingKeySignatureEquals("Lp1.X$Member1$Member2;", "Lp1/X$Member1$Member2;");
    }

    public void test006() {
        this.assertBindingKeySignatureEquals("Lp1.X$1;", "Lp1/X$1;");
    }

    public void test007() {
        this.assertBindingKeySignatureEquals("Lp1.X$1$Y;", "Lp1/X$1$Y;");
    }

    public void test008() {
        this.assertBindingKeySignatureEquals("[Lp1.X;", "[Lp1/X;");
    }

    public void test009() {
        this.assertBindingKeySignatureEquals("<T:Ljava/lang/Object;>Lp1.X;", "Lp1/X<TT;>;");
    }

    public void test010() {
        this.assertBindingKeySignatureEquals("<T:Ljava/lang/Object;U:Ljava/lang/Object;>Lp1.X;", "Lp1/X<TT;TU;>;");
    }

    public void test011() {
        this.assertBindingKeySignatureEquals("Lp1.X<Ljava.lang.String;>;", "Lp1/X<Ljava/lang/String;>;");
    }

    public void test012() {
        this.assertBindingKeySignatureEquals("Lp1.Secondary;", "Lp1/X~Secondary;");
    }

    public void test013() {
        this.assertBindingKeySignatureEquals("Lp1.Secondary$1;", "Lp1/X~Secondary$1;");
    }

    public void test014() {
        this.assertBindingKeySignatureEquals("(Ljava.lang.String;I)Z", "Lp1/X;.foo(Ljava/lang/String;I)Z");
    }

    public void test015() {
        String key = BindingKey.createTypeBindingKey((String)"java.lang.Object");
        this.assertBindingKeyEquals("Ljava/lang/Object;", key);
    }

    public void test016() {
        String key = BindingKey.createTypeBindingKey((String)"int");
        this.assertBindingKeyEquals("I", key);
    }

    public void test017() {
        String key = BindingKey.createTypeBindingKey((String)"boolean[]");
        this.assertBindingKeyEquals("[Z", key);
    }

    public void test018() {
        String key = BindingKey.createParameterizedTypeBindingKey((String)"Ljava/util/Map<TK;TV;>;", (String[])new String[]{"Ljava/lang/String;", "Ljava/lang/Object;"});
        this.assertBindingKeyEquals("Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", key);
    }

    public void test019() {
        String key = BindingKey.createParameterizedTypeBindingKey((String)"Ljava/util/List<TE:>;", (String[])new String[0]);
        this.assertBindingKeyEquals("Ljava/util/List<>;", key);
    }

    public void test020() {
        String key = BindingKey.createArrayTypeBindingKey((String)"Ljava/lang/Object;", (int)1);
        this.assertBindingKeyEquals("[Ljava/lang/Object;", key);
    }

    public void test021() {
        String key = BindingKey.createArrayTypeBindingKey((String)"I", (int)2);
        this.assertBindingKeyEquals("[[I", key);
    }

    public void test022() {
        String key = BindingKey.createWilcardTypeBindingKey(null, (char)'*');
        this.assertBindingKeyEquals("*", key);
    }

    public void test023() {
        String key = BindingKey.createWilcardTypeBindingKey((String)"Ljava/util/List<TE;>;", (char)'-');
        this.assertBindingKeyEquals("-Ljava/util/List<TE;>;", key);
    }

    public void test024() {
        String key = BindingKey.createWilcardTypeBindingKey((String)"Ljava/util/ArrayList;", (char)'+');
        this.assertBindingKeyEquals("+Ljava/util/ArrayList;", key);
    }

    public void test025() {
        String key = BindingKey.createTypeVariableBindingKey((String)"T", (String)"Ljava/util/List<TE;>;");
        this.assertBindingKeyEquals("Ljava/util/List<TE;>;:TT;", key);
    }

    public void test026() {
        String key = BindingKey.createTypeVariableBindingKey((String)"SomeTypeVariable", (String)"Lp/X;.foo()V");
        this.assertBindingKeyEquals("Lp/X;.foo()V:TSomeTypeVariable;", key);
    }

    public void test027() {
        this.assertBindingKeySignatureEquals("Lp1.X<Ljava.lang.String;>.Member;", "Lp1/X<Ljava/lang/String;>.Member;");
    }

    public void test028() {
        this.assertBindingKeySignatureEquals("*", "Lp1/X;*");
    }

    public void test029() {
        this.assertBindingKeySignatureEquals("-<E:Ljava/lang/Object;>Ljava.util.List;", "Lp1/X;-Ljava/util/List<TE;>;");
    }

    public void test030() {
        this.assertBindingKeySignatureEquals("+Ljava.util.ArrayList;", "Lp1/X;+Ljava/util/ArrayList;");
    }

    public void test031() {
        this.assertBindingKeySignatureEquals("*", "Ljava/util/List;&!Lp1/X;*123;");
    }

    public void test032() {
        this.assertBindingKeySignatureEquals("-<E:Ljava/lang/Object;>Ljava.util.List;", "Ljava/util/List;&!Lp1/X;-Ljava/util/List<TE;>;123;");
    }

    public void test033() {
        this.assertBindingKeySignatureEquals("+Ljava.util.ArrayList;", "Ljava/util/List;&!Lp1/X;+Ljava/util/ArrayList;123;");
    }

    public void test034() {
        this.assertBindingKeySignatureEquals("(Ljava.lang.String;I)Z", "Lp1/X;.Set(Ljava/lang/String;I)Z");
    }

    public void test035() {
        this.assertBindingKeySignatureEquals("(!*)!*", "LX;&LX~Store<!LX~Store;*157;>;.get(!*)!*");
    }

    public void test036() {
        this.assertBindingKeySignatureEquals("<U:Ljava.lang.Object;>(La.TU;La.TU;)V", "La/A<La/A~TU;>;.foo<U:Ljava/lang/Object;>(TU;La/TU;)V%<La/A~TU;>");
    }

    public void test037() {
        this.assertBindingKeySignatureEquals("Ljava.lang.String;", "Lp/X;.foo)Ljava/lang/String;");
    }

    public void test038() {
        this.assertBindingKeySignatureEquals("<T:Ljava/lang/Object;U:Ljava/lang/Object;>Lp1.Y;", "Lp1/X~Y<TT;TU;>;");
    }

    public void test039() {
        this.assertBindingKeySignatureEquals("Z", "Z");
    }

    public void test040() {
        this.assertBindingKeySignatureEquals("<T:Ljava.lang.Object;>(Ljava.util.List<Ljava.lang.String;>;Ljava.lang.Integer;)V", "Lp1/X;.foo<T:Ljava/lang/Object;>(Ljava/util/List<TT;>;Ljava/lang/Integer;)V%<Ljava/lang/String;>)");
    }

    public void test041() {
        this.assertBindingKeySignatureEquals("<T:Ljava.lang.Object;>(LY<-Ljava.lang.NullPointerException;>;Ljava.lang.NullPointerException;)V", "LX~Z;.foo<T:Ljava/lang/Object;>(LY<-TT;>;TT;)V%<Ljava/lang/NullPointerException;>");
    }

    public void test042() {
        this.assertBindingKeySignatureEquals("<T:Ljava.lang.Object;>([Ljava.lang.NullPointerException;Ljava.lang.NullPointerException;)V", "LX~Z;.foo<T:Ljava/lang/Object;>([TT;TT;)V%<Ljava/lang/NullPointerException;>");
    }

    public void test043() {
        this.assertBindingKeySignatureEquals("Lp1.Y<TT;>;", "Lp1/X~Y<Lp1/X;:40TT;>;");
    }

    public void test044() {
        this.assertBindingKeySignatureEquals("<SM:Ljava/lang/Object;LM:Ljava/lang/Object;>LX;", "LX<TSM;TLM;>;");
    }
}

