/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IProblemRequestor;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.core.tests.model.TestvalidationParticipant;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;

public class ReconcilerStatementsRecoveryTests
extends ModifyingResourceTests {
    protected IJavaScriptUnit workingCopy;
    protected AbstractJavaModelTests.ProblemRequestor problemRequestor;
    static /* synthetic */ Class class$0;

    public ReconcilerStatementsRecoveryTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.ReconcilerStatementsRecoveryTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ReconcilerStatementsRecoveryTests.buildModelTestSuite(clazz);
    }

    protected void assertProblems(String message, String expected) {
        this.assertProblems(message, expected, this.problemRequestor);
    }

    protected void assertNoProblem(char[] source, IJavaScriptUnit unit) throws InterruptedException, JavaScriptModelException {
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        if (this.problemRequestor.problemCount > 0) {
            while (indexManager.awaitingJobsCount() > 0) {
                Thread.sleep(100L);
            }
            this.problemRequestor.initialize(source);
            unit.getBuffer().setContents(source);
            unit.reconcile(3, true, null, null);
            if (this.problemRequestor.problemCount > 0) {
                ReconcilerStatementsRecoveryTests.assertEquals((String)"Working copy should NOT have any problem!", (String)"", (String)this.problemRequestor.problems.toString());
            }
        }
    }

    protected void addClasspathEntries(IIncludePathEntry[] entries, boolean enableForbiddenReferences) throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("Reconciler");
        IIncludePathEntry[] oldClasspath = project.getRawIncludepath();
        int oldLength = oldClasspath.length;
        int length = entries.length;
        IIncludePathEntry[] newClasspath = new IIncludePathEntry[oldLength + length];
        System.arraycopy(oldClasspath, 0, newClasspath, 0, oldLength);
        System.arraycopy(entries, 0, newClasspath, oldLength, length);
        project.setRawIncludepath(newClasspath, null);
        if (enableForbiddenReferences) {
            project.setOption("org.eclipse.wst.jsdt.core.compiler.problem.forbiddenReference", "error");
        }
    }

    protected void removeClasspathEntries(IIncludePathEntry[] entries) throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("Reconciler");
        IIncludePathEntry[] oldClasspath = project.getRawIncludepath();
        int oldLength = oldClasspath.length;
        int length = entries.length;
        IIncludePathEntry[] newClasspath = new IIncludePathEntry[oldLength - length];
        System.arraycopy(oldClasspath, 0, newClasspath, 0, oldLength - length);
        project.setRawIncludepath(newClasspath, null);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
        this.workingCopy = this.getCompilationUnit("Reconciler/src/p1/X.js").getWorkingCopy(new WorkingCopyOwner(){}, (IProblemRequestor)this.problemRequestor, null);
        this.problemRequestor.initialize(this.workingCopy.getSource().toCharArray());
        this.startDeltas();
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        IJavaScriptProject project14 = this.createJavaProject("Reconciler", new String[]{"src"}, new String[]{"JCL_LIB"}, "bin");
        this.createFolder("/Reconciler/src/p1");
        this.createFolder("/Reconciler/src/p2");
        this.createFile("/Reconciler/src/p1/X.js", "  function foo() {\n}");
        project14.setOption("org.eclipse.wst.jsdt.core.compiler.problem.unusedLocal", "ignore");
        project14.setOption("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadoc", "warning");
        IJavaScriptProject project15 = this.createJavaProject("Reconciler15", new String[]{"src"}, new String[]{"JCL15_LIB"}, "bin", "1.5");
        this.addLibrary(project15, "lib15.jar", "lib15src.zip", new String[]{"java/util/List.js", "package java.util;\npublic class List<T> {\n}", "java/util/Stack.js", "package java.util;\npublic class Stack<T> {\n}", "java/util/Map.js", "package java.util;\npublic interface Map<K,V> {\n}", "java/lang/annotation/Annotation.js", "package java.lang.annotation;\npublic interface Annotation {\n}", "java/lang/Deprecated.js", "package java.lang;\npublic @interface Deprecated {\n}", "java/lang/SuppressWarnings.js", "package java.lang;\npublic @interface SuppressWarnings {\n   String[] value();\n}"}, "1.5");
        project15.setOption("org.eclipse.wst.jsdt.core.compiler.problem.unusedLocal", "ignore");
    }

    void setWorkingCopyContents(String contents) throws JavaScriptModelException {
        this.workingCopy.getBuffer().setContents(contents);
        this.problemRequestor.initialize(contents.toCharArray());
    }

    public void tearDown() throws Exception {
        TestvalidationParticipant.PARTICIPANT = null;
        if (this.workingCopy != null) {
            this.workingCopy.discardWorkingCopy();
        }
        this.stopDeltas();
        super.tearDown();
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject("Reconciler");
        this.deleteProject("Reconciler15");
        super.tearDownSuite();
    }

    public void testStatementsRecovery01() throws CoreException {
        this.setWorkingCopyContents("package p1;\nimport p2.*;\npublic class X {\n  public void foo() {\n     UnknownType name\n  }\n}");
        this.workingCopy.reconcile(0, false, false, null, null);
        this.assertDeltas("Unexpected delta after syntax error", "[Working copy] X.js[*]: {CONTENT | FINE GRAINED}");
        this.assertProblems("Unexpected problems", "----------\n1. ERROR in /Reconciler/src/p1/X.js (at line 5)\n\tUnknownType name\n\t            ^^^^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n");
        this.clearDeltas();
    }

    public void testStatementsRecovery02() throws CoreException {
        this.setWorkingCopyContents("package p1;\nimport p2.*;\npublic class X {\n  public void foo() {\n     UnknownType name\n  }\n}");
        this.workingCopy.reconcile(3, false, false, null, null);
        this.assertDeltas("Unexpected delta after syntax error", "[Working copy] X.js[*]: {CONTENT | FINE GRAINED | AST AFFECTED}");
        this.assertProblems("Unexpected problems", "----------\n1. ERROR in /Reconciler/src/p1/X.js (at line 5)\n\tUnknownType name\n\t            ^^^^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n");
        this.clearDeltas();
    }

    public void testStatementsRecovery03() throws CoreException {
        this.setWorkingCopyContents("package p1;\nimport p2.*;\npublic class X {\n  public void foo() {\n     UnknownType name\n  }\n}");
        this.workingCopy.reconcile(0, false, true, null, null);
        this.assertDeltas("Unexpected delta after syntax error", "[Working copy] X.js[*]: {CONTENT | FINE GRAINED}");
        this.assertProblems("Unexpected problems", "----------\n1. ERROR in /Reconciler/src/p1/X.js (at line 5)\n\tUnknownType name\n\t^^^^^^^^^^^\nUnknownType cannot be resolved to a type\n----------\n2. ERROR in /Reconciler/src/p1/X.js (at line 5)\n\tUnknownType name\n\t            ^^^^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n");
        this.clearDeltas();
    }

    public void testStatementsRecovery04() throws CoreException {
        this.setWorkingCopyContents("package p1;\nimport p2.*;\npublic class X {\n  public void foo() {\n     UnknownType name\n  }\n}");
        this.workingCopy.reconcile(3, false, true, null, null);
        this.assertDeltas("Unexpected delta after syntax error", "[Working copy] X.js[*]: {CONTENT | FINE GRAINED | AST AFFECTED}");
        this.assertProblems("Unexpected problems", "----------\n1. ERROR in /Reconciler/src/p1/X.js (at line 5)\n\tUnknownType name\n\t^^^^^^^^^^^\nUnknownType cannot be resolved to a type\n----------\n2. ERROR in /Reconciler/src/p1/X.js (at line 5)\n\tUnknownType name\n\t            ^^^^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n");
        this.clearDeltas();
    }

    class CancelingProblemRequestor
    extends AbstractJavaModelTests.ProblemRequestor {
        IProgressMonitor progressMonitor = new IProgressMonitor(this){
            boolean isCanceled;
            final /* synthetic */ CancelingProblemRequestor this$1;
            {
                this.this$1 = cancelingProblemRequestor;
                this.isCanceled = false;
            }

            public void beginTask(String name, int totalWork) {
            }

            public void done() {
            }

            public void internalWorked(double work) {
            }

            public boolean isCanceled() {
                return this.isCanceled;
            }

            public void setCanceled(boolean value) {
                this.isCanceled = value;
            }

            public void setTaskName(String name) {
            }

            public void subTask(String name) {
            }

            public void worked(int work) {
            }
        };
        boolean isCanceling = false;

        CancelingProblemRequestor() {
        }

        public void acceptProblem(IProblem problem) {
            if (this.isCanceling) {
                this.progressMonitor.setCanceled(true);
            }
            super.acceptProblem(problem);
        }
    }
}

