/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.core.tests;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import junit.framework.TestCase;
import org.apache.xpath.jaxp.XPathFactoryImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.core.internal.model.StylesheetModel;
import org.eclipse.wst.xsl.core.internal.validation.XSLValidationMessage;
import org.eclipse.wst.xsl.core.internal.validation.XSLValidationReport;
import org.eclipse.wst.xsl.core.internal.validation.XSLValidator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValidationTest
extends TestCase {
    protected static IProject fTestProject;
    private static boolean fTestProjectInitialized;
    private static final String TEST_PROJECT_NAME = "testproject";

    protected void setUp() throws Exception {
        super.setUp();
        if (!fTestProjectInitialized) {
            AbstractValidationTest.getAndCreateProject();
            Enumeration e = Platform.getBundle((String)"org.eclipse.wst.xsl.core.tests").getEntryPaths("/projectfiles");
            while (e.hasMoreElements()) {
                String path = (String)e.nextElement();
                URL url = Platform.getBundle((String)"org.eclipse.wst.xsl.core.tests").getEntry(path);
                if (url.getFile().endsWith("/")) continue;
                url = FileLocator.resolve((URL)url);
                path = path.substring("projectfiles".length());
                IFile destFile = fTestProject.getFile(path);
                System.out.println(destFile.getLocation() + " --> " + url.toExternalForm());
                destFile.createLink(url.toURI(), 256, (IProgressMonitor)new NullProgressMonitor());
            }
            fTestProject.refreshLocal(2, null);
            fTestProjectInitialized = true;
        }
    }

    protected IFile getFile(String path) {
        return fTestProject.getFile((IPath)new Path(path));
    }

    protected XSLValidationReport validate(IFile file) throws CoreException, XPathExpressionException, IOException {
        XSLValidationReport report = new XSLValidationReport(file.getLocationURI().toString());
        XSLValidator.getInstance().validate(file, report, true);
        StylesheetModel model = XSLCore.getInstance().getStylesheet(file);
        AbstractValidationTest.assertFalse((String)"Stylesheet model is null", (model == null ? 1 : 0) != 0);
        Map<Integer, String> expectedErrors = this.calculateErrorsAndWarnings(file);
        this.validateErrors(model, report, expectedErrors);
        return report;
    }

    private void validateErrors(StylesheetModel model, XSLValidationReport report, Map<Integer, String> expectedErrors) {
        expectedErrors = new HashMap<Integer, String>(expectedErrors);
        ValidationMessage[] validationMessageArray = report.getValidationMessages();
        int n = validationMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            ValidationMessage msg = validationMessageArray[n2];
            XSLValidationMessage error = (XSLValidationMessage)msg;
            AbstractValidationTest.assertTrue((String)"Error report must be for the current stylesheet only", (error.getNode().getStylesheet() == model.getStylesheet() ? 1 : 0) != 0);
            String comment = expectedErrors.remove(error.getLineNumber());
            AbstractValidationTest.assertNotNull((String)("Unxpected error at line " + error.getLineNumber() + ": " + error), (Object)comment);
            AbstractValidationTest.assertFalse((String)("Incorrect error level for error at line " + error.getLineNumber() + ": " + error), (comment.startsWith("ERROR") && msg.getSeverity() != ValidationMessage.SEV_HIGH ? 1 : 0) != 0);
            AbstractValidationTest.assertFalse((String)("Incorrect error level for error at line " + error.getLineNumber() + ": " + error), (comment.startsWith("WARN") && msg.getSeverity() == ValidationMessage.SEV_HIGH ? 1 : 0) != 0);
            ++n2;
        }
        for (Map.Entry<Integer, String> entry : expectedErrors.entrySet()) {
            AbstractValidationTest.assertTrue((String)("Expected error " + entry.getValue() + " at line " + entry.getKey()), (boolean)false);
        }
    }

    private Map<Integer, String> calculateErrorsAndWarnings(IFile file) throws XPathExpressionException, IOException, CoreException {
        HashMap<Integer, String> expectedErrors = new HashMap<Integer, String>();
        IStructuredModel smodel = null;
        try {
            smodel = StructuredModelManager.getModelManager().getModelForRead(file);
            if (smodel != null && smodel instanceof IDOMModel) {
                IDOMModel model = (IDOMModel)smodel;
                XPathExpression xp = XPathFactoryImpl.newInstance().newXPath().compile("//comment()");
                NodeList nodeSet = (NodeList)xp.evaluate(model.getDocument(), XPathConstants.NODESET);
                int i = 0;
                while (i < nodeSet.getLength()) {
                    Node commentNode = nodeSet.item(i);
                    String comment = commentNode.getNodeValue().trim();
                    if (comment.startsWith("ERROR") || comment.startsWith("WARN")) {
                        IDOMNode parent = (IDOMNode)commentNode.getParentNode();
                        int line = model.getStructuredDocument().getLineOfOffset(parent.getStartOffset()) + 1;
                        expectedErrors.put(line, comment);
                    }
                    ++i;
                }
            }
        }
        finally {
            if (smodel != null) {
                smodel.releaseFromRead();
            }
        }
        return expectedErrors;
    }

    private static void getAndCreateProject() throws CoreException {
        IWorkspace workspace = AbstractValidationTest.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        fTestProject = root.getProject(TEST_PROJECT_NAME);
        AbstractValidationTest.createProject(fTestProject, null, null);
        fTestProject.refreshLocal(2, null);
        AbstractValidationTest.assertTrue((boolean)fTestProject.exists());
    }

    private static void createProject(IProject project, IPath locationPath, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("creating test project", 10);
        try {
            if (!project.exists()) {
                IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
                if (Platform.getLocation().equals((Object)locationPath)) {
                    locationPath = null;
                }
                desc.setLocation(locationPath);
                project.create(desc, monitor);
                monitor = null;
            }
            if (!project.isOpen()) {
                project.open(monitor);
                monitor = null;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }
}

