/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.dependency.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.dependency.tests.AbstractTests;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyCreationUtil;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyUtil;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyVerificationUtil;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;

public class ProjectEARRefactoringTests
extends AbstractTests {
    public ProjectEARRefactoringTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Project EAR Refactoring Tests");
        suite.addTest((Test)new ProjectEARRefactoringTests("testDeleteEARWebModule"));
        suite.addTest((Test)new ProjectEARRefactoringTests("testDeleteEARUtilModule"));
        suite.addTest((Test)new ProjectEARRefactoringTests("testDeleteEAREJBModule"));
        suite.addTest((Test)new ProjectEARRefactoringTests("testRenameEARWebModule"));
        suite.addTest((Test)new ProjectEARRefactoringTests("testRenameEARUtilModule"));
        suite.addTest((Test)new ProjectEARRefactoringTests("testMultipleEARWebDelete"));
        suite.addTest((Test)new ProjectEARRefactoringTests("testMultipleEARWebRename"));
        suite.addTest((Test)new ProjectEARRefactoringTests("testMultipleEARUtilDelete"));
        suite.addTest((Test)new ProjectEARRefactoringTests("testMultipleEARUtilRename"));
        suite.addTest((Test)new ProjectEARRefactoringTests("testDeleteWithEARModuleDependency"));
        suite.addTest((Test)new ProjectEARRefactoringTests("testRenameWithMultipleEARModuleDependency"));
        return suite;
    }

    public void testDeleteEARWebModule() throws Exception {
        DependencyUtil.disableValidation();
        IProject earProject = ProjectUtil.getProject("TestEAR");
        IProject webProject = ProjectUtil.createWebProject("TestWeb", earProject.getName());
        String moduleURI = DependencyVerificationUtil.verifyEARDependency(earProject, webProject, true);
        ProjectUtil.deleteProject(webProject);
        DependencyVerificationUtil.verifyEARDependencyRemoved(earProject, webProject, moduleURI);
        DependencyUtil.enableValidation();
    }

    public void testDeleteEARWebModuleWithValidation() throws Exception {
        IProject earProject = ProjectUtil.getProject("TestEAR");
        IProject webProject = ProjectUtil.createWebProject("TestWeb", earProject.getName());
        String moduleURI = DependencyVerificationUtil.verifyEARDependency(earProject, webProject, true);
        ProjectUtil.deleteProject(webProject);
        DependencyVerificationUtil.verifyEARDependencyRemoved(earProject, webProject, moduleURI);
    }

    public void testDeleteEARUtilModule() throws Exception {
        IProject earProject = ProjectUtil.getProject("TestEAR");
        IProject utilProject = ProjectUtil.createUtilityProject("TestUtil", earProject.getName());
        DependencyVerificationUtil.verifyEARDependency(earProject, utilProject, false);
        ProjectUtil.deleteProject(utilProject);
        DependencyVerificationUtil.verifyEARDependencyRemoved(earProject, utilProject);
    }

    public void testDeleteEAREJBModule() throws Exception {
        IProject earProject = ProjectUtil.getProject("TestEAR");
        IProject ejbProject = ProjectUtil.createEJBProject("TestEJB", earProject.getName());
        IProject ejbClientProject = ProjectUtil.getProject("TestEJBClient");
        String moduleURI = DependencyVerificationUtil.verifyEARDependency(earProject, ejbProject, true);
        DependencyVerificationUtil.verifyEARDependency(earProject, ejbClientProject, false);
        DependencyVerificationUtil.verifyModuleDependency(ejbProject, ejbClientProject);
        ProjectUtil.deleteProject(ejbProject);
        ProjectUtil.deleteProject(ejbClientProject);
        DependencyVerificationUtil.verifyEARDependencyRemoved(earProject, ejbProject, moduleURI);
        DependencyVerificationUtil.verifyEARDependencyRemoved(earProject, ejbClientProject);
    }

    public void testRenameEARWebModule() throws Exception {
        DependencyUtil.disableValidation();
        IProject earProject = ProjectUtil.getProject("TestEAR");
        IProject webProject = ProjectUtil.createWebProject("TestWeb", earProject.getName());
        String moduleURI = DependencyVerificationUtil.verifyEARDependency(earProject, webProject, true);
        ProjectUtil.deleteProject(webProject);
        DependencyVerificationUtil.verifyEARDependencyRemoved(earProject, webProject, moduleURI);
        DependencyUtil.enableValidation();
    }

    public void testRenameEARUtilModule() throws Exception {
        IProject earProject = ProjectUtil.getProject("TestEAR");
        IProject utilProject = ProjectUtil.createUtilityProject("TestUtil", earProject.getName());
        DependencyVerificationUtil.verifyEARDependency(earProject, utilProject, false);
        IProject newUtil = ProjectUtil.renameProject(utilProject, "newUtil");
        DependencyVerificationUtil.verifyEARDependencyChanged(earProject, utilProject, newUtil);
    }

    public void testRenameEAREJBModule() throws Exception {
        IProject earProject = ProjectUtil.getProject("TestEAR");
        IProject ejbProject = ProjectUtil.createEJBProject("TestEJB", earProject.getName());
        IProject ejbClientProject = ProjectUtil.getProject("TestEJBClient");
        String moduleURI = DependencyVerificationUtil.verifyEARDependency(earProject, ejbProject, true);
        DependencyVerificationUtil.verifyEARDependency(earProject, ejbClientProject, false);
        IProject newEJB = ProjectUtil.renameProject(ejbProject, "newEJB");
        DependencyVerificationUtil.verifyEARDependencyChanged(earProject, ejbProject, moduleURI, newEJB);
        DependencyVerificationUtil.verifyModuleDependency(newEJB, ejbClientProject);
    }

    public void testMultipleEARWebDelete() throws Exception {
        DependencyUtil.disableValidation();
        IProject earProject1 = ProjectUtil.getProject("TestEAR1");
        IProject earProject2 = ProjectUtil.createEARProject("TestEAR2");
        IProject webProject = ProjectUtil.createWebProject("TestWeb", earProject1.getName());
        DependencyCreationUtil.createEARDependency(earProject2, webProject);
        String moduleURI1 = DependencyVerificationUtil.verifyEARDependency(earProject1, webProject, true);
        String moduleURI2 = DependencyVerificationUtil.verifyEARDependency(earProject2, webProject, true);
        ProjectUtil.deleteProject(webProject);
        DependencyVerificationUtil.verifyEARDependencyRemoved(earProject1, webProject, moduleURI1);
        DependencyVerificationUtil.verifyEARDependencyRemoved(earProject2, webProject, moduleURI2);
        DependencyUtil.enableValidation();
    }

    public void testMultipleEARWebRename() throws Exception {
        DependencyUtil.disableValidation();
        IProject earProject1 = ProjectUtil.getProject("TestEAR1");
        IProject earProject2 = ProjectUtil.createEARProject("TestEAR2");
        IProject webProject = ProjectUtil.createWebProject("TestWeb", earProject1.getName());
        DependencyCreationUtil.createEARDependency(earProject2, webProject);
        String moduleURI1 = DependencyVerificationUtil.verifyEARDependency(earProject1, webProject, true);
        String moduleURI2 = DependencyVerificationUtil.verifyEARDependency(earProject2, webProject, true);
        IProject newWeb = ProjectUtil.renameProject(webProject, "newWeb");
        DependencyVerificationUtil.verifyEARDependencyChanged(earProject1, webProject, moduleURI1, newWeb);
        DependencyVerificationUtil.verifyEARDependencyChanged(earProject2, webProject, moduleURI2, newWeb);
        DependencyUtil.enableValidation();
    }

    public void testMultipleEARUtilDelete() throws Exception {
        IProject earProject1 = ProjectUtil.getProject("TestEAR1");
        IProject earProject2 = ProjectUtil.createEARProject("TestEAR2");
        IProject utilProject = ProjectUtil.createUtilityProject("TestUtil", earProject1.getName());
        DependencyCreationUtil.createEARDependency(earProject2, utilProject);
        DependencyVerificationUtil.verifyEARDependency(earProject1, utilProject, false);
        DependencyVerificationUtil.verifyEARDependency(earProject2, utilProject, false);
        ProjectUtil.deleteProject(utilProject);
        DependencyVerificationUtil.verifyEARDependencyRemoved(earProject1, utilProject);
        DependencyVerificationUtil.verifyEARDependencyRemoved(earProject2, utilProject);
    }

    public void testMultipleEARUtilRename() throws Exception {
        IProject earProject1 = ProjectUtil.getProject("TestEAR1");
        IProject earProject2 = ProjectUtil.createEARProject("TestEAR2");
        IProject utilProject = ProjectUtil.createUtilityProject("TestUtil", earProject1.getName());
        DependencyCreationUtil.createEARDependency(earProject2, utilProject);
        DependencyVerificationUtil.verifyEARDependency(earProject1, utilProject, false);
        DependencyVerificationUtil.verifyEARDependency(earProject2, utilProject, false);
        IProject newUtil = ProjectUtil.renameProject(utilProject, "newUtil");
        DependencyVerificationUtil.verifyEARDependencyChanged(earProject1, utilProject, newUtil);
        DependencyVerificationUtil.verifyEARDependencyChanged(earProject2, utilProject, newUtil);
    }

    public void testDeleteWithEARModuleDependency() throws Exception {
        IProject earProject = ProjectUtil.getProject("TestEAR");
        IProject utilProject = ProjectUtil.createUtilityProject("TestUtil", earProject.getName());
        IProject webProject = ProjectUtil.createWebProject("TestWeb", earProject.getName());
        DependencyCreationUtil.createModuleDependency(webProject, utilProject);
        DependencyVerificationUtil.verifyEARDependency(earProject, utilProject, false);
        DependencyVerificationUtil.verifyEARDependency(earProject, webProject, true);
        DependencyVerificationUtil.verifyModuleDependency(webProject, utilProject);
        ProjectUtil.deleteProject(utilProject);
        DependencyVerificationUtil.verifyEARDependencyRemoved(earProject, utilProject);
        DependencyVerificationUtil.verifyModuleDependencyRemoved(webProject, utilProject);
        DependencyVerificationUtil.verifyEARDependency(earProject, webProject, true);
    }

    public void testRenameWithMultipleEARModuleDependency() throws Exception {
        IProject earProject1 = ProjectUtil.getProject("TestEAR1");
        IProject earProject2 = ProjectUtil.createEARProject("TestEAR2");
        IProject ejbProject = ProjectUtil.createEJBProject("TestEJB", earProject1.getName());
        DependencyCreationUtil.createEARDependency(earProject2, ejbProject);
        IProject webProject1 = ProjectUtil.createWebProject("TestWeb1", earProject1.getName());
        IProject webProject2 = ProjectUtil.createWebProject("TestWeb2", earProject2.getName());
        DependencyCreationUtil.createModuleDependency(webProject1, ejbProject);
        DependencyCreationUtil.createWebLibDependency(webProject2, ejbProject);
        String moduleURI1 = DependencyVerificationUtil.verifyEARDependency(earProject1, ejbProject, true);
        String moduleURI2 = DependencyVerificationUtil.verifyEARDependency(earProject2, ejbProject, true);
        DependencyVerificationUtil.verifyEARDependency(earProject1, webProject1, true);
        DependencyVerificationUtil.verifyEARDependency(earProject2, webProject2, true);
        DependencyVerificationUtil.verifyModuleDependency(webProject1, ejbProject);
        DependencyVerificationUtil.verifyWebLibDependency(webProject2, ejbProject);
        IProject newEJB = ProjectUtil.renameProject(ejbProject, "newEJB");
        DependencyVerificationUtil.verifyEARDependencyChanged(earProject1, ejbProject, moduleURI1, newEJB);
        DependencyVerificationUtil.verifyEARDependencyChanged(earProject2, ejbProject, moduleURI2, newEJB);
        DependencyVerificationUtil.verifyModuleDependencyChanged(webProject1, ejbProject, newEJB);
        DependencyVerificationUtil.verifyWebLibDependencyChanged(webProject2, ejbProject, newEJB);
    }
}

