/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jst.validation.test.setup.IBuffer;
import org.eclipse.jst.validation.test.setup.ITestStatus;

public class TaskStatus
implements ITestStatus {
    private Map _elapsedTime = new HashMap();
    private Map _taskStatus = new HashMap();

    public void addElapsedTime(String taskName, long elapsedTime) {
        Long time = (Long)this._elapsedTime.get(taskName);
        time = time == null ? new Long(elapsedTime) : new Long(time + elapsedTime);
        this._elapsedTime.put(taskName, time);
    }

    public void addExecutionStatus(String taskName, boolean pass) {
        this.addExecutionStatus(taskName, null, pass);
    }

    public void addExecutionStatus(String taskName, String subTaskName, boolean pass) {
        int success = pass ? 0 : 2;
        this.addExecutionStatus(taskName, subTaskName, success, null, null);
    }

    public int numTests() {
        return this._taskStatus.size();
    }

    protected Map getElapsedTime() {
        return this._elapsedTime;
    }

    protected Map getTaskStatus() {
        return this._taskStatus;
    }

    public void addExecutionStatus(String testcaseName, String subTaskName, int severity, IBuffer buffer, String message) {
        TestStatus ts = this.getTestStatus(testcaseName);
        if (ts == null) {
            ts = new TestStatus(testcaseName);
            this._taskStatus.put(testcaseName, ts);
        }
        if (subTaskName == null) {
            ts.addExecutionStatus(severity);
        } else {
            ts.addExecutionStatus(subTaskName, severity);
        }
        if (message != null) {
            buffer.write(message);
        }
    }

    protected TestStatus getTestStatus(String testcaseName) {
        return (TestStatus)this._taskStatus.get(testcaseName);
    }

    public boolean isSuccessful() {
        if (this._taskStatus.size() == 0) {
            return true;
        }
        for (String tsName : this._taskStatus.keySet()) {
            TestStatus ts = (TestStatus)this._taskStatus.get(tsName);
            if (ts != null && ts.isSuccessful()) continue;
            return false;
        }
        return true;
    }

    public boolean isSuccessful(String testName) {
        if (this._taskStatus.size() == 0) {
            return true;
        }
        TestStatus ts = (TestStatus)this._taskStatus.get(testName);
        return ts != null && ts.isSuccessful();
    }

    public void clear() {
        this._taskStatus.clear();
        this._elapsedTime.clear();
    }

    protected class TestCount {
        public int numRan = 0;
        public int numWarn = 0;
        public int numFail = 0;
        public int numPass = 0;

        protected TestCount() {
        }
    }

    protected class TestStatus
    implements Comparator {
        private String _testcaseName = null;
        private Map _testStatus = null;

        public TestStatus(String name) {
            this._testcaseName = name;
            this._testStatus = new HashMap();
        }

        public void addExecutionStatus(String subTaskName, int severity) {
            TestCount soFar = (TestCount)this._testStatus.get(subTaskName);
            if (soFar == null) {
                soFar = new TestCount();
            }
            ++soFar.numRan;
            switch (severity) {
                case 1: {
                    ++soFar.numWarn;
                    ++soFar.numPass;
                    break;
                }
                case 2: {
                    ++soFar.numFail;
                    break;
                }
                case 0: {
                    ++soFar.numPass;
                }
            }
            this._testStatus.put(subTaskName, soFar);
        }

        public void addExecutionStatus(int severity) {
            this.addExecutionStatus(null, severity);
        }

        public String getTestcaseName() {
            return this._testcaseName;
        }

        public int numWarnings() {
            int numWarnings = 0;
            for (TestCount tc : this._testStatus.values()) {
                numWarnings += tc.numWarn;
            }
            return numWarnings;
        }

        public int numFailure() {
            int numFail = 0;
            for (TestCount tc : this._testStatus.values()) {
                numFail += tc.numFail;
            }
            return numFail;
        }

        public boolean isSuccessful() {
            for (TestCount tc : this._testStatus.values()) {
                if (tc.numFail == 0) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            int total = 0;
            int pass = 0;
            int fail = 0;
            int warn = 0;
            for (TestCount tc : this._testStatus.values()) {
                ++total;
                fail += tc.numFail;
                warn += tc.numWarn;
                pass += tc.numPass;
            }
            StringBuffer buffer = new StringBuffer(this.getTestcaseName());
            buffer.append(" Total:");
            buffer.append(total);
            buffer.append(" [Pass: ");
            buffer.append(pass);
            buffer.append(" Fail: ");
            buffer.append(fail);
            buffer.append(" Warn: ");
            buffer.append(warn);
            buffer.append("]");
            return buffer.toString();
        }

        public boolean equals(Object o) {
            if (o instanceof TestStatus) {
                TestStatus s = (TestStatus)o;
                return this._testcaseName.equals(s.getTestcaseName());
            }
            return false;
        }

        public int hashCode() {
            return this.getTestcaseName().hashCode();
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof TestStatus) && o2 instanceof TestStatus) {
                return 0;
            }
            TestStatus a = (TestStatus)o1;
            TestStatus b = (TestStatus)o2;
            return a.getTestcaseName().compareTo(b.getTestcaseName());
        }
    }
}

