/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import junit.framework.TestCase;
import org.eclipse.jst.jsp.core.internal.parser.internal.JSPTokenizer;

public class JSPTokenizerTest
extends TestCase {
    private JSPTokenizer tokenizer = null;

    private void reset(Reader in) {
        this.tokenizer.reset(in);
    }

    private void reset(String filename) {
        InputStreamReader fileReader = null;
        try {
            fileReader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(filename), "utf8");
        }
        catch (IOException e) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            JSPTokenizerTest.fail((String)s.toString());
        }
        BufferedReader reader = new BufferedReader(fileReader);
        this.reset(reader);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.tokenizer = new JSPTokenizer();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.tokenizer = null;
    }

    public void test144807_AttrName() {
        String input = "";
        int i = 0;
        while (i < 400) {
            input = String.valueOf(input) + "<a ";
            ++i;
        }
        try {
            this.reset(new StringReader(input));
            JSPTokenizerTest.assertTrue((String)"empty input", (this.tokenizer.getNextToken() != null ? 1 : 0) != 0);
            while (this.tokenizer.getNextToken() != null) {
            }
        }
        catch (IOException e) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            JSPTokenizerTest.fail((String)s.toString());
        }
    }

    public void test144807_AttrValue() {
        String input = "<a b=";
        int i = 0;
        while (i < 400) {
            input = String.valueOf(input) + "<a ";
            ++i;
        }
        try {
            this.reset(new StringReader(input));
            JSPTokenizerTest.assertTrue((String)"empty input", (this.tokenizer.getNextToken() != null ? 1 : 0) != 0);
            while (this.tokenizer.getNextToken() != null) {
            }
        }
        catch (IOException e) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            JSPTokenizerTest.fail((String)s.toString());
        }
    }

    public void test144807_Equals() {
        String input = "<a b";
        int i = 0;
        while (i < 400) {
            input = String.valueOf(input) + "<a ";
            ++i;
        }
        try {
            this.reset(new StringReader(input));
            JSPTokenizerTest.assertTrue((String)"empty input", (this.tokenizer.getNextToken() != null ? 1 : 0) != 0);
            while (this.tokenizer.getNextToken() != null) {
            }
        }
        catch (IOException e) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            JSPTokenizerTest.fail((String)s.toString());
        }
    }

    public void testInsertComment() {
        this.reset("jspcomment01.jsp");
        try {
            JSPTokenizerTest.assertTrue((String)"empty input", (this.tokenizer.getNextToken() != null ? 1 : 0) != 0);
            while (this.tokenizer.getNextToken() != null) {
            }
        }
        catch (IOException e) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            JSPTokenizerTest.fail((String)s.toString());
        }
        catch (StackOverflowError e) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            JSPTokenizerTest.fail((String)s.toString());
        }
        JSPTokenizerTest.assertTrue((boolean)true);
    }
}

