/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests;

import java.io.FileInputStream;
import java.util.Iterator;
import javax.wsdl.xml.WSDLReader;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.internal.impl.wsdl4j.WSDLFactoryImpl;
import org.eclipse.wst.wsdl.tests.WSDLTestsPlugin;
import org.eclipse.wst.wsdl.tests.util.DefinitionLoader;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.xml.sax.InputSource;

public class InlineSchemaTest
extends TestCase {
    private String PLUGIN_ABSOLUTE_PATH = WSDLTestsPlugin.getInstallURL();

    public InlineSchemaTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)InlineSchemaTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new InlineSchemaTest("InlineSchema"){

            protected void runTest() {
                this.testInlineSchema();
            }
        });
        suite.addTest((Test)new InlineSchemaTest("InlineSchemaWithWSDL4J"){

            protected void runTest() {
                this.testInlineSchemaWithWSDL4J();
            }
        });
        return suite;
    }

    public void testInlineSchema() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/LoadStoreCompare/LoadAndPrintTest.wsdl");
            this.traverseDefinition(definition);
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void testInlineSchemaWithWSDL4J() {
        try {
            Definition definition = this.loadDefinitionForWSDL4J("samples/LoadStoreCompare/LoadAndPrintTest.wsdl");
            this.traverseDefinition(definition);
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void traverseDefinition(Definition definition) throws Exception {
        Assert.assertNotNull((Object)definition);
        Iterator iter = definition.getEImports().iterator();
        while (iter.hasNext()) {
            Import myImport = (Import)iter.next();
            this.traverseImport(myImport);
        }
        Types types = (Types)definition.getTypes();
        Assert.assertNotNull((String)"<types> is null", (Object)types);
        if (types != null) {
            Iterator iterator = types.getSchemas().iterator();
            Assert.assertTrue((String)"<types> does not have inline <schema>s", (boolean)iterator.hasNext());
            while (iterator.hasNext()) {
                XSDSchema schema = (XSDSchema)iterator.next();
                this.traverseSchema(schema);
            }
        }
    }

    private void traverseImport(Import myImport) throws Exception {
    }

    private void traverseSchema(XSDSchema schema) {
        Iterator iterator = schema.getElementDeclarations().iterator();
        XSDElementDeclaration elementDecl = null;
        Assert.assertTrue((String)"No <element>s are found", (boolean)iterator.hasNext());
        while (iterator.hasNext()) {
            elementDecl = (XSDElementDeclaration)iterator.next();
            if (elementDecl.getName().equals("NewOperationResponse")) {
                this.traverseElementDecl(elementDecl);
                continue;
            }
            if (!elementDecl.getName().equals("NewOperationRequest")) continue;
            this.traverseElementDecl(elementDecl);
        }
    }

    private void traverseElementDecl(XSDElementDeclaration elementDecl) {
        XSDTypeDefinition type = elementDecl.getTypeDefinition();
        Assert.assertTrue((String)"<element> does not have <simpleType>", (boolean)(type instanceof XSDSimpleTypeDefinition));
        if (type.getComplexType() == null) {
            return;
        }
        XSDParticleContent content = type.getComplexType().getContent();
        this.traverseModelGroup((XSDModelGroup)content);
    }

    private void traverseModelGroup(XSDModelGroup modelGroup) {
        Iterator iterator = modelGroup.getContents().iterator();
        XSDParticleContent particleContent = null;
        while (iterator.hasNext()) {
            particleContent = ((XSDParticle)iterator.next()).getContent();
            if (!(particleContent instanceof XSDElementDeclaration)) continue;
            if (((XSDElementDeclaration)particleContent).isElementDeclarationReference()) {
                this.traverseElementDecl(((XSDElementDeclaration)particleContent).getResolvedElementDeclaration());
                continue;
            }
            this.traverseElementDecl((XSDElementDeclaration)particleContent);
        }
    }

    private Definition loadDefinitionForWSDL4J(String wsdlFile) throws Exception {
        WSDLReader reader = new WSDLFactoryImpl().newWSDLReader();
        String s = String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + wsdlFile;
        Definition definition = (Definition)reader.readWSDL(s, new InputSource(new FileInputStream(s)));
        return definition;
    }
}

