/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.emftests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.jem.java.JavaRefPackage;
import org.eclipse.jst.j2ee.archive.emftests.GeneralEMFTest;
import org.eclipse.jst.j2ee.archive.testutilities.EAttributeDescriptor;
import org.eclipse.jst.j2ee.archive.testutilities.EMFAttributeFeatureGenerator;
import org.eclipse.jst.j2ee.archive.testutilities.J2EEVersionCheck;
import org.eclipse.jst.j2ee.archive.testutilities.TestUtilities;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.EJBLocalRef;
import org.eclipse.jst.j2ee.common.QName;
import org.eclipse.jst.j2ee.common.ResAuthTypeBase;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.MessageDriven;
import org.eclipse.jst.j2ee.ejb.MethodElementKind;
import org.eclipse.wst.common.internal.emf.resource.RendererFactory;

public class GeneralEMFPopulationTest
extends GeneralEMFTest {
    protected Map equivalentLines;
    public List deferedReferences;
    public static int genDepth = 5;
    public static Object sharedValue;
    public static HashSet ignoreAtt;
    public int version;
    public int moduleType;
    public static final int VERSION_1_2 = 0;
    public static final int VERSION_1_3 = 1;
    public static final int VERSION_1_4 = 2;
    public static final int VERSION_5_0 = 3;
    public static final int APPLICATION = 0;
    public static final int APP_CLIENT = 1;
    public static final int CONNECTOR = 2;
    public static final int EJB = 3;
    public static final int WEB = 4;

    public GeneralEMFPopulationTest(String name) {
        super(name);
    }

    public GeneralEMFPopulationTest(String name, RendererFactory factory) {
        super(name, factory);
    }

    public void populateRoot(EObject eObject) {
        this.populateFeatures(eObject);
        if (this.deferedReferences != null) {
            int i = 0;
            while (i < this.deferedReferences.size()) {
                ((DeferredSharedReferenceAction)this.deferedReferences.get(i)).performAction();
                ++i;
            }
        }
    }

    public void populateFeatures(EObject eObject) {
        if (eObject == null) {
            return;
        }
        this.populateAttributes(eObject);
        this.populateReferences(eObject);
    }

    protected void populateReferences(EObject eObject) {
        EList references = eObject.eClass().getEAllReferences();
        int i = 0;
        while (i < references.size()) {
            EReference ref = (EReference)references.get(i);
            if (!(!ref.isMany() && eObject.eGet((EStructuralFeature)ref) != null || eObject instanceof MessageDriven && (ref.equals(EjbPackage.eINSTANCE.getEnterpriseBean_HomeInterface()) || ref.equals(EjbPackage.eINSTANCE.getEnterpriseBean_RemoteInterface()) || ref.equals(EjbPackage.eINSTANCE.getEnterpriseBean_LocalInterface()) || ref.equals(EjbPackage.eINSTANCE.getEnterpriseBean_LocalHomeInterface()) || ref.equals(EjbPackage.eINSTANCE.getEnterpriseBean_SecurityRoleRefs())))) {
                if (ref.isContainment()) {
                    this.populateContainmentReference(eObject, ref);
                } else {
                    this.populateSharedReference(eObject, ref);
                }
            }
            ++i;
        }
    }

    protected void populateSharedReference(EObject eObject, EReference ref) {
        if (ref.getEType() == JavaRefPackage.eINSTANCE.getJavaClass()) {
            this.setReferenceValue(eObject, (EStructuralFeature)ref, EMFAttributeFeatureGenerator.createJavaClassProxy((EStructuralFeature)ref, eObject));
        } else {
            ref.getEType().getEPackage();
            if (eObject.eClass().getName().equals("EAnnotation") || eObject.eClass().getName().equals("EAnnotationImpl") || !J2EEVersionCheck.checkReferenceVersion((EStructuralFeature)ref, this.version, this.moduleType)) {
                return;
            }
            if (this.deferedReferences == null) {
                this.deferedReferences = new ArrayList();
            }
            this.deferedReferences.add(new DeferredSharedReferenceAction(eObject, ref));
        }
    }

    protected void populateContainmentReference(EObject eObject, EReference ref) {
        int i = 0;
        while (i < this.getDepthForAttribute((EStructuralFeature)ref)) {
            EObject instance = this.createInstance(ref, eObject);
            if (instance == null) {
                return;
            }
            if (J2EEVersionCheck.checkReferenceVersion((EStructuralFeature)ref, this.version, this.moduleType)) {
                this.setReferenceValue(eObject, (EStructuralFeature)ref, instance);
                if (((InternalEObject)instance).eIsProxy()) {
                    return;
                }
                if (ref.getEType() == eObject.eClass()) {
                    this.populateAttributes(instance);
                } else {
                    this.populateFeatures(instance);
                }
            }
            ++i;
        }
    }

    protected void setReferenceValue(EObject eObject, EStructuralFeature ref, Object value) {
        if (ref.getName().equals("EAnnotation") || ref.getName().equals("EAnnotationImpl") || !J2EEVersionCheck.checkReferenceVersion(ref, this.version, this.moduleType)) {
            return;
        }
        if (ref.isMany()) {
            List list = (List)eObject.eGet(ref);
            if (list instanceof BasicFeatureMap) {
                BasicFeatureMap aMap = (BasicFeatureMap)list;
                if (value instanceof Collection) {
                    Iterator iterator = ((Collection)value).iterator();
                    while (iterator.hasNext()) {
                        Object obj = iterator.next();
                        aMap.add(FeatureMapUtil.createEntry((EStructuralFeature)ref, obj));
                    }
                } else {
                    aMap.add(FeatureMapUtil.createEntry((EStructuralFeature)ref, (Object)value));
                }
            } else if (value instanceof Collection) {
                list.addAll((Collection)value);
            } else {
                list.add(value);
            }
        } else {
            eObject.eSet(ref, value);
        }
    }

    public EObject createInstance(EReference ref, EObject eObject) {
        if (ref.getEType() == JavaRefPackage.eINSTANCE.getJavaClass()) {
            return EMFAttributeFeatureGenerator.createJavaClassProxy((EStructuralFeature)ref, eObject);
        }
        return ref.getEType().getEPackage().getEFactoryInstance().create((EClass)ref.getEType());
    }

    protected void populateAttributes(EObject eObject) {
        if (eObject.eClass() == CommonPackage.eINSTANCE.getQName()) {
            this.populateAttributesQName(eObject);
            return;
        }
        EList attributes = eObject.eClass().getEAllAttributes();
        int i = 0;
        while (i < attributes.size()) {
            EAttributeDescriptor desc;
            EAttribute att = (EAttribute)attributes.get(i);
            if (!(eObject instanceof EJBLocalRef && (att.equals(CommonPackage.eINSTANCE.getEjbRef_Home()) || att.equals(CommonPackage.eINSTANCE.getEjbRef_Remote())) || (desc = new EAttributeDescriptor((EStructuralFeature)att, eObject.eClass())).getFeature().getName().equals("group"))) {
                this.primPopulateAttrbute(eObject, att);
            }
            ++i;
        }
    }

    protected void primPopulateAttrbute(EObject eObject, EAttribute att) {
        if (att.isChangeable() && J2EEVersionCheck.checkAttributeVersion(att, this.version, this.moduleType)) {
            int j = 0;
            while (j < this.getDepthForAttribute((EStructuralFeature)att)) {
                Object value = this.createAttributeValue(att, eObject);
                this.setReferenceValue(eObject, (EStructuralFeature)att, value);
                ++j;
            }
        }
    }

    protected void populateAttributesQName(EObject eObject) {
        String prefix = (String)this.createAttributeValue(CommonPackage.eINSTANCE.getQName_InternalPrefixOrNsURI(), eObject);
        String localPart = (String)this.createAttributeValue(CommonPackage.eINSTANCE.getQName_LocalPart(), eObject);
        ((QName)eObject).setValues(prefix, "http://www.ibm.com", localPart);
    }

    protected Object createAttributeValue(EAttribute att, EObject eObject) {
        if (att.getEType() == JavaRefPackage.eINSTANCE.getJavaClass()) {
            return EMFAttributeFeatureGenerator.createJavaClassProxy((EStructuralFeature)att, eObject).getClass();
        }
        if (att == CommonPackage.eINSTANCE.getResourceRef_Auth()) {
            return this.createResAuth(att, eObject);
        }
        if (att == EjbPackage.eINSTANCE.getMethodElement_Type()) {
            return this.createMethodElementType(att, eObject);
        }
        return this.primCreateAttributeValue(att, eObject);
    }

    protected Object primCreateAttributeValue(EAttribute att, EObject eObject) {
        return EMFAttributeFeatureGenerator.createAttribute(att, eObject, true, this.version, this.moduleType);
    }

    public void compareContents(String file1, String file2) throws Exception {
        try {
            int lineno = 1;
            BufferedReader reader1 = new BufferedReader(new InputStreamReader(this.getFileInputStream(file1)));
            BufferedReader reader2 = new BufferedReader(new InputStreamReader(this.getFileInputStream(file2)));
            String line1 = "";
            String line2 = "";
            while (reader1.ready() && reader2.ready()) {
                line1 = reader1.readLine();
                line2 = reader2.readLine();
                if (line1 == null && line2 == null && lineno != 0) {
                    return;
                }
                if (!line1.equals(line2)) {
                    String message = "Error at line #: " + lineno + '\n' + line1 + '\n' + line2 + '\n';
                    GeneralEMFPopulationTest.assertTrue((String)message, (boolean)false);
                    break;
                }
                ++lineno;
            }
            GeneralEMFPopulationTest.assertTrue((String)("The files have a different number of lines:" + lineno + '\n' + line1 + '\n' + line2 + '\n'), (!reader1.ready() && !reader2.ready() ? 1 : 0) != 0);
        }
        catch (IOException iOException) {
            GeneralEMFPopulationTest.assertTrue((String)"IO failed", (boolean)false);
        }
    }

    public void compareContentsIgnoreWhitespace(String file1, String file2, String identifier) throws Exception {
        LineNumberReader reader1 = new LineNumberReader(new InputStreamReader(this.getFileInputStream(file1)));
        LineNumberReader reader2 = new LineNumberReader(new InputStreamReader(this.getFileInputStream(file2)));
        this.compareContentsIgnoreWhitespace(reader1, reader2, identifier);
    }

    public void compareContentsIgnoreWhitespace(LineNumberReader reader1, LineNumberReader reader2, String identifier) throws Exception {
        ArrayList<StringBuffer> errors = new ArrayList<StringBuffer>();
        while (reader1.ready() || reader2.ready()) {
            String line1 = "";
            String line2 = "";
            while (reader1.ready() && line1 != null && line1.equals("")) {
                line1 = reader1.readLine();
                if (line1 == null) continue;
                line1 = line1.trim();
            }
            while (reader2.ready() && line2 != null && line2.equals("")) {
                line2 = reader2.readLine();
                if (line2 == null) continue;
                line2 = line2.trim();
            }
            if (line1 == null || line2 == null || this.isEquivalentLines(line1, line2)) continue;
            StringBuffer buff = new StringBuffer();
            buff.append("------------------------------ ");
            buff.append("\nSource line #: ");
            buff.append(reader1.getLineNumber());
            buff.append('\n');
            buff.append(line1);
            buff.append("\nDestination line #: ");
            buff.append(reader2.getLineNumber());
            buff.append('\n');
            buff.append(line2);
            System.out.println(buff.toString());
            errors.add(buff);
            break;
        }
        if (!errors.isEmpty()) {
            GeneralEMFPopulationTest.assertTrue((String)"Errors Found, Check Console.", (boolean)false);
        }
    }

    public boolean lineEquals(String line1, String line2) {
        return line1 != null && line1.equals(line2);
    }

    public boolean isEquivalentLines(String line1, String line2) {
        if (this.lineEquals(line1, line2)) {
            return true;
        }
        String equiv = (String)this.getEquivalentLines().get(line1);
        if (equiv == null && (equiv = (String)this.getEquivalentLines().get(line2)) != null) {
            return equiv.equals(line1);
        }
        return equiv != null && equiv.equals(line2);
    }

    public Map getEquivalentLines() {
        if (this.equivalentLines == null) {
            this.equivalentLines = new HashMap();
        }
        return this.equivalentLines;
    }

    public void setEquivalentLines(Map equivalentLines) {
        this.equivalentLines = equivalentLines;
    }

    public InputStream getFileInputStream(String path) throws FileNotFoundException {
        return new FileInputStream(path);
    }

    public InputStream getResourceAsStream(String fileName) {
        InputStream in = null;
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        in = loader == null ? ClassLoader.getSystemResourceAsStream(fileName) : loader.getResourceAsStream(fileName);
        GeneralEMFPopulationTest.assertTrue((String)("Unable to find resource: " + fileName), (in != null ? 1 : 0) != 0);
        return in;
    }

    public void setGeneralDepth(int depth) {
        genDepth = depth;
    }

    public void setModuleType(int type) {
        this.moduleType = type;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getDepthForAttribute(EStructuralFeature feature) {
        if (feature.isMany()) {
            return genDepth;
        }
        return 1;
    }

    public Object getSharedObjectByType(EObject owner, EReference ref) {
        sharedValue = TestUtilities.getObjectByType(owner.eResource(), ref.getEType(), ref.isMany());
        return sharedValue;
    }

    public static void setIgnoreAtt(HashSet set) {
        ignoreAtt = set;
    }

    protected Object createResAuth(EAttribute att, EObject eObject) {
        Object auth = null;
        while (!this.isValidAuth((ResAuthTypeBase)(auth = this.primCreateAttributeValue(att, eObject)))) {
        }
        return auth;
    }

    protected boolean isValidAuth(ResAuthTypeBase auth) {
        return auth == ResAuthTypeBase.APPLICATION_LITERAL || auth == ResAuthTypeBase.CONTAINER_LITERAL;
    }

    protected Object createMethodElementType(EAttribute att, EObject eObject) {
        Object type = null;
        while (!this.isValidMethodElementType((MethodElementKind)(type = this.primCreateAttributeValue(att, eObject)))) {
        }
        return type;
    }

    protected boolean isValidMethodElementType(MethodElementKind type) {
        if (this.version == 2) {
            return true;
        }
        return this.version != 2 && type != MethodElementKind.SERVICE_ENDPOINT_LITERAL;
    }

    protected void tearDown() throws Exception {
        try {
            String out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/";
            File del = new File(out);
            this.deleteDirectory(del);
            del.delete();
            out = String.valueOf(AutomatedBVT.baseDirectory) + "../testData/testOutput/";
            del = new File(out);
            this.deleteDirectory(del);
            del.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.tearDown();
    }

    protected void deleteDirectory(File directory) throws IOException {
        if (directory.exists()) {
            File[] delFiles = directory.listFiles();
            int i = 0;
            while (i < delFiles.length) {
                if (delFiles[i].isDirectory()) {
                    this.deleteDirectory(delFiles[i]);
                }
                delFiles[i].delete();
                ++i;
            }
        }
    }

    protected class DeferredSharedReferenceAction {
        EObject owner;
        EReference ref;

        public DeferredSharedReferenceAction(EObject owner, EReference ref) {
            this.owner = owner;
            this.ref = ref;
        }

        public void performAction() {
            Object value = GeneralEMFPopulationTest.this.getSharedObjectByType(this.owner, this.ref);
            GeneralEMFPopulationTest.this.setReferenceValue(this.owner, (EStructuralFeature)this.ref, value);
        }
    }
}

