/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.test;

import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ReadOnlyDirectory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;

public class CopyTests
extends TestCase {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    static /* synthetic */ Class class$0;

    public CopyTests(String name) {
        super(name);
    }

    public CommonarchiveFactory getArchiveFactory() {
        return CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
    }

    public EjbFactory getEJBFactory() {
        return EjbPackage.eINSTANCE.getEjbFactory();
    }

    public EjbPackage getEJBPackage() {
        return EjbPackage.eINSTANCE;
    }

    public WebapplicationFactory getWebFactory() {
        return WebapplicationPackage.eINSTANCE.getWebapplicationFactory();
    }

    public static void main(String[] args) {
        String[] className = new String[]{"com.ibm.etools.archive.test.CopyTests", "-noloading"};
        TestRunner.main((String[])className);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.archive.test.CopyTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void testAddCopyDirectory() throws Exception {
        WARFile aWarFile = (WARFile)this.getArchiveFactory().openArchive(String.valueOf(AutomatedBVT.baseDirectory) + "example2.war");
        ReadOnlyDirectory sampleDirectory = this.getArchiveFactory().openReadOnlyDirectory(String.valueOf(AutomatedBVT.baseDirectory) + "WarTestClasses");
        int initialSize = aWarFile.getFiles().size();
        aWarFile.addCopy(sampleDirectory);
        Iterator iter = aWarFile.getFiles().iterator();
        while (iter.hasNext()) {
            String uri = ((File)iter.next()).getURI();
            if (uri.indexOf("CVS") < 0) continue;
            iter.remove();
        }
        CopyTests.assertTrue((String)"Wrong number of files ", (aWarFile.getFiles().size() == initialSize + 7 ? 1 : 0) != 0);
        aWarFile.saveAsNoReopen(String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/CopyTests/addCopyDir.war");
    }

    public void testAddCopyModule() throws Exception {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "sample.ear";
        EARFile earFile = (EARFile)this.getArchiveFactory().openArchive(in);
        EList modules = earFile.getDeploymentDescriptor().getModules();
        EJBJarFile ejbJarFile = null;
        int i = 0;
        while (i < modules.size()) {
            Module aModule = (Module)modules.get(i);
            if (aModule.isEjbModule()) {
                ejbJarFile = (EJBJarFile)earFile.getFile(aModule.getUri());
                break;
            }
            ++i;
        }
        CopyTests.assertTrue((String)"EJBJarFile should not be null", (ejbJarFile != null ? 1 : 0) != 0);
        ejbJarFile.getDeploymentDescriptor();
        EARFile newEarFile = this.getArchiveFactory().createEARFileInitialized(String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/CopyTests/newEarWithCopiedModule.ear");
        newEarFile.addCopy((ModuleFile)ejbJarFile);
        EJBJarFile copied = (EJBJarFile)newEarFile.getModuleFiles().get(0);
        CopyTests.assertTrue((boolean)copied.isDeploymentDescriptorSet());
        CopyTests.assertTrue((copied.getDeploymentDescriptor() == copied.getDeploymentDescriptorResource().getContents().get(0) ? 1 : 0) != 0);
        CopyTests.assertTrue((copied.getDeploymentDescriptor() != ejbJarFile.getDeploymentDescriptor() ? 1 : 0) != 0);
        CopyTests.assertTrue((ejbJarFile.getFiles().size() == copied.getFiles().size() ? 1 : 0) != 0);
        newEarFile.saveNoReopen();
    }

    public void testAddCopyModuleFilesToEAR() throws Exception {
        String uri = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/CopyTests/testAddCopyModuleFilesToEAR.ear";
        EARFile earFile = this.getArchiveFactory().createEARFileInitialized(uri);
        earFile.setJ2EEVersion(13);
        earFile.getDeploymentDescriptor().setDisplayName(uri);
        EJBJarFile ejbJarFile = this.getArchiveFactory().openEJBJarFile(String.valueOf(AutomatedBVT.baseDirectory) + "bankejbs.jar");
        earFile.addCopy((ModuleFile)ejbJarFile);
        WARFile warFile = this.getArchiveFactory().openWARFile(String.valueOf(AutomatedBVT.baseDirectory) + "example2.war");
        earFile.addCopy((ModuleFile)warFile);
        ((WebModule)earFile.getDeploymentDescriptor().getFirstModule(warFile.getURI())).setContextRoot("/");
        earFile.save();
        ejbJarFile = (EJBJarFile)earFile.getEJBJarFiles().get(0);
        CopyTests.assertTrue((String)"ejb dd resource not right", (ejbJarFile.getDeploymentDescriptor().eResource() == ejbJarFile.getDeploymentDescriptorResource() ? 1 : 0) != 0);
        warFile = (WARFile)earFile.getWARFiles().get(0);
        CopyTests.assertTrue((String)"war dd resource not right", (warFile.getDeploymentDescriptor().eResource() == warFile.getDeploymentDescriptorResource() ? 1 : 0) != 0);
        earFile.saveNoReopen();
        earFile.close();
    }

    public void testAddCopyStandaloneModule() throws Exception {
        String fileName = String.valueOf(AutomatedBVT.baseDirectory) + "bankejbs.jar";
        EJBJarFile ejbJarFile = (EJBJarFile)this.getArchiveFactory().openArchive(fileName);
        ejbJarFile.getDeploymentDescriptor();
        EARFile newEarFile = this.getArchiveFactory().createEARFileInitialized(String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/CopyTests/newEarWithStandAloneModule-out.ear");
        newEarFile.addCopy((ModuleFile)ejbJarFile);
        EJBJarFile copied = (EJBJarFile)newEarFile.getModuleFiles().get(0);
        CopyTests.assertTrue((boolean)copied.isDeploymentDescriptorSet());
        CopyTests.assertTrue((copied.getDeploymentDescriptor() == copied.getDeploymentDescriptorResource().getContents().get(0) ? 1 : 0) != 0);
        CopyTests.assertTrue((copied.getDeploymentDescriptor() != ejbJarFile.getDeploymentDescriptor() ? 1 : 0) != 0);
        CopyTests.assertTrue((ejbJarFile.getFiles().size() == copied.getFiles().size() ? 1 : 0) != 0);
        newEarFile.saveNoReopen();
    }

    public void testAddRenameAndDelete() throws Exception {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "sample.ear";
        EARFile earFile = (EARFile)this.getArchiveFactory().openArchive(in);
        EList modules = earFile.getDeploymentDescriptor().getModules();
        EJBJarFile ejbJarFile = null;
        int i = 0;
        while (i < modules.size()) {
            Module aModule = (Module)modules.get(i);
            if (aModule.isEjbModule()) {
                ejbJarFile = (EJBJarFile)earFile.getFile(aModule.getUri());
                break;
            }
            ++i;
        }
        CopyTests.assertTrue((String)"EJBJarFile should not be null", (ejbJarFile != null ? 1 : 0) != 0);
        ejbJarFile.getDeploymentDescriptor();
        EARFile newEarFile = this.getArchiveFactory().createEARFileInitialized(String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/CopyTests/newEarWithCopiedModule.ear");
        EJBModuleRef addedCopy = (EJBModuleRef)newEarFile.addCopyRef((ModuleFile)ejbJarFile);
        CopyTests.assertTrue((String)"Module files should not be empty", (!newEarFile.getModuleFiles().isEmpty() ? 1 : 0) != 0);
        CopyTests.assertTrue((String)"Modules should not be empty", (!newEarFile.getDeploymentDescriptor().getModules().isEmpty() ? 1 : 0) != 0);
        CopyTests.assertTrue((String)"Module should be accessible and have the same uri as file", (boolean)addedCopy.getModule().getUri().equals(addedCopy.getModuleFile().getURI()));
        String newURI = "temp/foobar.jar";
        addedCopy.setURI(newURI);
        CopyTests.assertTrue((String)"Module should be accessible and have the new renamed uri as well as the file", (addedCopy.getModule().getUri().equals(addedCopy.getModuleFile().getURI()) && addedCopy.getModule().getUri().equals(newURI) ? 1 : 0) != 0);
        newEarFile.remove((ModuleRef)addedCopy);
        CopyTests.assertTrue((String)"Module files should be empty", (boolean)newEarFile.getModuleFiles().isEmpty());
        CopyTests.assertTrue((String)"Modules should be empty", (boolean)newEarFile.getDeploymentDescriptor().getModules().isEmpty());
    }

    public void testAddRenameAndDeleteStandalone() throws Exception {
        String fileName = String.valueOf(AutomatedBVT.baseDirectory) + "bankejbs.jar";
        EJBJarFile ejbJarFile = (EJBJarFile)this.getArchiveFactory().openArchive(fileName);
        EARFile newEarFile = this.getArchiveFactory().createEARFileInitialized(String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/CopyTests/newEarWithCopiedModule.ear");
        EJBModuleRef addedCopy = (EJBModuleRef)newEarFile.addCopyRef((ModuleFile)ejbJarFile);
        CopyTests.assertTrue((String)"Module files should not be empty", (!newEarFile.getModuleFiles().isEmpty() ? 1 : 0) != 0);
        CopyTests.assertTrue((String)"Modules should not be empty", (!newEarFile.getDeploymentDescriptor().getModules().isEmpty() ? 1 : 0) != 0);
        CopyTests.assertTrue((String)"Module should be accessible and have the same uri as file", (boolean)addedCopy.getModule().getUri().equals(addedCopy.getModuleFile().getURI()));
        String newURI = "temp/foobar.jar";
        addedCopy.setURI(newURI);
        CopyTests.assertTrue((String)"Module should be accessible and have the new renamed uri as well as the file", (addedCopy.getModule().getUri().equals(addedCopy.getModuleFile().getURI()) && addedCopy.getModule().getUri().equals(newURI) ? 1 : 0) != 0);
        newEarFile.remove((ModuleRef)addedCopy);
        CopyTests.assertTrue((String)"Module files should be empty", (boolean)newEarFile.getModuleFiles().isEmpty());
        CopyTests.assertTrue((String)"Modules should be empty", (boolean)newEarFile.getDeploymentDescriptor().getModules().isEmpty());
    }
}

