/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.testutilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jem.java.internal.impl.JavaClassImpl;
import org.eclipse.jst.j2ee.archive.testutilities.EAttributeDescriptor;
import org.eclipse.jst.j2ee.archive.testutilities.J2EEVersionCheck;
import org.eclipse.jst.j2ee.archive.testutilities.TestUtilities;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;

public class EMFAttributeFeatureGenerator {
    public static String[] avClass;
    protected static int count;
    protected static Random randomGenerator;
    protected static int maxNumberOfProjectsCreated;
    protected static Map enumMap;
    protected static int paramCount;
    protected static String[] langArray;
    protected static int langCount;
    protected static Map booleanMap;
    protected static Map attIndex;
    protected static boolean specialNumberGen;
    protected static String[] httpArray;
    protected static int httpArrayIndex;
    public static int version;
    public static int moduleType;
    public static final int VERSION_1_2 = 0;
    public static final int VERSION_1_3 = 1;
    public static final int VERSION_1_4 = 2;
    public static final int APPICATION = 0;
    public static final int APP_CLIENT = 1;
    public static final int CONNECTOR = 2;
    public static final int EJB = 3;
    public static final int WEB = 4;
    protected static char[] intToCharMapping;
    protected static char[] charToIntMapping;

    static {
        count = 0;
        randomGenerator = new Random();
        maxNumberOfProjectsCreated = 1000;
        enumMap = new HashMap();
        langArray = new String[]{"EN", "FR", "DE", "JP", "CN", "BR", "SP"};
        langCount = 0;
        booleanMap = new HashMap();
        attIndex = new HashMap();
        specialNumberGen = false;
        httpArray = null;
        httpArrayIndex = 0;
        intToCharMapping = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j'};
        charToIntMapping = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    }

    public static void resetCount() {
        count = 0;
    }

    public static Object createAttribute(EAttribute att, EObject obj) {
        return EMFAttributeFeatureGenerator.createAttribute(new EAttributeDescriptor((EStructuralFeature)att, obj.eClass()));
    }

    public static Object createAttribute(EAttribute att, EClass eClass) {
        return EMFAttributeFeatureGenerator.createAttribute(new EAttributeDescriptor((EStructuralFeature)att, eClass));
    }

    public static Object createAttribute(EAttribute att, EObject obj, boolean special) {
        specialNumberGen = special;
        return EMFAttributeFeatureGenerator.createAttribute(new EAttributeDescriptor((EStructuralFeature)att, obj.eClass()));
    }

    public static Object createAttribute(EAttribute att, EObject obj, boolean special, int ver, int modType) {
        specialNumberGen = special;
        version = ver;
        moduleType = modType;
        return EMFAttributeFeatureGenerator.createAttribute(new EAttributeDescriptor((EStructuralFeature)att, obj.eClass()));
    }

    protected static Object createAttribute(EAttributeDescriptor att) {
        EClassifier meta = att.getFeature().getEType();
        if (meta instanceof EEnum && att.getFeature().isMany()) {
            ArrayList<Object> collection = new ArrayList<Object>();
            collection.add(EMFAttributeFeatureGenerator.createEnum(att));
            return collection;
        }
        if (meta instanceof EEnum) {
            return EMFAttributeFeatureGenerator.createEnum(att);
        }
        if ((version == 1 || version == 0) && att.getFeature().equals(WebapplicationPackage.eINSTANCE.getHTTPMethodType_HttpMethod())) {
            return EMFAttributeFeatureGenerator.createSpecialHttpMethodsFor13();
        }
        if (version == 1 && att.getFeature().equals(CommonPackage.eINSTANCE.getEJBLocalRef_Local())) {
            return EMFAttributeFeatureGenerator.generateRandomAttributeString(new EAttributeDescriptor((EStructuralFeature)CommonPackage.eINSTANCE.getEjbRef_Remote(), att.getMetaClass()));
        }
        if (version == 1 && att.getFeature().equals(CommonPackage.eINSTANCE.getEJBLocalRef_LocalHome())) {
            return EMFAttributeFeatureGenerator.generateRandomAttributeString(new EAttributeDescriptor((EStructuralFeature)CommonPackage.eINSTANCE.getEjbRef_Home(), att.getMetaClass()));
        }
        if (att.getFeature().getName().equals("parms")) {
            return EMFAttributeFeatureGenerator.createParams(att);
        }
        if (att.getFeature().getName().startsWith("location") && version == 2) {
            return EMFAttributeFeatureGenerator.createLocation(att);
        }
        if (att.getFeature().getName().startsWith("locale") && version == 2) {
            return EMFAttributeFeatureGenerator.createLocale();
        }
        if (att.getFeature().getName().equals("lang")) {
            return EMFAttributeFeatureGenerator.createLang(att);
        }
        if (att.getFeature().getName().equals("version")) {
            if (att.getFeature() == EjbPackage.eINSTANCE.getContainerManagedEntity_Version()) {
                return "2.x";
            }
            return EMFAttributeFeatureGenerator.createVersion(att);
        }
        if (att.getFeature().getName().equals("mimeType") && version == 2) {
            return "text/plain";
        }
        if (att.getFeature().getName().equals("errorCode") && version == 2) {
            return "404";
        }
        if (att.getFeature().getName().equals("formLoginPage") && version == 2) {
            return "/testFormLoginPage";
        }
        if (att.getFeature().getName().equals("formErrorPage") && version == 2) {
            return "/testFormErrorpage";
        }
        if (att.getFeature().getName().equals("link") && version == 2) {
            return "roleName_0";
        }
        if (att.getFeature().getName().equals("specVersion") && version == 2) {
            return "1.5";
        }
        if (att.getFeature().isMany()) {
            return EMFAttributeFeatureGenerator.createCollection(att);
        }
        if (meta.getInstanceClassName().equals("java.lang.String")) {
            return EMFAttributeFeatureGenerator.generateRandomAttributeString(att);
        }
        if (meta.getInstanceClassName().equals("boolean")) {
            return EMFAttributeFeatureGenerator.generateRandomBoolean(att);
        }
        if (meta.getInstanceClassName().equals("java.util.List")) {
            return EMFAttributeFeatureGenerator.createCollection(att);
        }
        if (meta.getName().equals("QName")) {
            return EMFAttributeFeatureGenerator.generateRandomQName(att);
        }
        switch (meta.getClassifierID()) {
            case 50: {
                return EMFAttributeFeatureGenerator.generateRandomAttributeString(att);
            }
            case 22: 
            case 23: {
                return EMFAttributeFeatureGenerator.generateRandomBoolean(att);
            }
            case 39: 
            case 40: {
                return EMFAttributeFeatureGenerator.generateRandomInteger(att);
            }
            case 37: 
            case 38: {
                return EMFAttributeFeatureGenerator.generateRandomFloat(att);
            }
            case 27: 
            case 28: {
                return EMFAttributeFeatureGenerator.generateRandomChar(att);
            }
            case 43: 
            case 44: {
                return EMFAttributeFeatureGenerator.generateRandomLong();
            }
            case 24: 
            case 26: {
                return EMFAttributeFeatureGenerator.generateRandomByte();
            }
            case 31: 
            case 32: {
                return EMFAttributeFeatureGenerator.generateRandomDouble();
            }
            case 48: 
            case 49: {
                return EMFAttributeFeatureGenerator.generateRandomShort(att);
            }
            case 42: {
                return EMFAttributeFeatureGenerator.generateRandomObject(att);
            }
        }
        return null;
    }

    private static Object createLocale() {
        return "en_US";
    }

    private static Object createLocation(EAttributeDescriptor att) {
        String temp = EMFAttributeFeatureGenerator.generateRandomAttributeString(att);
        return "/." + temp;
    }

    public static EObject createJavaClassProxy(EStructuralFeature ref, EObject eObject) {
        EAttributeDescriptor feature;
        if (avClass == null) {
            avClass = new String[]{"java.util.HashTable", "java.util.List", "java.sql.Data", "java.lang.Integer", "java.lang.String"};
        }
        if (!attIndex.containsKey(feature = new EAttributeDescriptor(ref, eObject.eClass()))) {
            attIndex.put(feature, new Integer(0));
        }
        int classIndex = (Integer)attIndex.get(feature);
        String name = avClass[classIndex];
        if (++classIndex == 5) {
            classIndex = 0;
        }
        attIndex.put(feature, new Integer(classIndex));
        return JavaClassImpl.createClassRef((String)name);
    }

    protected static Object createSpecialHttpMethodsFor13() {
        if (httpArray == null) {
            httpArray = new String[]{"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "TRACE"};
        }
        if (httpArrayIndex >= httpArray.length) {
            httpArrayIndex = 0;
        }
        String holder = httpArray[httpArrayIndex];
        ++httpArrayIndex;
        return holder;
    }

    protected static String createVersion(EAttributeDescriptor att) {
        String versionHolder = "";
        switch (moduleType) {
            case 0: {
                if (version == 0) {
                    versionHolder = "1.2";
                    break;
                }
                if (version == 1) {
                    versionHolder = "1.3";
                    break;
                }
                if (version == 2) {
                    versionHolder = "1.4";
                    break;
                }
                versionHolder = "5.0";
                break;
            }
            case 1: {
                if (version == 0) {
                    versionHolder = "1.2";
                    break;
                }
                if (version == 1) {
                    versionHolder = "1.3";
                    break;
                }
                if (version == 2) {
                    versionHolder = "1.4";
                    break;
                }
                versionHolder = "5.0";
                break;
            }
            case 3: {
                if (version == 0) {
                    versionHolder = "1.1";
                    break;
                }
                if (version == 1) {
                    versionHolder = "2.0";
                    break;
                }
                if (version == 2) {
                    versionHolder = "2.1";
                    break;
                }
                versionHolder = "3.0";
                break;
            }
            case 2: {
                if (version == 0) {
                    versionHolder = "1.0";
                    break;
                }
                if (version == 1) {
                    versionHolder = "1.0";
                    break;
                }
                versionHolder = "1.5";
                break;
            }
            case 4: {
                versionHolder = version == 0 ? "2.2" : (version == 1 ? "2.3" : (version == 2 ? "2.4" : "2.5"));
            }
        }
        return versionHolder;
    }

    protected static Object createParams(EAttributeDescriptor att) {
        if (paramCount == 0) {
            ++paramCount;
            return null;
        }
        if (paramCount == 1) {
            ++paramCount;
            return "";
        }
        String r = "";
        int i = 1;
        while (i < paramCount) {
            r = String.valueOf(r) + EMFAttributeFeatureGenerator.generateRandomAttributeString(att) + " ";
            ++i;
        }
        if (++paramCount == 5) {
            paramCount = 0;
        }
        return r;
    }

    protected static Object createLang(EAttributeDescriptor att) {
        String name = langArray[langCount];
        if (++langCount == 7) {
            langCount = 0;
        }
        return name;
    }

    protected static Object createCollection(EAttributeDescriptor att) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(EMFAttributeFeatureGenerator.generateRandomAttributeString(att));
        return list;
    }

    protected static Object generateRandomObject(EAttributeDescriptor att) {
        return EMFAttributeFeatureGenerator.generateRandomAttributeString(att);
    }

    protected static Object createEnum(EAttributeDescriptor att) {
        EList literals;
        int size;
        int pos;
        EEnum anEnum = (EEnum)att.getFeature().getEType();
        if (!enumMap.containsKey(att)) {
            if (att.getFeature().getName().equals("authMethod")) {
                enumMap.put(att, new Integer(1));
            } else {
                enumMap.put(att, new Integer(0));
            }
        }
        if ((pos = ((Integer)enumMap.get(att)).intValue()) == (size = (literals = anEnum.getELiterals()).size())) {
            pos = 0;
        }
        Enumerator holder = anEnum.getEEnumLiteral(pos).getInstance();
        enumMap.put(att, new Integer(++pos));
        return holder;
    }

    public static Object generateRandomClassname(EAttributeDescriptor att) {
        return "com.foo." + EMFAttributeFeatureGenerator.generateRandomAttributeString(att);
    }

    protected static Object generateRandomShort(EAttributeDescriptor att) {
        return new Short(Short.parseShort(String.valueOf(EMFAttributeFeatureGenerator.generateNumber(att))));
    }

    protected static Object generateRandomDouble() {
        return new Double(randomGenerator.nextDouble());
    }

    protected static Object generateRandomByte() {
        return new Byte("byte");
    }

    protected static Object generateRandomLong() {
        return new Long(randomGenerator.nextLong());
    }

    protected static Object generateRandomChar(EAttributeDescriptor att) {
        return new Character(EMFAttributeFeatureGenerator.generateRandomAttributeString(att).charAt(0));
    }

    protected static Object generateRandomFloat(EAttributeDescriptor att) {
        return new Float(randomGenerator.nextFloat());
    }

    protected static Object generateRandomInteger(EAttributeDescriptor att) {
        return new Integer(EMFAttributeFeatureGenerator.generateNumber(att));
    }

    protected static Object generateRandomQName(EAttributeDescriptor att) {
        char[] charArray = Integer.toString(EMFAttributeFeatureGenerator.generateNumber(att)).toCharArray();
        int i = 0;
        while (i < charArray.length) {
            int j = 0;
            while (j < charToIntMapping.length) {
                if (charArray[i] == charToIntMapping[j]) {
                    charArray[i] = intToCharMapping[j];
                    break;
                }
                ++j;
            }
            ++i;
        }
        return new String(charArray);
    }

    protected static Object generateRandomBoolean(EAttributeDescriptor att) {
        Boolean holder;
        if (!booleanMap.containsKey(att)) {
            booleanMap.put(att, new Boolean(true));
        }
        booleanMap.put(att, new Boolean((holder = (Boolean)booleanMap.get(att)) == false));
        return holder;
    }

    public static String generateRandomAttributeString(EAttributeDescriptor att) {
        return String.valueOf(att.getFeature().getName()) + "_" + EMFAttributeFeatureGenerator.generateNumber(att);
    }

    protected static int generateNumber(EAttributeDescriptor att) {
        if (!specialNumberGen) {
            return count++;
        }
        if (!attIndex.containsKey(att)) {
            attIndex.put(att, new Integer(0));
        }
        int holder = (Integer)attIndex.get(att);
        attIndex.put(att, new Integer(holder + 1));
        return holder;
    }

    public static void reset() {
        count = 0;
        enumMap = new HashMap();
        httpArrayIndex = 0;
        paramCount = 0;
        langCount = 0;
        booleanMap = new HashMap();
        attIndex = new HashMap();
        specialNumberGen = false;
        TestUtilities.reset();
        J2EEVersionCheck.cur_Tags = null;
    }
}

